/* 
	WARMAKER v1.0
	===================
	
	Commands	
	* Admin
		amx_wm_start - Start the Match.
		amx_wm_stop - Stop the Match.
		amx_wm_live - Makes the LIVE script (Reset team's score).
	* Clients
		say/say_team !ready/!rdy - Define player as Ready.
		say/say_team !notready/!nrdy - Define player as Not Ready.
		say/say_team !score - Show the score at chat.
		
	
	Credits
		kforce - Main code
*/

#include <amxmodx>
#include <amxmisc>
#include <cstrike>
#include <fakemeta>

#define ADMIN_ACESS ADMIN_BAN

#define VERSAO "1.1"

new team1_name[32]
new team1_score = 0
new team1_p2_score = 0

new team2_name[32]
new team2_score = 0
new team2_p2_score = 0

new roundcount = 0

new readycount = 0

new bool:war
new bool:live
new bool:segparte
new bool:jgdrpronto[32]
new bool:jgdrmsg[32]

// Cvars
new cvar_team1name
new cvar_team2name
new cvar_prefixo
new cvar_autolive		
new cvar_autorec		
new cvar_plrneed		
new cvar_switchround
new cvar_blockchangeteam
new cvar_roundsdraw
new cvar_roundswin

new const saycmds[10][] = {
	"ready", "clcmd_ready",
	"rdy", "clcmd_ready",
	"notready", "clcmd_nready",
	"nrdy", "clcmd_nready",
	"score", "clcmd_score"
}

public plugin_init() 
{
	register_plugin("WARMAKER", VERSAO, "kforce")
	
	register_concmd("amx_wm_start", "concmd_start", ADMIN_ACESS)
	register_concmd("amx_wm_stop", "concmd_stop", ADMIN_ACESS)
	register_concmd("amx_wm_live", "concmd_live", ADMIN_ACESS)
	
	new i, x
	for(i = 0; i < 10; i++) 
	{
		x = i + 1
		new comando[32]
		format(comando, sizeof(comando), "say !%s", saycmds[i])
		register_clcmd(comando, saycmds[x])
		format(comando, sizeof(comando), "say_team !%s", saycmds[i])
		register_clcmd(comando, saycmds[x])
		i++
	}
	
	register_clcmd("chooseteam", "clcmd_blockteam")
	register_clcmd("jointeam", "clcmd_blockteam")
	
	cvar_team1name = register_cvar("amx_wm_equipa1", "Counter-Terrorists")
	cvar_team2name = register_cvar("amx_wm_equipa2", "Terrorists")
	cvar_prefixo = register_cvar("amx_wm_prefixo", "[WARMAKER]")
	cvar_autolive = register_cvar("amx_wm_autolive", "1")
	cvar_autorec = register_cvar("amx_wm_autorec", "1")
	cvar_plrneed = register_cvar("amx_wm_playerneed", "10")
	cvar_roundswin = register_cvar("amx_wm_winrounds", "16")	
	cvar_roundsdraw = register_cvar("amx_wm_rounddraw", "15")
	cvar_switchround = register_cvar("amx_wm_switchround", "15")
	cvar_blockchangeteam = register_cvar("amx_wm_blockchangeteam", "1")
	
	register_event("SendAudio","event_EndRound","a","2=%!MRAD_terwin","2=%!MRAD_ctwin")
	register_event("ResetHUD", "event_ResetHud", "b");
	
	set_task(1.0, "executarConfig")
	
}


public concmd_start(id, level, cid) 
{

	if(!cmd_access(id, level, cid, 0))
		return PLUGIN_HANDLED
		
	if(live)
	{
		console_print(id, "[WARMAKER] The game is LIVE. Use amx_wm_stop first.")
		return PLUGIN_HANDLED
	}
	
	if(!segparte) 
	{
		console_print(id, "[WARMAKER] Starting the match.")
		
		reniciar_dados()
		
		war = true
		
		if(get_pcvar_num(cvar_autorec))
			pov_record()
			
		if(get_pcvar_num(cvar_autolive))
			set_task(1.0, "executar_lo3")
		else
		{
			chatprint(0, "A War was started.")
			chatprint(0, "Its required %i players ready to execute Live on three restarts", get_pcvar_num(cvar_plrneed))
			chatprint(0, "Say ^x03!ready^x01 if you are ready to play.")
		}
	}
	return PLUGIN_HANDLED
}

public concmd_stop(id, level, cid)
{

	if(!cmd_access(id, level, cid, 0))
		return PLUGIN_HANDLED
		
	if(!war)
	{
		console_print(id, "[WARMAKER] The war was stopped.")
		return PLUGIN_HANDLED
	}
	
	war = false
	live = false
	
	return PLUGIN_HANDLED
}

public concmd_live(id, level, cid)
{

	if(!cmd_access(id, level, cid, 0))
		return PLUGIN_HANDLED
		
	executar_lo3()
	
	return PLUGIN_HANDLED
}

public clcmd_ready(id)
{

	if(!war)
		return PLUGIN_CONTINUE
		

	if(live)
		return PLUGIN_CONTINUE
	

	if(jgdrpronto[id])
	{
		chatprint(id, "You are ready.")
		return PLUGIN_HANDLED
	}
	else
	{

		jgdrpronto[id] = true

		readycount++
		
		new jgdrnome[32]

		get_user_name(id, jgdrnome, 32)
		
		chatprint(0, "The player ^x03%s^x01 is now ready!", jgdrnome)
			
		if(readycount == get_pcvar_num(cvar_plrneed)) 
		{
			
			chatprint(0, "All required players are now ready.")
			
			war = true
			
			if(get_pcvar_num(cvar_autorec))
				pov_record()
			
			set_task(1.0, "executar_lo3")
		}
	}
	
	return PLUGIN_CONTINUE
}

public clcmd_nready(id)
{

	if(live)
		return PLUGIN_CONTINUE
	

	if(!jgdrpronto[id])
	{
		chatprint(id, "You are not ready.")
		return PLUGIN_HANDLED
	}
	else
	{

		jgdrpronto[id] = false
		
		readycount--
		
		new jgdrnome[32]
		
		get_user_name(id, jgdrnome, 31)
		
		chatprint(0, "The player ^x03%s^x01 is not ready.", jgdrnome)
	}
		
	return PLUGIN_CONTINUE
}

public clcmd_score(id)
{
	if(!war)
		return PLUGIN_CONTINUE
		
	get_pcvar_string(cvar_team1name, team1_name, 31)
	get_pcvar_string(cvar_team2name, team2_name, 31)
	
	chatprint(id, "Score: ^x03%s^x01 %d - %d ^x03%s^x01", team1_name, team1_score, team2_score, team2_name)
	
	return PLUGIN_CONTINUE
}

public clcmd_blockteam(id)
{

	if(!live)
		return PLUGIN_CONTINUE
		

	if(get_pcvar_num(cvar_blockchangeteam))
	{
		chatprint(id, "You cant change team.")
		return PLUGIN_HANDLED
	}
	
	return PLUGIN_CONTINUE
}



public client_connect(id)
{
	client_cmd(id, "echo =====================================================")
	client_cmd(id, "echo This server use WARMAKER plugin created by kforce")
	client_cmd(id, "echo =====================================================")
}


public client_disconnect(id)
{
	if(jgdrpronto[id])
	{
		jgdrpronto[id] = false

		readycount--
	}
}


public event_ResetHud(id)
{
	if(is_user_alive(id))
	{
		if(!jgdrmsg[id])
		{
			new cvar_hostname = get_cvar_pointer("hostname")
			new hostname[65]
			get_pcvar_string(cvar_hostname, hostname, 64)
			chatprint(id, "Wellcome to the server ^x03%s^x01", hostname)
			chatprint(id, "This server use ^x03WARMAKER v%s^x01 by ^x03kforce", VERSAO)
			jgdrmsg[id] = true
		}
		
	}
	
}

public event_EndRound()
{
	get_pcvar_string(cvar_team1name, team1_name, 31)
	get_pcvar_string(cvar_team2name, team2_name, 31)
	
	if(live)
	{
		new numroundswin = get_pcvar_num(cvar_roundswin)
		new numroundsdraw = get_pcvar_num(cvar_roundsdraw)
		
		new msg[32]
		read_data(2,msg,32)
		
		if(containi(msg,"ct") != -1) 
		{
			if(segparte)
				team2_score++
			else
				team1_score++
		}
		
		else if(contain(msg,"ter") != -1) 
		{
			if(segparte)
				team1_score++
			else
				team2_score++
		}
		
		if(team1_score == numroundswin) 
		{
			chatprint(0, "The team ^x03%s^x01 won the war!", team1_name)
			chatprint(0, "Results: ^x03%s^x01 %d - %d ^x03%s^x01", team1_name, team1_score, team2_score, team2_name)
			live = false
			war = false
			reniciar_dados()
			return PLUGIN_HANDLED
		}

		else if(team2_score == numroundswin) 
		{
			chatprint(0, "The team ^x03%s^x01 won the war!", team2_name)
			chatprint(0, "Results: ^x03%s^x01 %d - %d ^x03%s^x01", team1_name, team1_score, team2_score, team2_name)
			live = false
			war = false
			reniciar_dados()
			return PLUGIN_HANDLED
		}
		
		else if(team1_score == numroundsdraw && team2_score == numroundsdraw)
		{
			chatprint(0, "The war was end with a draw.")
			chatprint(0, "Results: ^x03%s^x01 %d - %d ^x03%s^x01", team1_name, team1_score, team2_score, team2_name)
			live = false
			war = false
			reniciar_dados()
			return PLUGIN_HANDLED
		}
		
		else 
		{
			roundcount++
			
			if(roundcount == get_pcvar_num(cvar_switchround)) 
			{
				live = false
				chatprint(0, "End of first part!")
				chatprint(0, "Score: ^x03%s^x01 %d - %d ^x03%s^x01", team1_name, team1_score, team2_score, team2_name)
				chatprint(0, "Swithing teams...")
				
				segparte = true
				team1_p2_score = team1_score
				team2_p2_score = team2_score
				set_task(1.0, "trocar_equipas")
				
				if(get_pcvar_num(cvar_autolive))
					set_task(1.0, "executar_lo3")
			}
		}
		
	}
	return PLUGIN_CONTINUE
}

public executar_lo3() 
{

	if(!war)
		return PLUGIN_HANDLED
	
	if(segparte)
	{
		team1_score = team1_p2_score
		team2_score = team2_p2_score
		roundcount = 15
	}
	else 
	{
		team1_score = 0
		team2_score = 0
		roundcount = 0
	}
	
	chatprint(0, "Live on 3 restarts.")
	set_task(3.0, "lo3_rr1")
	return PLUGIN_CONTINUE
}

public lo3_rr1() 
{
	if(!war)
		return PLUGIN_HANDLED
	
	server_cmd("sv_restart 1")
	chatprint(0, "Restart #1")
	set_task(3.0, "lo3_rr2")
	return PLUGIN_CONTINUE
}

public lo3_rr2()
{

	if(!war)
		return PLUGIN_HANDLED
	
	server_cmd("sv_restart 1")
	chatprint(0, "Restart #2")
	set_task(3.0, "lo3_rr3")
	return PLUGIN_CONTINUE
}

public lo3_rr3()
{
	if(!war)
		return PLUGIN_HANDLED
	
	server_cmd("sv_restart 1")
	
	set_task(2.0, "lo3_saylive")
	
	return PLUGIN_CONTINUE
}

public lo3_saylive()
{

	if(!war)
		return PLUGIN_HANDLED
	
	chatprint(0, "LIVE")
	chatprint(0, "LIVE")
	chatprint(0, "LIVE")
	chatprint(0, "GL & HF")
	client_print(0, print_center, "Good Luck & Have Fun")
	live = true
	
	return PLUGIN_CONTINUE
}


public reniciar_dados() 
{
	team1_score = 0
	team2_score = 0
	team1_p2_score = 0
	team2_p2_score = 0
	roundcount = 0
	segparte = false
	readycount = 0
	
	for(new i; i < 32; i++)
		jgdrpronto[i] = false
}


public trocar_equipas() 
{
	new jogador[32], numjogadores, i
	
	get_players(jogador, numjogadores, "h") 
	
	for(i = 0; i < numjogadores; i++)
	{
		if(is_user_connected(jogador[i])) 
		{
			if(cs_get_user_team(jogador[i]) != CS_TEAM_SPECTATOR) 
			{
				if(cs_get_user_team(jogador[i]) == CS_TEAM_CT) 
					cs_set_user_team(jogador[i], CS_TEAM_T)
				else
					cs_set_user_team(jogador[i], CS_TEAM_CT)
			}
		}
	}
}

public pov_record() 
{
	
	
	new jogador[32], numjogadores, i
	
	get_players(jogador, numjogadores, "h")
	
	new time_date[32]
	new map_name[32]
	
	get_mapname ( map_name, 31 )
	
	get_time("%d-%m-%Y_%H-%M",time_date,31)
	
	get_pcvar_string(cvar_team1name, team1_name, 31)
	get_pcvar_string(cvar_team2name, team2_name, 31)
	
	for(i = 0; i < numjogadores; i++)
	{
		if(is_user_connected(jogador[i]))
		{
			if(cs_get_user_team(jogador[i]) != CS_TEAM_SPECTATOR)
			{
				new demo[256]
				
				formatex(demo, sizeof(demo), "%s vs %s %s %s", team1_name, team2_name, time_date, map_name)
				
				client_cmd(jogador[i], "stop")
				
				while(replace(demo,255,"/","_")) {}
				while(replace(demo,255,"\","_")) {}
				while(replace(demo,255,":","_")) {}
				while(replace(demo,255,"*","_")) {}
				while(replace(demo,255,"?","_")) {}
				while(replace(demo,255,">","_")) {}
				while(replace(demo,255,"<","_")) {}
				while(replace(demo,255,"|","_")) {}
				
				client_cmd(jogador[i], "record ^"%s.dem.dem^"", demo)
	
				chatprint(jogador[i], "Recording demo: ^x03%s", demo)
			}
		}
	}
	
	
}

public executarConfig() 
{
	new Cfg[64]
	get_configsdir(Cfg, 63)
	add(Cfg, 63, "/warmaker.cfg")
	
	if(file_exists(Cfg))
		server_cmd("exec %s", Cfg)
	else {
		new f = fopen(Cfg, "wt")
		fputs(f, "// This is the Config file of plugin WARMAKER^n// This file is loaded when the server starts or when map was changed..^n^n");
		
		new valortxt[32]
		
		fprintf(f, "amx_wm_autolive ^"%i^"	// Auto LO3 (skip the !ready for players to start match) ^n", get_pcvar_num(cvar_autolive))
		fprintf(f, "amx_wm_autorec ^"%i^"	// Auto Recording (POV)^n", get_pcvar_num(cvar_autorec))
		fprintf(f, "amx_wm_playerneed ^"%i^"	// Number of players required as Ready to make LO3^n", get_pcvar_num(cvar_plrneed))
		
		fprintf(f, "amx_wm_blockchangeteam ^"%i^"	// Block the changeteam and jointeam commands^n", get_pcvar_num(cvar_blockchangeteam))
		
		fprintf(f, "amx_wm_winrounds ^"%i^"	// Number of rounds required to a team win the match^n", get_pcvar_num(cvar_roundswin))
		fprintf(f, "amx_wm_rounddraw ^"%i^"	// Number of rounds required to draw^n", get_pcvar_num(cvar_roundsdraw))
		
		fprintf(f, "amx_wm_switchround ^"%i^"	// Number of rounds required to switch teams^n", get_pcvar_num(cvar_switchround))
		
		get_pcvar_string(cvar_team1name, valortxt, 31)
		fprintf(f, "amx_wm_equipa1 ^"%s^"	// Name of CT-Team when match starts^n", valortxt)
		
		get_pcvar_string(cvar_team2name, valortxt, 31)
		fprintf(f, "amx_wm_equipa2 ^"%s^"	// Name of T-Team when match starts^n", valortxt, 31)
		
		get_pcvar_string(cvar_prefixo, valortxt, 31)
		fprintf(f, "amx_wm_prefixo ^"%s^"	// Prefix of messages^n", valortxt)
		
		fclose(f)
	}
	
	register_forward(FM_GetGameDescription, "fw_nomejogo", 0)
}

public fw_nomejogo()
{
	new NomeJogo[32]
	format(NomeJogo, sizeof(NomeJogo), "WARMAKER v%s", VERSAO)
	
	forward_return(FMV_STRING, NomeJogo)
	
	return FMRES_SUPERCEDE
}

stock chatprint(target, const message[], any:...)
{
	static buffer[512], msg_SayText = 0
	if( !msg_SayText ) msg_SayText = get_user_msgid("SayText")
	
	new cvarprefixo[32]
	get_pcvar_string(cvar_prefixo, cvarprefixo, 31)
	
	if (!target)
	{
		static player, maxplayers
		maxplayers = get_maxplayers()
		
		for (player = 1; player <= maxplayers; player++)
		{
			if (!is_user_connected(player))
				continue;
			
			vformat(buffer, charsmax(buffer), message, 3)
			format(buffer, charsmax(buffer), "^x04%s^x01 %s", cvarprefixo, buffer)
			
			message_begin(MSG_ONE_UNRELIABLE, msg_SayText, _, player)
			write_byte(player)
			write_string(buffer)
			message_end()
			
		}
	}
	else
	{
		vformat(buffer, charsmax(buffer), message, 3)
		format(buffer, charsmax(buffer), "^x04%s^x01 %s", cvarprefixo, buffer)
		
		message_begin(MSG_ONE, msg_SayText, _, target)
		write_byte(target)
		write_string(buffer)
		message_end()
	}
}
