/*
	Blizzards Plugins Comply With GNU General Public License

	CS Store is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.
	
	Under no circumstances are you allowed to redistribute and/or modify
	it claming that you are the original author of such plugin/modification.
	
	CS Store is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with this program.  If not, see <http://www.gnu.org/licenses/>.
	____________________________________________________________________
	
	CS Store (c) 2013
	=================
	
	Plugin Thread
	-------------
	https://forums.alliedmods.net/showthread.php?t=216813
	
	Description
	-----------
	CS Store is like the default buy menu, but with a difference.
	your currency is Credits which is earned by killing enemies,
	the prices of guns/items should always be high as once you purchase
	them they are stored into your inventory permanetly, and can be equiped
	every round ( but only once ), items/guns can also be refunded or gifted.
	
	API
	---
	To use the API function you need to include the file thats attached cs-store.inc
	into the plugin you want it to work in. then use these natives
	get_user_credits( id ); will return the players current credits
	give_user_credits( id, 100 ); will return giving the player 100 more credits
	
	Commands
	--------
	say /store - opens up the CS Store Main Menu to select a catagory to buy from.
	say /shop - opens up the CS Store Main Menu to select a catagory to buy from.
	say /inv - opens up the CS Store Main Menu to select a catagory to buy from.
	say /inventory - opens up the CS Store Main Menu to select a catagory to buy from.
	say /credits - enables or disables showing the HUD Message of how many credits you have.
	say /help - opens up a MOTD window showing the plugin commands and what they do.
	
	Credits
	-------
	ConnorMcleod	- Enum optimize and nVault save/load optimize.
			- Suggesting putting stocks in sma instead of inc file.
			
	hornet		- helping with API
	
	ChangeLog
	---------
	May 30/05/2013
	- v1.0.2b - 	[ ADDED ] API - give credits | get credits
	
	May 26/05/2013
	- v1.0.1b -	[ ADDED ] Stocks from include file ( to compile from site )
	
	May 26/05/2013 
	- v1.0.0b - 	inital public release.
*/

#include < amxmodx >
#include < amxmisc >
#include < fun >
#include < hamsandwich >
#include < fakemeta >
#include < cstrike >
#include < nvault >

#pragma semicolon 1

#define PLUGIN "CS Store"
#define VERSION "1.0.2b"
#define AUTHOR "Blizzard"

#define PREFIX "!g[ CS Store ]!n"

#define MAX_PISTOL 6
#define MAX_SHOTGUN 2
#define MAX_SMG 5
#define MAX_RIFLE 10
#define MAX_EQUIP 8

// Callbacks
new g_PistolCallback, g_ShotgunBallback, g_SmgCallback, g_RifleCallback, g_M249Callback, g_EquipCallback;
new g_PistolInv, g_ShotgunInv, g_SmgInv, g_RifleInv, g_ParaInv, g_EquipInv;
new g_AliveCallback;

// Bools
new bool:g_bShowCredits[ 33 ];
new bool:g_bEquipedSecondary[ 33 ];
new bool:g_bEquipedPrimary[ 33 ];
new bool:g_bEquipedItem[ 33 ][ 8 ];

// Integers
new g_iInvType[ 33 ] = 0;
new g_iItemType[ 33 ] = 0;
new g_iItem[ 33 ];
new g_iGiftFrom;
new g_iCredits[ 33 ];

// Enum
enum _:SayCmds {
	Say[ 32 ], Func[ 32 ]
};

enum _:GunItems {
	GunName[ 64 ], GunWeapon[ 64 ], csw, ammo
};

enum _:mSaveDatas {
	m_iPistols[ 6 ],
	m_iShotGuns[ 2 ],
	m_iSmgs[ 5 ],
	m_iRiffles[ 10 ],
	m_iMachineGun,
	m_iEquipments[ 8 ]
};

enum /* Weapon types */
{
	Primary = 1
	, Secondary
	, Knife
	, Grenades
	, C4
};

// Variables
new g_mPlayerStore[ 33 ][ mSaveDatas + 1 ];

//Constants
new const g_mPistols[ MAX_PISTOL ][ GunItems ] = {
	{ "USP", "weapon_usp", CSW_USP, 100 }, // = 0
	{ "Glock", "weapon_glock18", CSW_GLOCK18, 120 }, // = 1
	{ "Deagle", "weapon_deagle", CSW_DEAGLE, 35 }, // = 2
	{ "228 Compact", "weapon_p228", CSW_P228, 52 }, // =3
	{ "Dual Elites", "weapon_elite", CSW_ELITE, 120 }, // = 4
	{ "Five-Seven", "weapon_fiveseven", CSW_FIVESEVEN, 100 } // = 5
};

new const g_mShotguns[ MAX_SHOTGUN ][ GunItems ] = {
	{ "Pump Shotgun", "weapon_m3", CSW_M3, 32 }, // = 0
	{ "Auto Shotgun", "weapon_xm1014", CSW_XM1014, 32 } // = 1
};

new const g_mSmgs[ MAX_SMG ][ GunItems ] = {
	{ "MP5", "weapon_mp5navy", CSW_MP5NAVY, 120 }, // = 0
	{ "TMP", "weapon_tmp", CSW_TMP, 120 }, // = 1
	{ "P90", "weapon_p90", CSW_P90, 100 }, // = 2
	{ "Mac10", "weapon_mac10", CSW_MAC10, 100 }, // = 3
	{ "UMP", "weapon_ump45", CSW_UMP45, 100 } // = 4
};

new const g_mRifles[ MAX_RIFLE ][ GunItems ] = {
	{ "Clarion", "weapon_famas", CSW_FAMAS, 90 }, // = 0
	{ "Krieg SG552", "weapon_sg552", CSW_SG552, 90 }, // = 1
	{ "AK47", "weapon_ak47", CSW_AK47, 90 }, // = 2
	{ "M4A1", "weapon_m4a1", CSW_M4A1, 90 }, // = 3
	{ "Bullpup", "weapon_aug", CSW_AUG, 90 }, // = 4
	{ "Scout", "weapon_scout", CSW_SCOUT, 90 }, // = 5
	{ "AWP", "weapon_awp", CSW_AWP, 90 }, // = 6
	{ "CT AutoSniper", "weapon_g3sg1", CSW_G3SG1, 90 }, // = 7
	{ "T AutoSniper", "weapon_sg550", CSW_SG550, 90 }, // = 8
	{ "Galil", "weapon_galil", CSW_GALIL, 90 } // = 9
};

new const g_mPara[ ][ GunItems ] = {
	{ "M249 ( Para )", "weapon_m249", CSW_M249, 200 } // = 0
};

new const g_mEquipments[ MAX_EQUIP ][ GunItems ] = {
	{ "Kevlar", "item_kevlar" }, // 0
	{ "Kevlar + Helmet", "item_assaultsuit" }, // = 1
	{ "Flashbang Grenade", "weapon_flashbang", CSW_FLASHBANG, 2 }, // = 2
	{ "HE Grenade", "weapon_hegrenade", CSW_HEGRENADE, 1 }, // = 3
	{ "Smoke Grenade", "weapon_smokegrenade", CSW_SMOKEGRENADE, 1 }, // = 4
	{ "Defusal Kit", "item_thighpack" }, // = 5
	{ "Nighvision Goggles", "item_nvgs" }, // = 6
	{ "Shield", "weapon_shield" } // = 7
};

new const g_szMenuCatagories[ ][ ] = {
	"Pistols", // = 0
	"Shotguns", // = 1
	"SMGs", // = 2
	"Rifles", // = 3
	"Machine Guns", // = 4
	"Equipment" // = 5
};

new const g_szSayCmds[ ][ SayCmds ] = {
	{ "say /shop", "cmdStoreMain" },
	{ "say /store", "cmdStoreMain" },
	{ "say /inv", "cmdInventoryMain" },
	{ "say /inventory", "cmdInventoryMain" },
	{ "say /credits", "cmdShowCreditHud" },
	{ "say /help", "cmdHelp" }
};

// Pcvars
new g_pPistolCost[ MAX_PISTOL ], g_pShotgunCost[ MAX_SHOTGUN ], g_pSmgCost[ MAX_SMG ];
new g_pRifleCost[ MAX_RIFLE ], g_pEquipCost[ MAX_EQUIP ], g_pM249Cost;
new g_pHsBonus, g_pKillBonus, g_pLowHpBonus;
new g_iVault, g_pSaveCredits;
new g_pAdvert; 

public plugin_init( ) 
{
	register_plugin( PLUGIN, VERSION, AUTHOR );
	server_print( "^n^t%s v%s, Copyright (C) 2013 by %s^n", PLUGIN, VERSION, AUTHOR );
	register_cvar( "csstore_version", VERSION, FCVAR_SERVER|FCVAR_SPONLY );
	
	register_event( "DeathMsg", "Event_DeathMsg", "a" );
	RegisterHam( Ham_Spawn, "player", "CBase_PlayerPost_Spawn", 1 );
	
	g_PistolCallback = menu_makecallback( "PistolInvCheck" );
	g_ShotgunBallback = menu_makecallback( "ShotgunInvCheck" );
	g_SmgCallback = menu_makecallback( "SmgInvCheck" );
	g_RifleCallback = menu_makecallback( "RifleInvCeck" );
	g_M249Callback = menu_makecallback( "M249InvCheck" );
	g_EquipCallback = menu_makecallback( "EquipInvCheck" );
	
	g_PistolInv = menu_makecallback( "MyPistolInv" );
	g_ShotgunInv = menu_makecallback( "MyShotgunInv" );
	g_SmgInv = menu_makecallback( "MySmgInv" );
	g_RifleInv = menu_makecallback( "MyRifleInv" );
	g_ParaInv = menu_makecallback( "MyParaInv" );
	g_EquipInv = menu_makecallback( "MyEquipInv" );
	
	g_AliveCallback = menu_makecallback( "AliveCheck" );
	
	g_pPistolCost[ 0 ] = register_cvar( "cs_store_usp", "1" );
	g_pPistolCost[ 1 ] = register_cvar( "cs_store_glock", "2" );
	g_pPistolCost[ 2 ] = register_cvar( "cs_store_deagle", "3" );
	g_pPistolCost[ 3 ] = register_cvar( "cs_store_p228", "3" );
	g_pPistolCost[ 4 ] = register_cvar( "cs_store_elite", "4" );
	g_pPistolCost[ 5 ] = register_cvar( "cs_store_fiveseven", "5" );
	
	g_pShotgunCost[ 0 ] = register_cvar( "cs_store_pumpshotgun", "15" );
	g_pShotgunCost[ 1 ] = register_cvar( "cs_store_autoshotgun", "20" );
	
	g_pSmgCost[ 0 ] = register_cvar( "cs_store_mp5", "15" );
	g_pSmgCost[ 1 ] = register_cvar( "cs_store_tmp", "15" );
	g_pSmgCost[ 2 ] = register_cvar( "cs_store_p90", "15" );
	g_pSmgCost[ 3 ] = register_cvar( "cs_store_mac10", "15" );
	g_pSmgCost[ 4 ] = register_cvar( "cs_store_ump", "15" );
	
	g_pRifleCost[ 0 ] = register_cvar( "cs_store_famas", "20" );
	g_pRifleCost[ 1 ] = register_cvar( "cs_store_sg552", "20" );
	g_pRifleCost[ 2 ] = register_cvar( "cs_store_ak47", "20" );
	g_pRifleCost[ 3 ] = register_cvar( "cs_store_m4a1", "20" );
	g_pRifleCost[ 4 ] = register_cvar( "cs_store_aug", "20" );
	g_pRifleCost[ 5 ] = register_cvar( "cs_store_scout", "20" );
	g_pRifleCost[ 6 ] = register_cvar( "cs_store_awp", "20" );
	g_pRifleCost[ 7 ] = register_cvar( "cs_store_g3sg1", "20" );
	g_pRifleCost[ 8 ] = register_cvar( "cs_store_sg550", "20" );
	g_pRifleCost[ 9 ] = register_cvar( "cs_store_galil", "20" );
	
	g_pM249Cost = register_cvar( "cs_store_m249", "25" );
	
	g_pEquipCost[ 0 ] = register_cvar( "cs_store_kevlar", "15" );
	g_pEquipCost[ 1 ] = register_cvar( "cs_store_assaultsuit",  "20" );
	g_pEquipCost[ 2 ] = register_cvar( "cs_store_flashbang", "15" );
	g_pEquipCost[ 3 ] = register_cvar( "cs_store_hegrenade", "20" );
	g_pEquipCost[ 4 ] = register_cvar( "cs_store_smokegrenade", "15" );
	g_pEquipCost[ 5 ] = register_cvar( "cs_store_defuse", "15" );
	g_pEquipCost[ 6 ] = register_cvar( "cs_store_goggles", "15" );
	g_pEquipCost[ 7 ] = register_cvar( "cs_store_shield", "20" );
	
	g_pKillBonus = register_cvar( "cs_store_kill_bonus", "1" );
	g_pHsBonus = register_cvar( "cs_store_hs_bonus", "2" );
	g_pLowHpBonus = register_cvar( "cs_store_lowhp_bonus", "3" );
	
	g_pAdvert = register_cvar( "cs_store_advert_time", "60.0" );
	g_pSaveCredits = register_cvar( "cs_store_credits_save", "0" );
	
	for( new i = 0; i < sizeof( g_szSayCmds ); i++ )
		register_clcmd( g_szSayCmds[ i ][ Say ], g_szSayCmds[ i ][ Func ], 0 );

	set_task( get_pcvar_float( g_pAdvert ), "Store_Adverts", _, _, _, "b" );
}

public plugin_natives( ) {
	register_library( "cs-store" );
	register_native( "give_user_credits", "_give_user_credits" );
	register_native( "get_user_credits", "_get_user_credits" );
}

public plugin_cfg( ) {
	g_iVault = nvault_open( "CS-Store" );
	loadConfigs();
}

public loadConfigs(){
	new file[64];
	get_configsdir(file, 63);
	
	format(file, 63, "%s/csstore.cfg", file);
	
	if(!file_exists(file)) {
		server_print("[ %s ] Config File: csstore.cfg not found", PREFIX);
	}
	
	else if(file_exists(file))  {
		server_cmd("exec %s", file);
	}
}

public client_authorized(id) {
	if( nvault_get( g_iVault, GETPLAYERAUTHID( id, true ), g_mPlayerStore[ id ], charsmax( g_mPlayerStore[ ] ) ) ) {
		for( new i; i < sizeof( g_mPlayerStore[ ] ); i++ ) {
			g_mPlayerStore[ id ][ i ] -= '0';
		}
	}
}

GETPLAYERAUTHID( id, bGet = false ) {
	static szAuthid[ 33 ][ 32 ];
	if( bGet ) {
		get_user_authid( id, szAuthid[ id ], charsmax( szAuthid[ ] ) );
	}
	return szAuthid[ id ];
}

public client_connect( id ) {
	if( get_pcvar_num( g_pSaveCredits ) ) LoadCredits( id );	
	g_bShowCredits[ id ] = true;
	set_task( 0.5, "ShowCreditHud", id, _, _, "b" );
}

public client_disconnect( id ) {
	for(new i; i < sizeof( g_mPlayerStore[ ] ); i++ ) {
		g_mPlayerStore[ id ][ i ] += '0';
	}
	nvault_set( g_iVault, GETPLAYERAUTHID( id ), g_mPlayerStore[ id ] );
	if( get_pcvar_num( g_pSaveCredits ) ) SaveCredits( id );
}

public plugin_end( ) {
	nvault_close( g_iVault );
}

public Store_Adverts( id ) {
	switch( random_num( 0, 2 ) ) {
		case 0: Color( 0, "!gThis Server Is Running !t%s v%s !gBy:!t %s", PLUGIN, VERSION, AUTHOR );
		case 1: Color( 0, "%s To Understand Store Commands Please View The Help MOTD !gsay /help!n", PREFIX );
		case 2: Color( 0, "%s You Earn Credits By Killing, !g%i!n Per Kill, !g%i!n Per HS, !g%i!n Per 1HP Kill", PREFIX, get_pcvar_num( g_pKillBonus ), get_pcvar_num( g_pHsBonus ), get_pcvar_num( g_pLowHpBonus ) );
	}
}

public CBase_PlayerPost_Spawn( id ) {
	if( is_user_alive( id ) ) {
		for( new i = 0; i < 8; i++ )
			g_bEquipedItem[ id ][ i ] = false;
		g_bEquipedPrimary[ id ] = false;
		g_bEquipedSecondary[ id ] = false;
	}
}

public cmdShowCreditHud( id ) {
	g_bShowCredits[ id ] = !g_bShowCredits[ id ];
	if( g_bShowCredits[ id ] ) set_task( 0.5, "ShowCreditHud", id, _, _, "b" );
}

public ShowCreditHud( id ) {
	if( g_bShowCredits[ id ] ) {
		set_hudmessage(200, 100, 0, 0.01, 0.18, 0, 0.5, 0.5, 0.6, 0.6, 1);
		show_hudmessage(id, "%s: %i Credits", PLUGIN, g_iCredits[ id ] );
	}
	else return;
}

public Event_DeathMsg( ) {
	new iKiller = read_data( 1 );
	new iVictim = read_data( 2 );
	new HeadShot = read_data( 3 );
	
	if( iVictim != iKiller ) {
		if( get_user_health( iKiller ) == 1 ) {
			g_iCredits[ iKiller ] += get_pcvar_num( g_pLowHpBonus );
			return PLUGIN_HANDLED;
		}
		else if( HeadShot ) {
			g_iCredits[ iKiller ] += get_pcvar_num( g_pHsBonus );
			return PLUGIN_HANDLED;
		}
		else g_iCredits[ iKiller ] += get_pcvar_num( g_pKillBonus );
		
	}
	return PLUGIN_HANDLED;
}

public cmdStoreMain( id ) {
	new Title[ 101 ];
	formatex( Title, charsmax( Title ), "%s:^n^nInventory Credits ( \r%i\y )", PLUGIN, g_iCredits[ id ] );
	new menu = menu_create( Title, "cmdStoreMain_handler" );
	
	for( new i = 0; i < sizeof( g_szMenuCatagories ); i++ )
		menu_additem( menu, g_szMenuCatagories[ i ] );
		
	menu_display( id, menu, 0 );
	return PLUGIN_HANDLED;
}

public cmdStoreMain_handler( id, menu, item ) {
	if( item == MENU_EXIT ) {
		menu_destroy( menu );
		return PLUGIN_HANDLED;
	}
	
	switch( item ) {
		case 0: ShowPistolMenu( id );
		case 1: ShowShotgunMenu( id );
		case 2: ShowSmgMenu( id );
		case 3: ShowRifleMenu( id );
		case 4: ShowM249Menu( id );
		case 5: ShowEquipMenu( id );
	}
	
	menu_destroy( menu );
	return PLUGIN_HANDLED;
}

public ShowPistolMenu( id ) { 
	new Title[ 101 ];
	formatex( Title, charsmax( Title ), "%s: Pistols ( \r%i Credits\y )", PLUGIN, g_iCredits[ id ] );
	new menu = menu_create( Title, "ShowPistolMenu_Handler" );
	
	for( new i = 0; i < sizeof( g_mPistols ); i++ ) {
		new iCost = get_pcvar_num( g_pPistolCost[ i ] );
		formatex( Title, charsmax( Title ), "%s ( %i Credits ) %s", g_mPistols[ i ][ GunName ], iCost, g_mPlayerStore[ id ][ m_iPistols ][ i ] ? "Purchased" : "" );
		menu_additem( menu, Title, _, _, g_PistolCallback);
	}
		
	menu_setprop( menu, MPROP_EXITNAME, "Main Menu" );
	menu_display( id, menu, 0 );
	return PLUGIN_HANDLED;
}

public PistolInvCheck( id, menu, item ) {
	if( g_mPlayerStore[ id ][ m_iPistols ][ item ] )
		return ITEM_DISABLED;
	else if( g_iCredits[ id ] < get_pcvar_num( g_pPistolCost[ item ] ) )
		return ITEM_DISABLED;
	
	return ITEM_ENABLED;
}

public ShowPistolMenu_Handler( id, menu, item ) {
	if( item == MENU_EXIT ) {
		menu_destroy( menu );
		cmdStoreMain( id );
		return PLUGIN_HANDLED;
	}
	
	new iCost = get_pcvar_num( g_pPistolCost[ item ] );
	
	g_mPlayerStore[ id ][ m_iPistols ][ item ] = true;
	g_iCredits[ id ] -= iCost;
	Color( id, "%s Your Purchase !g%s!n Has Been Added To Your !tInventory !n( !g%s!n )", PREFIX, g_mPistols[ item ][ GunName ], g_szSayCmds[ 2 ][ Say ] );
	
	menu_destroy( menu );
	ShowPistolMenu( id );
	return PLUGIN_HANDLED;
}

public ShowShotgunMenu( id ) { 
	new Title[ 101 ];
	formatex( Title, charsmax( Title ), "%s: ShotGuns ( \r%i Credits\y )", PLUGIN, g_iCredits[ id ] );
	new menu = menu_create( Title, "ShowShotgunMenu_Handler" );
	
	for( new i = 0; i < sizeof( g_mShotguns ); i++ ) {
		new iCost = get_pcvar_num( g_pShotgunCost[ i ] );
		formatex( Title, charsmax( Title ), "%s ( %i Credits ) %s", g_mShotguns[ i ][ GunName ], iCost, g_mPlayerStore[ id ][ m_iShotGuns ][ i ] ? "Purchased" : "" );
		menu_additem( menu, Title, _, _, g_ShotgunBallback );
	}
		
	menu_setprop( menu, MPROP_EXITNAME, "Main Menu" );
	menu_display( id, menu, 0 );
	return PLUGIN_HANDLED;
}

public ShotgunInvCheck( id, menu, item ) {
	if( g_mPlayerStore[ id ][ m_iShotGuns ][ item ] )
		return ITEM_DISABLED;
	else if( g_iCredits[ id ] < get_pcvar_num( g_pShotgunCost[ item ] ) )
		return ITEM_DISABLED;
	
	return ITEM_ENABLED;
}

public ShowShotgunMenu_Handler( id, menu, item ) {
	if( item == MENU_EXIT ) {
		menu_destroy( menu );
		cmdStoreMain( id );
		return PLUGIN_HANDLED;
	}
	
	new iCost = get_pcvar_num( g_pShotgunCost[ item ] );
	
	g_mPlayerStore[ id ][ m_iShotGuns ][ item ] = true;
	g_iCredits[ id ] -= iCost;
	Color( id, "%s Your Purchase !g%s!n Has Been Added To Your !tInventory !n( !g%s!n )", PREFIX, g_mShotguns[ item ][ GunName ], g_szSayCmds[ 2 ][ Say ] );
	
	menu_destroy( menu );
	ShowShotgunMenu( id );
	return PLUGIN_HANDLED;
}

public ShowSmgMenu( id ) { 
	new Title[ 101 ];
	formatex( Title, charsmax( Title ), "%s: SubMachineGuns ( \r%i Credits\y )", PLUGIN, g_iCredits[ id ] );
	new menu = menu_create( Title, "ShowSmgMenu_Handler" );
	
	for( new i = 0; i < sizeof( g_mSmgs ); i++ ) {
		new iCost = get_pcvar_num( g_pSmgCost[ i ] );
		formatex( Title, charsmax( Title ), "%s ( %i Credits ) %s", g_mSmgs[ i ][ GunName ], iCost, g_mPlayerStore[ id ][ m_iSmgs ][ i ] ? "Purchased" : "" );
		menu_additem( menu, Title, _, _, g_SmgCallback );
	}
		
	menu_setprop( menu, MPROP_EXITNAME, "Main Menu" );
	menu_display( id, menu, 0 );
	return PLUGIN_HANDLED;
}

public SmgInvCheck( id, menu, item ) {
	if( g_mPlayerStore[ id ][ m_iSmgs ][ item ] )
		return ITEM_DISABLED;
	else if( g_iCredits[ id ] < get_pcvar_num( g_pSmgCost[ item ] ) )
		return ITEM_DISABLED;
	
	return ITEM_ENABLED;
}

public ShowSmgMenu_Handler( id, menu, item ) {
	if( item == MENU_EXIT ) {
		menu_destroy( menu );
		cmdStoreMain( id );
		return PLUGIN_HANDLED;
	}
	
	new iCost = get_pcvar_num( g_pSmgCost[ item ] );
	
	g_mPlayerStore[ id ][ m_iSmgs ][ item ] = true;
	g_iCredits[ id ] -= iCost;
	Color( id, "%s Your Purchase !g%s!n Has Been Added To Your !tInventory !n( !g%s!n )", PREFIX, g_mSmgs[ item ][ GunName ], g_szSayCmds[ 2 ][ Say ] );
	
	menu_destroy( menu );
	ShowSmgMenu( id );
	return PLUGIN_HANDLED;
}

public ShowRifleMenu( id ) { 
	new Title[ 101 ];
	formatex( Title, charsmax( Title ), "%s: Rifles ( \r%i Credits\y )", PLUGIN, g_iCredits[ id ] );
	new menu = menu_create( Title, "ShowRifleMenu_Handler" );
	
	for( new i = 0; i < sizeof( g_mRifles ); i++ ) {
		new iCost = get_pcvar_num( g_pRifleCost[ i ] );
		formatex( Title, charsmax( Title ), "%s ( %i Credits ) %s", g_mRifles[ i ][ GunName ], iCost, g_mPlayerStore[ id ][ m_iRiffles ][ i ] ? "Purchased" : "" );
		menu_additem( menu, Title, _, _, g_RifleCallback );
	}
		
	menu_setprop( menu, MPROP_EXITNAME, "Main Menu" );
	menu_display( id, menu, 0 );
	return PLUGIN_HANDLED;
}

public RifleInvCeck( id, menu, item ) {
	if( g_mPlayerStore[ id ][ m_iRiffles ][ item ] )
		return ITEM_DISABLED;
	else if( g_iCredits[ id ] < get_pcvar_num( g_pRifleCost[ item ] ) )
		return ITEM_DISABLED;
	
	return ITEM_ENABLED;
}

public ShowRifleMenu_Handler( id, menu, item ) {
	if( item == MENU_EXIT ) {
		menu_destroy( menu );
		cmdStoreMain( id );
		return PLUGIN_HANDLED;
	}
	
	new iCost = get_pcvar_num( g_pRifleCost[ item ] );
	
	g_mPlayerStore[ id ][ m_iRiffles ][ item ] = true;
	g_iCredits[ id ] -= iCost;
	Color( id, "%s Your Purchase !g%s!n Has Been Added To Your !tInventory !n( !g%s!n )", PREFIX, g_mRifles[ item ][ GunName ], g_szSayCmds[ 2 ][ Say ] );
	
	menu_destroy( menu );
	ShowRifleMenu( id );
	return PLUGIN_HANDLED;
}

public ShowM249Menu( id ) { 
	new Title[ 101 ];
	formatex( Title, charsmax( Title ), "%s: M249 Para ( \r%i Credits\y )", PLUGIN, g_iCredits[ id ] );
	new menu = menu_create( Title, "ShowM249Menu_Handler" );
	
	new iCost = get_pcvar_num( g_pM249Cost );
	formatex( Title, charsmax( Title ), "%s ( %i Credits ) %s", g_mPara[ 0 ][ GunName ], iCost, g_mPlayerStore[ id ][ m_iMachineGun ] ? "Purchased" : "" );
	menu_additem( menu, Title, _, _, g_M249Callback);
		
	menu_setprop( menu, MPROP_EXITNAME, "Main Menu" );
	menu_display( id, menu, 0 );
	return PLUGIN_HANDLED;
}

public M249InvCheck( id, menu, item ) {
	if( g_mPlayerStore[ id ][ m_iMachineGun ] )
		return ITEM_DISABLED;
	else if( g_iCredits[ id ] < get_pcvar_num( g_pM249Cost ) )
		return ITEM_DISABLED;
	
	return ITEM_ENABLED;
}

public ShowM249Menu_Handler( id, menu, item ) {
	if( item == MENU_EXIT ) {
		menu_destroy( menu );
		cmdStoreMain( id );
		return PLUGIN_HANDLED;
	}
	
	new iCost = get_pcvar_num( g_pM249Cost );
	
	g_mPlayerStore[ id ][ m_iMachineGun ] = true;
	g_iCredits[ id ] -= iCost;
	Color( id, "%s Your Purchase !g%s!n Has Been Added To Your !tInventory !n( !g%s!n )", PREFIX, g_mPara[ item ][ GunName ], g_szSayCmds[ 2 ][ Say ] );
	
	menu_destroy( menu );
	ShowM249Menu( id );
	return PLUGIN_HANDLED;
}

public ShowEquipMenu( id ) { 
	new Title[ 101 ];
	formatex( Title, charsmax( Title ), "%s: Equipment ( \r%i Credits\y )", PLUGIN, g_iCredits[ id ] );
	new menu = menu_create( Title, "ShowEquipMenu_Handler" );
	
	for( new i = 0; i < sizeof( g_mEquipments ); i++ ) {
		new iCost = get_pcvar_num( g_pEquipCost[ i ] );
		formatex( Title, charsmax( Title ), "%s ( %i Credits ) %s", g_mEquipments[ i ][ GunName ], iCost, g_mPlayerStore[ id ][ m_iEquipments ][ i ] ? "Purchased" : "" );
		menu_additem( menu, Title, _, _, g_EquipCallback );
	}
		
	menu_setprop( menu, MPROP_EXITNAME, "Main Menu" );
	menu_display( id, menu, 0 );
	return PLUGIN_HANDLED;
}

public EquipInvCheck( id, menu, item ) {
	if( g_mPlayerStore[ id ][ m_iEquipments ][ item ] )
		return ITEM_DISABLED;
	else if( g_iCredits[ id ] < get_pcvar_num( g_pEquipCost[ item ] ) )
		return ITEM_DISABLED;
	
	return ITEM_ENABLED;
}

public ShowEquipMenu_Handler( id, menu, item ) {
	if( item == MENU_EXIT ) {
		menu_destroy( menu );
		cmdStoreMain( id );
		return PLUGIN_HANDLED;
	}
	
	new iCost = get_pcvar_num( g_pEquipCost[ item ] );
	
	g_mPlayerStore[ id ][ m_iEquipments ][ item ] = true;
	g_iCredits[ id ] -= iCost;
	Color( id, "%s Your Purchase !g%s!n Has Been Added To Your !tInventory !n( !g%s!n )", PREFIX, g_mEquipments[ item ][ GunName ], g_szSayCmds[ 2 ][ Say ] );
	
	menu_destroy( menu );
	ShowEquipMenu( id );
	return PLUGIN_HANDLED;
}

public cmdInventoryMain( id ) {
	new Title[ 101 ];
	formatex( Title, charsmax( Title ), "%s: Inventory", PLUGIN );
	new menu = menu_create( Title, "cmdInventoryMain_handler" );
	
	formatex( Title, charsmax( Title ), "Equip %s", is_user_alive( id ) ? "" : "( Must Be Alive )" );
	menu_additem( menu, Title ,_, _, g_AliveCallback );
	menu_additem( menu, "Refund" );
	menu_additem( menu, "Gift" );
	
	menu_display( id, menu, 0 );
	return PLUGIN_HANDLED;
}

public AliveCheck( id, menu, item ) {
	if( !is_user_alive( id ) )
		return ITEM_DISABLED;
		
	return ITEM_ENABLED;
}

public cmdInventoryMain_handler( id, menu, item ) {
	if( item == MENU_EXIT ) {
		menu_destroy( menu );
		return PLUGIN_HANDLED;
	}

	switch( item ) {
		case 0: g_iInvType[ id ] = 0;
		case 1: g_iInvType[ id ] = 1;
		case 2: g_iInvType[ id ] = 2;
	}
	
	cmdInventory( id );
	
	menu_destroy( menu );
	return PLUGIN_HANDLED;
}

public cmdInventory( id ) {
	new Title[ 101 ], type[ 32 ];
	switch( g_iInvType[ id ] ) {
		case 0: copy( type, charsmax( type ), "Equip" );
		case 1: copy( type, charsmax( type ), "Refund" );
		case 2: copy( type, charsmax( type ), "Gift" );
	}
	formatex( Title, charsmax( Title ), "%s: %s Inventory Item", PLUGIN, type );
	new menu = menu_create( Title, "cmdInventory_handler" );
	
	for( new i = 0; i < sizeof( g_szMenuCatagories ); i++ )
		menu_additem( menu, g_szMenuCatagories[ i ] );
		
	menu_setprop( menu, MPROP_EXITNAME, "Inventory Main Menu" );
	menu_display( id, menu, 0 );
	return PLUGIN_HANDLED;
}

public cmdInventory_handler( id, menu, item ) {
	if( item == MENU_EXIT ) {
		cmdInventoryMain( id );
		menu_destroy( menu );
		return PLUGIN_HANDLED;
	}
	
	switch( item ) {
		case 0: MyPistolMenu( id );
		case 1: MyShotgunMenu( id );
		case 2: MySmgMenu( id );
		case 3: MyRifleMenu( id );
		case 4: MyParaMenu( id );
		case 5: MyEquipMenu( id );
	}
	
	menu_destroy( menu );
	return PLUGIN_HANDLED;
}

public MyPistolMenu( id ) { 
	new Title[ 151 ], type[ 32 ];
	switch( g_iInvType[ id ] ) {
		case 0: copy( type, charsmax( type ), "Equip" );
		case 1: copy( type, charsmax( type ), "Refund" );
		case 2: copy( type, charsmax( type ), "Gift" );
	}
	formatex( Title, charsmax( Title ), "%s: %s Pistol", PLUGIN, type );
	new menu = menu_create( Title, "MyPistolMenu_Handler" );
	
	for( new i = 0; i < sizeof( g_mPistols ); i++ ) {
		formatex( Title, charsmax( Title ), "%s %s", g_mPistols[ i ][ GunName ], g_mPlayerStore[ id ][ m_iPistols ][ i ] ? "" : "( \dNot Owned )" );
		menu_additem( menu, Title, _, _, g_PistolInv);
	}
		
	menu_setprop( menu, MPROP_EXITNAME, "Main Menu" );
	menu_display( id, menu, 0 );
	return PLUGIN_HANDLED;
}

public MyPistolInv( id, menu, item ) {
	if( item == 6 )
		return PLUGIN_HANDLED;
	else if( !g_mPlayerStore[ id ][ m_iPistols ][ item ] )
		return ITEM_DISABLED;
	else if( g_bEquipedSecondary[ id ] )
		return ITEM_DISABLED;
	
	return ITEM_ENABLED;
}

public MyPistolMenu_Handler( id, menu, item ) {
	if( item == MENU_EXIT ) {
		menu_destroy( menu );
		cmdInventory( id );
		return PLUGIN_HANDLED;
	}
	
	switch( g_iInvType[ id ] ) {
		case 0: {
			StripWeapons( id, Secondary );
			give_item( id, g_mPistols[ item ][ GunWeapon ] );
			cs_set_user_bpammo( id, g_mPistols[ item ][ csw ], g_mPistols[ item ][ ammo ] );
			g_bEquipedSecondary[ id ] = true;
			Color( id, "%s Equiped !g%s!n", PREFIX, g_mPistols[ item ][ GunName ] );
		}
		case 1: {
			new iCost = get_pcvar_num( g_pPistolCost[ item ] );
			g_mPlayerStore[ id ][ m_iPistols ][ item] = false;
			g_iCredits[ id ] += iCost;
			MyPistolMenu( id );
			Color( id, "%s You Refunded !g%s!n And Recieved !g%i!n Credits Back", PREFIX, g_mPistols[ item ][ GunName ], iCost );
		}
		case 2: {
			g_iItem[ id ] = item;
			g_iItemType[ id ] = 0;
			menu_destroy( menu );
			GiftItem( id );
			return PLUGIN_HANDLED;
		}	
	}
	
	menu_destroy( menu );
	MyPistolMenu( id );
	return PLUGIN_HANDLED;
}

public MyShotgunMenu( id ) {
	new Title[ 101 ], type[ 32 ];
	switch( g_iInvType[ id ] ) {
		case 0: copy( type, charsmax( type ), "Equip" );
		case 1: copy( type, charsmax( type ), "Refund" );
		case 2: copy( type, charsmax( type ), "Gift" );
	}
	formatex( Title, charsmax( Title ), "%s: %s Shotgun", PLUGIN, type );
	new menu = menu_create( Title, "MyShotgunMenu_Handler" );
	
	for( new i = 0; i < sizeof( g_mShotguns ); i++ ) {
		formatex( Title, charsmax( Title ), "%s %s", g_mShotguns[ i ][ GunName ], g_mPlayerStore[ id ][ m_iShotGuns ][ i ] ? "" : "( \dNot Owned )" );
		menu_additem( menu, Title, _, _, g_ShotgunInv);
	}
	
	menu_setprop( menu, MPROP_EXITNAME, "Main Menu" );
	menu_display( id, menu, 0 );
	return PLUGIN_HANDLED;
}

public MyShotgunInv( id, menu, item ) {
	if( !g_mPlayerStore[ id ][ m_iShotGuns ][ item ] )
		return ITEM_DISABLED;
	else if( g_bEquipedPrimary[ id ] )
		return ITEM_DISABLED;
	
	return ITEM_ENABLED;
}

public MyShotgunMenu_Handler( id, menu, item ) {
	if( item == MENU_EXIT ) {
		menu_destroy( menu );
		cmdInventory( id );
		return PLUGIN_HANDLED;
	}
	
	switch( g_iInvType[ id ] ) {
		case 0: {
			StripWeapons( id, Primary );
			give_item( id, g_mShotguns[ item ][ GunWeapon ] );
			cs_set_user_bpammo( id, g_mShotguns[ item ][ csw ], g_mShotguns[ item ][ ammo ] );
			g_bEquipedPrimary[ id ] = true;
			Color( id, "%s Equiped !g%s!n", PREFIX, g_mShotguns[ item ][ GunName ] );
		}
		case 1: {
			new iCost = get_pcvar_num( g_pShotgunCost[ item ] );
			g_mPlayerStore[ id ][ m_iShotGuns ][ item ] = false;
			g_iCredits[ id ] += iCost;
			MyPistolMenu( id );
			Color( id, "%s You Refunded !g%s!n And Recieved !g%i!n Credits Back", PREFIX, g_mShotguns[ item ][ GunName ], iCost );
		}
		case 2: {
			g_iItem[ id ] = item;
			g_iItemType[ id ] = 1;
			menu_destroy( menu );
			GiftItem( id );
			return PLUGIN_HANDLED;
		}
	}		
	
	menu_destroy( menu );
	MyShotgunMenu( id );
	return PLUGIN_HANDLED;
}

public MySmgMenu( id ) {
	new Title[ 101 ], type[ 32 ];
	switch( g_iInvType[ id ] ) {
		case 0: copy( type, charsmax( type ), "Equip" );
		case 1: copy( type, charsmax( type ), "Refund" );
		case 2: copy( type, charsmax( type ), "Gift" );
	}
	formatex( Title, charsmax( Title ), "%s: %s SubmachineGun", PLUGIN, type );
	new menu = menu_create( Title, "MySmgMenu_Handler" );
	
	for( new i = 0; i < sizeof( g_mSmgs ); i++ ) {
		formatex( Title, charsmax( Title ), "%s %s", g_mSmgs[ i ][ GunName ], g_mPlayerStore[ id ][ m_iSmgs ][ i ] ? "" : "( \dNot Owned )" );
		menu_additem( menu, Title, _, _, g_SmgInv);
	}
	
	menu_setprop( menu, MPROP_EXITNAME, "Main Menu" );
	menu_display( id, menu, 0 );
	return PLUGIN_HANDLED;
}

public MySmgInv( id, menu, item ) {
	if( !g_mPlayerStore[ id ][ m_iSmgs ][ item ] )
		return ITEM_DISABLED;
	else if( g_bEquipedPrimary[ id ] )
		return ITEM_DISABLED;
	
	return ITEM_ENABLED;
}

public MySmgMenu_Handler( id, menu, item ) {
	if( item == MENU_EXIT ) {
		menu_destroy( menu );
		cmdInventory( id );
		return PLUGIN_HANDLED;
	}
	
	switch( g_iInvType[ id ] ) {
		case 0: {
			StripWeapons( id, Primary );
			give_item( id, g_mSmgs[ item ][ GunWeapon ] );
			cs_set_user_bpammo( id, g_mSmgs[ item ][ csw ], g_mSmgs[ item ][ ammo ] );
			g_bEquipedPrimary[ id ] = true;
			Color( id, "%s Equiped !g%s!n", PREFIX, g_mSmgs[ item ][ GunName ] );
		}
		case 1: {
			new iCost = get_pcvar_num( g_pSmgCost[ item ] );
			g_mPlayerStore[ id ][ m_iSmgs ][ item ] = false;
			g_iCredits[ id ] += iCost;
			MyPistolMenu( id );
			Color( id, "%s You Refunded !g%s!n And Recieved !g%i!n Credits Back", PREFIX, g_mSmgs[ item ][ GunName ], iCost );
		}
		case 2: {
			g_iItem[ id ] = item;
			g_iItemType[ id ] = 2;
			menu_destroy( menu );
			GiftItem( id );
			return PLUGIN_HANDLED;
		}
	}
			
	menu_destroy( menu );
	MySmgMenu( id );
	return PLUGIN_HANDLED;
}

public MyRifleMenu( id ) {
	new Title[ 101 ], type[ 32 ];
	switch( g_iInvType[ id ] ) {
		case 0: copy( type, charsmax( type ), "Equip" );
		case 1: copy( type, charsmax( type ), "Refund" );
		case 2: copy( type, charsmax( type ), "Gift" );
	}
	formatex( Title, charsmax( Title ), "%s: %s Rifle", PLUGIN, type );
	new menu = menu_create( Title, "MyRifleMenu_Handler" );
	
	for( new i = 0; i < sizeof( g_mRifles ); i++ ) {
		formatex( Title, charsmax( Title ), "%s %s", g_mRifles[ i ][ GunName ], g_mPlayerStore[ id ][ m_iRiffles ][ i ] ? "" : "( \dNot Owned )" );
		menu_additem( menu, Title, _, _, g_RifleInv);
	}
	
	menu_setprop( menu, MPROP_EXITNAME, "Main Menu" );
	menu_display( id, menu, 0 );
	return PLUGIN_HANDLED;
}

public MyRifleInv( id, menu, item ) {
	if( !g_mPlayerStore[ id ][ m_iRiffles ][ item] )
		return ITEM_DISABLED;
	else if( g_bEquipedPrimary[ id ] )
		return ITEM_DISABLED;
	
	return ITEM_ENABLED;
}

public MyRifleMenu_Handler( id, menu, item ) {
	if( item == MENU_EXIT ) {
		menu_destroy( menu );
		cmdInventory( id );
		return PLUGIN_HANDLED;
	}
	
	switch( g_iInvType[ id ] ) {
		case 0: {
			StripWeapons( id, Primary );
			give_item( id, g_mRifles[ item ][ GunWeapon ] );
			cs_set_user_bpammo( id, g_mRifles[ item ][ csw ], g_mRifles[ item ][ ammo ] );
			g_bEquipedPrimary[ id ] = true;
			Color( id, "%s Equiped !g%s!n", PREFIX, g_mRifles[ item ][ GunName ] );
		}
		case 1: {
			new iCost = get_pcvar_num( g_pRifleCost[ item ] );
			g_mPlayerStore[ id ][ m_iRiffles ][ item ] = false;
			g_iCredits[ id ] += iCost;
			MyRifleMenu( id );
			Color( id, "%s You Refunded !g%s!n And Recieved !g%i!n Credits Back", PREFIX, g_mRifles[ item ][ GunName ], iCost );
		}
		case 2: {
			g_iItem[ id ] = item;
			g_iItemType[ id ] = 3;
			menu_destroy( menu );
			GiftItem( id );
			return PLUGIN_HANDLED;
		}
	}
	
	menu_destroy( menu );
	MyRifleMenu( id );
	return PLUGIN_HANDLED;
}

public MyParaMenu( id ) {
	new Title[ 101 ], type[ 32 ];
	switch( g_iInvType[ id ] ) {
		case 0: copy( type, charsmax( type ), "Equip" );
		case 1: copy( type, charsmax( type ), "Refund" );
		case 2: copy( type, charsmax( type ), "Gift" );
	}
	formatex( Title, charsmax( Title ), "%s: %s Para", PLUGIN, type );
	new menu = menu_create( Title, "MyParaMenu_Handler" );
	
	formatex( Title, charsmax( Title ), "%s %s", g_mPara[ 0 ][ GunName ], g_mPlayerStore[ id ][ m_iMachineGun ] ? "" : "( \dNot Owned )" );
	menu_additem( menu, Title, _, _, g_ParaInv);
		
	menu_setprop( menu, MPROP_EXITNAME, "Main Menu" );
	menu_display( id, menu, 0 );
	return PLUGIN_HANDLED;
}

public MyParaInv( id, menu, item ) {
	if( !g_mPlayerStore[ id ][ m_iMachineGun ] )
		return ITEM_DISABLED;
	else if( g_bEquipedPrimary[ id ] )
		return ITEM_DISABLED;
	
	return ITEM_ENABLED;
}

public MyParaMenu_Handler( id, menu, item ) {
	if( item == MENU_EXIT ) {
		menu_destroy( menu );
		cmdInventory( id );
		return PLUGIN_HANDLED;
	}
	
	switch( g_iInvType[ id ] ) {
		case 0: {
			StripWeapons( id, Primary );
			give_item( id, g_mPara[ 0 ][ GunWeapon ] );
			cs_set_user_bpammo( id, g_mPara[ 0 ][ csw ], g_mPara[ 0 ][ ammo ] );
			g_bEquipedPrimary[ id ] = true;
			Color( id, "%s Equiped !g%s!n", PREFIX, g_mPara[ 0 ][ GunName ] );
		}
		case 1: {
			new iCost = get_pcvar_num( g_pM249Cost );
			g_mPlayerStore[ id ][ m_iMachineGun ] = false;
			g_iCredits[ id ] += iCost;
			MyRifleMenu( id );
			Color( id, "%s You Refunded !g%s!n And Recieved !g%i!n Credits Back", PREFIX, g_mPara[ 0 ][ GunName ], iCost );
		}
		case 2: {
			g_iItem[ id ] = item;
			g_iItemType[ id ] = 4;
			menu_destroy( menu );
			GiftItem( id );
			return PLUGIN_HANDLED;
		}
	}
			
	menu_destroy( menu );
	MyParaMenu( id );
	return PLUGIN_HANDLED;
}

public MyEquipMenu( id ) {
	new Title[ 101 ], type[ 32 ];
	switch( g_iInvType[ id ] ) {
		case 0: copy( type, charsmax( type ), "Equip" );
		case 1: copy( type, charsmax( type ), "Refund" );
		case 2: copy( type, charsmax( type ), "Gift" );
	}
	formatex( Title, charsmax( Title ), "%s: %s Equipment", PLUGIN, type );
	new menu = menu_create( Title, "MyEquipMenu_Handler" );
	
	for( new i = 0; i < sizeof( g_mEquipments ); i++ ) {
		formatex( Title, charsmax( Title ), "%s %s", g_mEquipments[ i ][ GunName ], g_mPlayerStore[ id ][ m_iEquipments ][ i ] ? "" : "( \dNot Owned )" );
		menu_additem( menu, Title, _, _, g_EquipInv);
	}
	
	menu_setprop( menu, MPROP_EXITNAME, "Main Menu" );
	menu_display( id, menu, 0 );
	return PLUGIN_HANDLED;
}

public MyEquipInv( id, menu, item ) {
	new MapName[ 32 ];
	get_mapname( MapName, charsmax( MapName ) );
	
	if( !g_mPlayerStore[ id ][ m_iEquipments ][ item ] )
		return ITEM_DISABLED;
	else if( item == 5 ) {
		if( cs_get_user_team( id ) != CS_TEAM_CT )
			return ITEM_DISABLED;
		else if( (contain( MapName,"de_") == -1) )
			return ITEM_DISABLED;
	}
	else if( g_bEquipedItem[ id ][ item ] )
		return ITEM_DISABLED;
	
	return ITEM_ENABLED;
}

public MyEquipMenu_Handler( id, menu, item ) {
	if( item == MENU_EXIT ) {
		menu_destroy( menu );
		cmdInventory( id );
		return PLUGIN_HANDLED;
	}
	
	switch( g_iInvType[ id ] ) {
		case 0: {
			if( item == 5 ) cs_set_user_defuse( id, 1 );
			else if( item == 6 ) cs_set_user_nvg( id, 1 );
			else give_item( id, g_mEquipments[ item ][ GunWeapon ] );
			if( get_weaponid( g_mEquipments[ item ][ GunWeapon ] ) ) cs_set_user_bpammo( id, g_mEquipments[ item ][ csw ], g_mEquipments[ item ][ ammo ] );
			Color( id, "%s Equiped !g%s!n", PREFIX, g_mEquipments[ item ][ GunName ] );
			g_bEquipedItem[ id ][ item ] = true;
		}
		case 1: {
			new iCost = get_pcvar_num( g_pEquipCost[ item ] );
			g_mPlayerStore[ id ][ m_iEquipments ][ item ] = false;
			g_iCredits[ id ] += iCost;
			MyRifleMenu( id );
			Color( id, "%s You Refunded !g%s!n And Recieved !g%i!n Credits Back", PREFIX, g_mEquipments[ item ][ GunName ], iCost );
		}
		case 2: {
			g_iItem[ id ] = item;
			g_iItemType[ id ] = 5;
			menu_destroy( menu );
			GiftItem( id );
			return PLUGIN_HANDLED;
		}
	}		
	
	menu_destroy( menu );
	MyEquipMenu( id );
	return PLUGIN_HANDLED;
}


public GiftItem( id )
{
	new menu = menu_create( "Gift Item To:", "GiftItem_handler" );
	
	new players[ 32 ], pnum, tempid;
	
	new szName[ 32 ], szUserId[32];
	
	get_players( players, pnum ); 
	
	for( new i; i < pnum; i++ ) {
		tempid = players[ i ];
		
		get_user_name( tempid, szName, charsmax( szName ) );
		formatex( szUserId, charsmax( szUserId ), "%d", get_user_userid( tempid ) );
		
		menu_additem( menu, szName, szUserId, 0 );
	}
	
	menu_display( id, menu, 0 );
}

public GiftItem_handler( id, menu, item ) {
	if ( item == MENU_EXIT ) {
		menu_destroy( menu );
		return PLUGIN_HANDLED;
	}
	
	new szData[ 6 ], szName[ 64 ], szName2[ 64 ];
	new item_access, item_callback;
	
	menu_item_getinfo( menu, item, item_access, szData,charsmax( szData ), szName,charsmax( szName ), item_callback );
	
	get_user_name( id, szName2, charsmax( szName2 ) );
	
	new userid = str_to_num( szData );
	
	new player = find_player( "k", userid );
	
	if ( player ) {
		g_iGiftFrom = id;
		GiftNotify( player, g_iItemType[ id ], g_iItem[ id ] );			
	}
	
	menu_destroy( menu );
	return PLUGIN_HANDLED;
}

public GiftNotify( id, type, item ) {
	new Title[ 101 ], szName[ 32 ], Type[ 32 ], szUserId[ 32 ];
	get_user_name( g_iGiftFrom, szName, charsmax( szName ) );
	switch( type ) {
		case 0: formatex( Type, charsmax( Type ), "%s", g_mPistols[ item ][ GunName ] );
		case 1: formatex( Type, charsmax( Type ), "%s", g_mShotguns[ item ][ GunName ] );
		case 2: formatex( Type, charsmax( Type ), "%s", g_mSmgs[ item ][ GunName ] );
		case 3: formatex( Type, charsmax( Type ), "%s", g_mRifles[ item ][ GunName ] );
		case 4: formatex( Type, charsmax( Type ), "%s", g_mPara[ 0 ][ GunName ] );
		case 5: formatex( Type, charsmax( Type ), "%s", g_mEquipments[ item ][ GunName ] );
	}
	formatex( Title, charsmax( Title ), "Gift Pending ( \r%s\y ) From \r%s\y^n^nDo You Accept This Gift?", Type, szName );
	formatex( szUserId, charsmax( szUserId ), "%d", get_user_userid( id ) );
	new menu = menu_create( Title, "GiftNotify_handler" );
	
	menu_additem( menu, "I Accept Gift", szUserId );
	menu_additem( menu, "Don't Want It", szUserId );
	
	menu_display( id, menu, 0 );
	return PLUGIN_HANDLED;
}

public GiftNotify_handler( id, menu, item ) {
	new szName[ 32 ]; get_user_name( id, szName, charsmax( szName ) );
	if( item == MENU_EXIT ) {
		menu_destroy( menu );
		Color( g_iGiftFrom, "%s !t%s!n Declined Your Gift", PREFIX, szName );
		return PLUGIN_HANDLED;
	}
	
	new szData[ 32 ];
	new access, item_callback;
	
	menu_item_getinfo( menu, item, access, szData, charsmax( szData ), szName, charsmax( szName ), item_callback );
	
	new userid = str_to_num( szData );
	new player = find_player( "k", userid );
	
	switch( item ) {
		case 0: SendGift( g_iGiftFrom, player, g_iItemType[ g_iGiftFrom ], g_iItem[ g_iGiftFrom ] );
		case 1: Color( g_iGiftFrom, "%s !t%s!n Declined Your Gift", PREFIX, szName );
	}
	
	menu_destroy( menu );
	return PLUGIN_HANDLED;
}

stock SendGift( id, target, type, item ) {
	new szName[ 32 ]; get_user_name( id, szName, charsmax( szName ) );
	new szTarName[ 32 ]; get_user_name( target, szTarName, charsmax( szTarName ) );
	
	switch( type ) {
		case 0: {
			g_mPlayerStore[ id ][ m_iPistols ][ item ] = false;
			g_mPlayerStore[ target ][ m_iPistols ][ item ] = true;
			Color( id, "%s !t%s!n Has Accepted Your Gift", PREFIX, szTarName );
			Color( target, "%s Gift ( !g%s!n ) From !g%s!n Has Been Added To Your !tInventory !n( !g%s!n )", PREFIX, g_mPistols[ item ][ GunName ], szName, g_szSayCmds[ 2 ][ Say ] );
		}
		case 1: {
			g_mPlayerStore[ id ][ m_iShotGuns ][ item ] = false;
			g_mPlayerStore[ target ][ m_iShotGuns ][ item ] = true;
			Color( id, "%s !t%s!n Has Accepted Your Gift", PREFIX, szTarName );
			Color( target, "%s Gift ( !g%s!n ) From !g%s!n Has Been Added To Your !tInventory !n( !g%s!n )", PREFIX, g_mShotguns[ item ][ GunName ], szName, g_szSayCmds[ 2 ][ Say ] );
		}
		case 2: {
			g_mPlayerStore[ id ][ m_iSmgs ][ item ] = false;
			g_mPlayerStore[ target ][ m_iSmgs ][ item ] = true;
			Color( id, "%s !t%s!n Has Accepted Your Gift", PREFIX, szTarName );
			Color( target, "%s Gift ( !g%s!n ) From !g%s!n Has Been Added To Your !tInventory !n( !g%s!n )", PREFIX, g_mSmgs[ item ][ GunName ], szName, g_szSayCmds[ 2 ][ Say ] );
		}
		case 3: {
			g_mPlayerStore[ id ][ m_iRiffles ][ item ] = false;
			g_mPlayerStore[ target ][ m_iRiffles ][ item ] = true;
			Color( id, "%s !t%s!n Has Accepted Your Gift", PREFIX, szTarName );
			Color( target, "%s Gift ( !g%s!n ) From !g%s!n Has Been Added To Your !tInventory !n( !g%s!n )", PREFIX, g_mRifles[ item ][ GunName ], szName, g_szSayCmds[ 2 ][ Say ] );
		}
		case 4: {
			g_mPlayerStore[ id ][ m_iMachineGun ] = false;
			g_mPlayerStore[ target ][ m_iMachineGun ] = true;
			Color( id, "%s !t%s!n Has Accepted Your Gift", PREFIX, szTarName );
			Color( target, "%s Gift ( !g%s!n ) From !g%s!n Has Been Added To Your !tInventory !n( !g%s!n )", PREFIX, g_mPara[ 0 ][ GunName ], szName, g_szSayCmds[ 2 ][ Say ] );
		}
		case 5: {
			g_mPlayerStore[ id ][ m_iEquipments ][ item ] = false;
			g_mPlayerStore[ target ][ m_iEquipments ][ item ] = true;
			Color( id, "%s !t%s!n Has Accepted Your Gift", PREFIX, szTarName );
			Color( target, "%s Gift ( !g%s!n ) From !g%s!n Has Been Added To Your !tInventory !n( !g%s!n )", PREFIX, g_mEquipments[ item ][ GunName ], szName, g_szSayCmds[ 2 ][ Say ] );
		}
	}
	return PLUGIN_HANDLED;
}

public cmdHelp( id ) {
	new motd[ 1501 ], iLen;
	iLen = formatex( motd, charsmax( motd ), "<html><body bgcolor='black' text='yellow'>");
	iLen += formatex( motd[ iLen ], ( charsmax( motd ) ) - iLen,"<center><img src='http://lethalgn.net/blizzard/images/CSStore.png' width='250'> " );
	iLen += formatex( motd[ iLen ], ( charsmax( motd ) ) - iLen,"v%s</center><br>", VERSION );
	iLen += formatex( motd[ iLen ], ( charsmax( motd ) ) - iLen,"<u>Commands List</u>:<br>" );
	iLen += formatex( motd[ iLen ], ( charsmax( motd ) ) - iLen,"<ol><li><b><font color=lime>/store or /shop</font></b><br>" );
	iLen += formatex( motd[ iLen ], ( charsmax( motd ) ) - iLen,"These Say Commands Open Up Your Main Store Menu" );
	iLen += formatex( motd[ iLen ], ( charsmax( motd ) ) - iLen,"<li><b><font color=lime>/inv or /inventory</font></b><br>" );
	iLen += formatex( motd[ iLen ], ( charsmax( motd ) ) - iLen,"These Say Commands Open Up Your Inventory Menu<br>" );
	iLen += formatex( motd[ iLen ], ( charsmax( motd ) ) - iLen,"Where You Can Equip Refund or Gift Your Items" );
	iLen += formatex( motd[ iLen ], ( charsmax( motd ) ) - iLen,"<li><b><font color=lime>/credits</font></b><br>" );
	iLen += formatex( motd[ iLen ], ( charsmax( motd ) ) - iLen,"This Enables/Disables Your Credits HUD Under The Radar" );
	iLen += formatex( motd[ iLen ], ( charsmax( motd ) ) - iLen,"<li><b><font color=lime>/help</font></b><br>" );
	iLen += formatex( motd[ iLen ], ( charsmax( motd ) ) - iLen,"This Obviously Opens Up This Help MOTD" );
	iLen += formatex( motd[ iLen ], ( charsmax( motd ) ) - iLen,"</ol>" );
	iLen += formatex( motd[ iLen ], ( charsmax( motd ) ) - iLen,"<font color=red><b>Important Notice:</b></font><br>" );
	iLen += formatex( motd[ iLen ], ( charsmax( motd ) ) - iLen,"<br>" );
	iLen += formatex( motd[ iLen ], ( charsmax( motd ) ) - iLen,"You Can Only Equip An Item Once Per Round!" );
	iLen += formatex( motd[ iLen ], ( charsmax( motd ) ) - iLen,"<br>" );
	iLen += formatex( motd[ iLen ], ( charsmax( motd ) ) - iLen,"<br>" );
	iLen += formatex( motd[ iLen ], ( charsmax( motd ) ) - iLen,"<center>" );
	iLen += formatex( motd[ iLen ], ( charsmax( motd ) ) - iLen,"If You Like This Plugin You Can Download It From AlliedModders!" );
	iLen += formatex( motd[ iLen ], ( charsmax( motd ) ) - iLen,"</center>" );
	
	iLen += formatex( motd[ iLen ], ( charsmax( motd ) ) - iLen, "</body></html>" );
	show_motd( id, motd, "CS Store Help" );
	
	return PLUGIN_HANDLED;
}

public SaveCredits( id )  { 
	new AuthID[ 35 ];
	get_user_authid( id, AuthID, 34); 
	new vaultkey[ 64 ],vaultdata[ 256 ];
	
	format( vaultkey, charsmax( vaultkey ),"%s-CS-Store-Credits",AuthID); 
	format( vaultdata, charsmax( vaultdata ),"%i", g_iCredits[ id ] );
	
	nvault_set( g_iVault, vaultkey, vaultdata );
}

public LoadCredits( id ) { 
	new AuthID[ 35 ];
	get_user_authid( id, AuthID, charsmax( AuthID ) );
	new vaultkey[ 64 ],vaultdata[ 256 ] ;
	
	format( vaultkey, charsmax( vaultkey ),"%s-CS-Store-Credits",AuthID); 
	format( vaultdata, charsmax( vaultdata ),"%i", g_iCredits[ id ] ); 
	
	nvault_get( g_iVault, vaultkey, vaultdata, charsmax( vaultdata ) );
	new credits[ 33 ];
	parse( vaultdata, credits, 32 );
	
	g_iCredits[ id ] = str_to_num( credits );	
}

/* 	Natives		*/
public _get_user_credits(  ) {
	new iPlayer = get_param( 1 );
	return g_iCredits[ iPlayer ];
}

public _give_user_credits(  ) {
	new iPlayer = get_param( 1 );
	new iAddCredits = get_param( 2 );
	g_iCredits[ iPlayer ] += iAddCredits;
	if( get_pcvar_num( g_pSaveCredits ) )
		SaveCredits( iPlayer );
}

/*	Stocks		*/
stock Color( id, String[ ], any:... )
{
	static szMsg[ 192 ];
	vformat( szMsg, charsmax( szMsg ), String, 3 );
	
	replace_all( szMsg, charsmax( szMsg ), "!n", "^1" );
	replace_all( szMsg, charsmax( szMsg ), "!t", "^3" );
	replace_all( szMsg, charsmax( szMsg ), "!g", "^4" );
	
	static msgSayText = 0;
	if( !msgSayText ) msgSayText = get_user_msgid( "SayText" );
	
	new Players[ 32 ], iNum = 1, i; 
	
	if( id ) Players[ 0 ] = id;   
	else get_players( Players, iNum, "ch" );
	
	for( --iNum; iNum >= 0; iNum-- )
	{
		i = Players[ iNum ];
	
		message_begin( MSG_ONE_UNRELIABLE, msgSayText, _, i );
		write_byte( i );
		write_string( szMsg );
		message_end( );
	}
}

stock StripWeapons(id, Type, bool: bSwitchIfActive = true)
{
	new iReturn;
	
	if(is_user_alive(id))
	{
		new iEntity, iWeapon;
		while((iWeapon = GetWeaponFromSlot(id, Type, iEntity)) > 0)
			iReturn = ham_strip_user_weapon(id, iWeapon, Type, bSwitchIfActive);
	}
	
	return iReturn;
}
	
		
/*	Busgy Get Weapon Stock		*/
stock GetWeaponFromSlot( id , iSlot , &iEntity )
{
	if ( !( 1 <= iSlot <= 5 ) )
		return 0;
	
	iEntity = 0;
	const m_rgpPlayerItems_Slot0 = 367;
	const m_iId = 43;
	const XO_WEAPONS = 4;
	const XO_PLAYER = 5;
		
	iEntity = get_pdata_cbase( id , m_rgpPlayerItems_Slot0 + iSlot , XO_PLAYER );
	
	return ( iEntity > 0 ) ? get_pdata_int( iEntity , m_iId , XO_WEAPONS ) : 0;
}  


/*	ConnorMcLeod Strip Weapon Stock		*/
stock ham_strip_user_weapon(id, iCswId, iSlot = 0, bool:bSwitchIfActive = true)
{
	new iWeapon;
	if( !iSlot )
	{
		static const iWeaponsSlots[] = {
			-1,
			2, //CSW_P228
			-1,
			1, //CSW_SCOUT
			4, //CSW_HEGRENADE
			1, //CSW_XM1014
			5, //CSW_C4
			1, //CSW_MAC10
			1, //CSW_AUG
			4, //CSW_SMOKEGRENADE
			2, //CSW_ELITE
			2, //CSW_FIVESEVEN
			1, //CSW_UMP45
			1, //CSW_SG550
			1, //CSW_GALIL
			1, //CSW_FAMAS
			2, //CSW_USP
			2, //CSW_GLOCK18
			1, //CSW_AWP
			1, //CSW_MP5NAVY
			1, //CSW_M249
			1, //CSW_M3
			1, //CSW_M4A1
			1, //CSW_TMP
			1, //CSW_G3SG1
			4, //CSW_FLASHBANG
			2, //CSW_DEAGLE
			1, //CSW_SG552
			1, //CSW_AK47
			3, //CSW_KNIFE
			1 //CSW_P90
		};
		iSlot = iWeaponsSlots[iCswId];
	}

	const XTRA_OFS_PLAYER = 5;
	const m_rgpPlayerItems_Slot0 = 367;

	iWeapon = get_pdata_cbase(id, m_rgpPlayerItems_Slot0 + iSlot, XTRA_OFS_PLAYER);

	const XTRA_OFS_WEAPON = 4;
	const m_pNext = 42;
	const m_iId = 43;

	while( iWeapon > 0 )
	{
		if( get_pdata_int(iWeapon, m_iId, XTRA_OFS_WEAPON) == iCswId )
		{
			break;
		}
		iWeapon = get_pdata_cbase(iWeapon, m_pNext, XTRA_OFS_WEAPON);
	}

	if( iWeapon > 0 )
	{
		const m_pActiveItem = 373;
		if( bSwitchIfActive && get_pdata_cbase(id, m_pActiveItem, XTRA_OFS_PLAYER) == iWeapon )
		{
			ExecuteHamB(Ham_Weapon_RetireWeapon, iWeapon);
		}

		if( ExecuteHamB(Ham_RemovePlayerItem, id, iWeapon) )
		{
			user_has_weapon(id, iCswId, 0);
			ExecuteHamB(Ham_Item_Kill, iWeapon);
			return 1;
		}
	}

	return 0;
} 
