import es
import os
import usermsg
import gamethread
import random
import playerlib_250i_he as playerlib
import vecmath_250i_he as vecmath
from configobj import ConfigObj

# please have some respect for my work, do not edit the credits.

info = es.AddonInfo()
info.name = "Realistic HE"
info.basename = "realistic_he"
info.author = "sea212"
info.version = "1.4f"
info.description = 'simulates a very realistic "hit by he grenade" effect'

es.ServerVar(info.basename, "by "+info.author+" v. "+info.version).makepublic()
counter = 0

# sounds cut and "compiled" for css by sea212
# downloaded at http:/www.freesound.org/

snds = {"h_no":"realistic_nades/heart_normal.wav", 
		"h_en":"realistic_nades/heart_end.wav", 
		"b_no":"realistic_nades/breath_normal.wav", 
		"b_en":"realistic_nades/breath_end.wav",
		"s_01":"realistic_nades/scream_01.wav",
		"s_02":"realistic_nades/scream_02.wav",
		"s_03":"realistic_nades/scream_03.wav",
		"s_04":"realistic_nades/scream_04.wav",
		"s_05":"realistic_nades/scream_05.wav"}
		
NoFail = {}

conffile = es.getString("eventscripts_gamedir")+"/cfg/realistic_he/realistic_he.ini"
	
if os.path.isfile(conffile):
	# load config
	userConf = ConfigObj(conffile)
	
if not os.path.isfile(conffile):
	# no config?
	userConf = {"Effects":{"shake":"on", "red_screen":"on", "blood":"on", "fov":"off"}, "General":{"retry_for_download":"on"}}
	print "ERROR: no config, please install the config!!!"
	errorlog = open(es.getAddonPath("realistic_he")+"/error.txt", "a")
	errorlog.write("ERROR: missing "+conffile+"\n")
	errorlog.close()


class cHe(dict):
	global NoFail
	
	def aStartProcess(self):
		self["steamid"] = es.getplayersteamid(self["uid"])	
		gamethread.delayed(0.1, self.FirstStep, ())
		
		
	def FirstStep(self):
		if not es.getplayerprop(self["uid"], "CCSPlayer.baseclass.pl.deadflag"):
			self.plibply = playerlib.getPlayer(self["uid"])
			distance = int(vecmath.distance(self["posxyz"], self["heloc"]))
			_magnitude = 70-distance/20
			
			if distance <= 550:
				if userConf["Effects"]["shake"] == "on":
					usermsg.shake(self["uid"], _magnitude, 3)
					
			if not self.plibply.isObstructionBetween((float(self["heloc"][0]), float(self["heloc"][1]), float(self["heloc"][2]))):
				EffectD = distance/100
				
				if userConf["Effects"]["pushback"] == "on":
					# thanks to GodJonez for some help with the pushback
					if not EffectD >= 5:
						ply_loc = vecmath.vector(self["posxyz"])
						he_loc = vecmath.vector(self["heloc"])
						push_vector_raw = ply_loc-he_loc
						push_vector = push_vector_raw*{0:20000, 1:25000, 2:30000, 3:40000, 4:50000}[EffectD] / (push_vector_raw.length()**2)
						push_vector[2] = push_vector[2]+_magnitude*5
						es.setplayerprop(self["uid"], 'CBasePlayer.localdata.m_vecBaseVelocity', str(push_vector))
				
				if not EffectD >= 5 and not NoFail.has_key(self["uid"]):
					NoFail[self["uid"]] = 1
					self.DrawEffects({0:5, 1:4, 2:3, 3:2, 4:1}[EffectD])	
					es.emitsound("player", self["uid"], {0:snds["s_05"], 1:snds["s_04"], 2:snds["s_03"], 3:snds["s_02"], 4:snds["s_01"]}[EffectD], 1.0, 0.7)
					
					
	def DrawEffects(self, times):
		seconds = 3.0
		
		if times == 1:
			self.Final({1:90, 2:100, 3:110, 4:120, 5:130}[times], True)
			
		else:
			self.Final({1:90, 2:100, 3:110, 4:120, 5:130}[times])
			
		if userConf["Effects"]["red_screen"] == "on":
			usermsg.fade(self["uid"], 1, ((times+seconds+1)**4)-1, 0, 255, 0, 0, 200)
		
		for xt in xrange(times):
			_tempsec = seconds*(xt+1)
			
			if xt+1 == times:
				gamethread.delayed(_tempsec, self.Final, ({1:90, 2:100, 3:110, 4:120, 5:130}[times-xt], True))
				
			else:
				gamethread.delayed(_tempsec, self.Final, ({1:90, 2:100, 3:110, 4:120, 5:130}[times-xt]))
			
			
	def Final(self, FOV, end=False):
		if self["uid"] in es.getUseridList() and not es.getplayerprop(self["uid"], "CCSPlayer.baseclass.pl.deadflag"):
			if not end:
				es.playsound(self["uid"], snds["b_no"], 1.0)
				es.playsound(self["uid"], snds["h_no"], 1.0)
				gamethread.delayed(1.5, es.playsound, (self["uid"], snds["h_no"], 1.0))
				
			else:
				es.playsound(self["uid"], snds["b_en"], 1.0)
				es.playsound(self["uid"], snds["h_no"], 1.0)
				gamethread.delayed(1.5, es.playsound, (self["uid"], snds["h_en"], 1.0))
				
				if NoFail.has_key(self["uid"]):
					del NoFail[self["uid"]]
				
			if userConf["Effects"]["blood"] == "on":
				es.server.queuecmd('es_xfire %i !self addoutput "targetname %s"' % (self["uid"], self["steamid"]))
				es.server.queuecmd('es_xfire %i env_blood kill' % self["uid"])
				es.server.queuecmd('es_xentcreate %i env_blood' % self["uid"])
				es.server.queuecmd('es_xfire %i env_blood addoutput "parentname %s"' % (self["uid"], self["steamid"]))
				es.server.queuecmd('es_xfire %i env_blood addoutput "amount %i"' % (self["uid"], random.randint(50, 100)))
				es.server.queuecmd('es_xfire %i env_blood addoutput "spawnflags 13"' % self["uid"])
				es.server.queuecmd('es_xfire %i env_blood emitblood' % self["uid"])
			
			if userConf["Effects"]["fov"] == "on":
				es.setplayerprop(self["uid"], "CCSPlayer.baseclass.m_iFOV", FOV)
			
		else:
			if NoFail.has_key(self["uid"]):
				del NoFail[self["uid"]]
		
		
def doDownload():
	isbug = False
	
	for rn_file in snds:
		fsndpath = es.getString("eventscripts_gamedir")+"/sound/"+snds[rn_file]
		
		if os.path.isfile(fsndpath):
			es.stringtable("downloadables", "sound/"+snds[rn_file])
			
		else:
			print "ERROR: missing "+fsndpath
			errorlog = open(es.getAddonPath("realistic_he")+"/error.txt", "a")
			errorlog.write("ERROR: missing "+fsndpath+"\n")
			errorlog.close()
			isbug = True
		
	if isbug:
		errorlog = open(es.getAddonPath("realistic_he")+"/error.txt", "a")
		errorlog.write("* CRITICAL ERROR NOSOUNDS *\nplease download and install the sounds correctly!!!\n")
		errorlog.close()
		es.unload("realistic_he")
		
		
def load():
	doDownload()
	
	if userConf["General"]["retry_for_download"] == "on":
		for player in es.getUseridList():
			es.cexec(player, "retry")


def es_map_start(ev):
	doDownload()
	
	
def hegrenade_detonate(ev):
	info_fc = {}
	info_fc["heloc"] = [ev["x"], ev["y"], ev["z"]]
		
	
	for player in filter(lambda temp: not es.getplayerprop(temp, "CCSPlayer.baseclass.pl.deadflag"), es.getUseridList()):
		info_fc["uid"] = player
		info_fc["posxyz"] = es.getplayerlocation(player)
		cHe(info_fc).aStartProcess()
		
		
def player_disconnect(ev):
	global NoFail
	uid = int(ev["userid"])
	
	if NoFail.has_key(uid):
		del NoFail[uid]
		
		
def round_start(ev):
	global counter
	counter += 1
	
	if counter == 10:
		es.msg("#multi", "#lightgreen[Realistic HE]#green by #lightgreen%s#green. visit:#lightgreen www.mattie.info/cs#green." % info.author)
		counter = 0