<?php

$pCore->pTheme->sPageTitle = "Web-FTP";
$pCore->pTheme->getThemeHeader();

$webftp_path = "index.php?/Server/Web-FTP/";

#$pServer = getRemoteConnection();
?>

<p>
	<a href="<?php echo THEME_RELDIR ?>">&laquo; Back to server</a>
</p>

<?php

if(defined("WINDOWS"))
{
	echo '<div class="Alert">Web-FTP work only on linux!</div>';
	$pCore->pTheme->getThemeFooter();
	return;
}

$connection = ftp_connect(FTP_SERVER, FTP_PORT, FTP_TIMEOUT);

if(!ftp_login($connection, FTP_USERNAME, FTP_PASSWORD)) echo "<pre><div class='Alert'>Cant connect to ftp.</div></pre>";
else
{
	if(!isset($_GET['path']) || empty($_GET['path'])) $_GET['path'] = "/";
	/* Edit file */
	if(isset($_GET['savefile']))
	{
		if(!isset($_POST['content']) || empty($_POST['content'])) echo "<pre><div class='Alert'>Error during the content-transfer</div></pre>";
		else
		{
			$temp_file = mt_rand(15, 15).".dat";
			$fp = fopen($temp_file, 'w');
			fwrite($fp, stripslashes($_POST['content']));
			fclose($fp);
			
			if(!ftp_put($connection, $_GET['savefile'], $temp_file, FTP_ASCII)) echo "<pre><div class='Alert'>Error during writing the file</div></pre>";
			else echo "<pre><div class='Success'>The file was successfully edited</div></pre>";
			unlink ($temp_file);
		}
	}
	
	/* Make dir */
	if(!empty($_POST['mkdir']) && isset($_POST['mkdir_confirm']))
	{
		if(ftp_chdir($connection, $_GET['path']))
		{
			@ftp_mkdir($connection, $_POST['mkdir']);
			@ftp_chmod($connection, 0777, $_POST['mkdir']);
			header('Location: ?/Server/Web-FTP/&path='.$_GET['path']);
		}
		else
		{
			echo "<div class='Alert'>Cant chdir!</div>";
			return;
		}
	}
	/* Upload file */
	elseif(isset($_POST['upload']))
	{
		if(ftp_chdir($connection, $_GET['path']))
		{
			ftp_put($connection, $_FILES['newfile']['name'], $_FILES['newfile']['tmp_name'], FTP_BINARY);
			unlink($_FILES['newfile']['tmp_name']);
			header('Location: ?/Server/Web-FTP/&path='.$_GET['path']);
		}
		else
		{
			echo "<div class='Alert'>Cant chdir!</div>";
			return;
		}
	}
	/* Remove files & dir */
	elseif(isset($_GET['rm']))
	{
		ftp_delete($connection, $_GET['rm']);
		header('Location: ?/Server/Web-FTP/&path='.$_GET['path']);
	}
	elseif(isset($_GET['rmdir']))
	{
		ftp_rmdir($connection, $_GET['rmdir']);
		header('Location: ?/Server/Web-FTP/&path='.$_GET['path']);
	}
	/*Show file & dir */
	if(isset($_GET['view'])) 
	{
		$_GET['view'] = str_replace("..","",$_GET['view']);
		$filename = "ftp://".FTP_USERNAME.":".FTP_PASSWORD."@".FTP_SERVER.":".FTP_PORT."".$_GET['view'];
		$handle = fopen($filename, "r");
		$content = fread($handle,filesize($filename));
		echo '	<form action="'.$webftp_path.'&savefile='.$_GET['view'].'" method="POST">
					<textarea rows="30" cols="100%" name="content">'.$content.'</textarea><br>
					<input type="submit" value="Save">
					<input type="submit" value="Back" onClick="javascript:history.back();">
				</form>';
		fclose($handle);
	}
	else
	{	/*Show files & dir */
		$full_path = $_GET['path'];
		$files=""; $folders="";
		
		echo "	<table width='100%' border='0' cellpadding='2' cellspacing='2' style='margin:auto;text-align:left'>
					<tr style='text-align:center'><td width='50%'><b>File</b></td><td><b>Size</b></td><td><b>User</b></td><td><b>Perms</b></td><td width='5%'><b>Acts</b></td></tr>";
		
		$folders .= '<tr><td><a href="javascript:history.back()"><img src="Images/folder.png" border="0"> Back</a></td></tr>';
		
		$file_list = ftp_rawlist($connection, $full_path);
		
		function byteconvert($bytes) {
			if($bytes == 0) return "0 B";
			$symbol = array('B', 'KB', 'MB', 'GB', 'TB', 'PB', 'EB', 'ZB', 'YB');
			$exp = floor( log($bytes) / log(1024) );
			return sprintf( '%.2f ' . $symbol[ $exp ], ($bytes / pow(1024, floor($exp))) );
		}
		
		function chmodnum($chmod) {
			$trans = array('-' => '0', 'r' => '4', 'w' => '2', 'x' => '1');
			$chmod = substr(strtr($chmod, $trans), 1);
			$array = str_split($chmod, 3);
			return array_sum(str_split($array[0])) . array_sum(str_split($array[1])) . array_sum(str_split($array[2]));
		}
		
		$structure = array();
		$arraypointer = &$structure;
		
		if(is_array($file_list))
		{
			foreach($file_list as $file)
			{
				$info = preg_split("/[\s]+/", $file, 9);
				$arraypointer = array(
					'text'   => $info[8],
					'isDir'  => $info[0]{0} == 'd',
					'size'   => byteconvert($info[4]),
					'user'   => $info[2],
					'chmod'  => chmodnum($info[0]),
					'date'   => strtotime($info[6] . ' ' . $info[5] . ' ' . $info[7]),
					'raw'    => $info
					// the 'children' attribut is automatically added if the folder contains at least one file
				);
				
				if($file[0] == "d") {
					$folders .= '<tr>
						<td width="50%"><a href="'.$webftp_path.'&path='.$full_path."/".$arraypointer['text'].'"><img src="Images/folder.png" border="0"> '.$arraypointer['text'].'</a></td>
						<td style="text-align:center">'.$arraypointer['size'].'</td>
						<td style="text-align:center">'.$arraypointer['user'].'</td>
						<td style="text-align:center">'.$arraypointer['chmod'].'</td>
						<td style="text-align:center"><a href="'.$webftp_path.'&path='.$full_path.'&rmdir='.$full_path."/".$arraypointer['text'].'"><img src="Images/rm.png" border="0"></a></td>
						</tr>';
				}
				elseif($file[0] == "-")
					$files .= '<tr>
						<td width="50%"><a href="'.$webftp_path.'&view='.$full_path."/".$arraypointer['text'].'"><img src="Images/file.png" border="0"> '.$arraypointer['text'].'</a></td>
						<td style="text-align:center">'.$arraypointer['size'].'</td>
						<td style="text-align:center">'.$arraypointer['user'].'</td>
						<td style="text-align:center">'.$arraypointer['chmod'].'</td>
						<td style="text-align:center"><a href="'.$webftp_path.'&path='.$full_path.'&rm='.$full_path."/".$arraypointer['text'].'"><img src="Images/rm.png" border="0"></a></td>
						</tr>';
			}
		}
		echo $folders;
		echo $files;
		echo "</table>";
	}
}

?>

<p>
	<fieldset>
		<legend>Tools</legend>
			<table>
				<tr>
					<form method="POST" action="">
					<td><strong>New folder:</strong></td>
					<td><input type="text" name="mkdir" value="" /></td>
					<td><input type="submit" name="mkdir_confirm" value="Create" /></td>
					</form>
				</tr>
				<tr>
					<form enctype='multipart/form-data' method="POST" action="">
					<td><strong>Upload:</strong></td>
					<td><input type="file" name="newfile" value="" /></td>
					<td><input type="submit" name="upload" value="Upload" /></td>
					</form>
				</tr>
			</table>
	</fieldset>
</p>

<?php

$pCore->pTheme->getThemeFooter();