<?php

class SSH2_Linux
{
	private
		$rResource = null;
	
	
	public function __construct()
	{
		$this->rResource = ssh2_connect(SSH_SERVER, SSH_PORT);
		
		$this->authenticatePassword();
	}
	
	
	public function __destruct()
	{
	}
	
	
	public function authenticatePassword()
	{
		ssh2_auth_password($this->rResource, SSH_USERNAME, SSH_PASSWORD);
	}
	
	
	private function __invoke($sCommand)
	{
		$aOutput = array();
		
		$rStream = ssh2_exec($this->rResource, "cd ".SSH_RELDIR." && ".$sCommand);
		$rErrorStream = ssh2_fetch_stream($rStream, SSH2_STREAM_STDERR);
		/* debug output!*/
		#echo "cd ".SSH_RELDIR." && ".$sCommand;

		stream_set_blocking($rErrorStream, true);
		stream_set_blocking($rStream, true);

		$aOutput['output'] = stream_get_contents($rStream);
		$aOutput['error'] = stream_get_contents($rErrorStream);
		
		fclose($rErrorStream);
		fclose($rStream);
		
		return $aOutput;
	}
	
	
	public function isStarted()
	{
		$aOutput = $this("ps -ef | grep SCREEN | grep ".SSH_SCREEN_NAME." | grep -v grep | awk '{print $2}' | head -1");
		
		return (boolean) $aOutput['output'];
	}
	
	
	public function startServer()
	{
		if($this->isStarted())
		{
			return false;
		}
		
		$this("screen -dmS ".SSH_SCREEN_NAME." ./".SSH_EXEC);
		return true;
	}
	

	public function stopServer()
	{
		$this("kill `ps -ef | grep SCREEN | grep ".SSH_SCREEN_NAME." | grep -v grep | awk '{print $2}' | head -1`");
		return true;
	}
	
	
	public function restartServer()
	{
		$this->stopServer();
		sleep(1);
		$this->startServer();
	}
	
	
	public function getConfig()
	{
		$aStd = $this("cd cstrike && cat server.cfg");
		$aConfig = explode(PHP_EOL, $aStd['output']);
		
		$aOutput = array();
		
		foreach($aConfig as $sLine)
		{
			$aTemp = explode(' ', $sLine, 2);
			
			if(isset($aTemp[1]))
			{			
				$aOutput[$aTemp[0]] = trim($aTemp[1]);
			}
		}
		
		return $aOutput;
	}
}