<?php
/**
 *	For users that want to use COM_SECURITY only:
 *		Due to permission limitations, you need psexec - downloadable
 *		from http://live.sysinternals.com/psexec.exe
 *
 *	For users of XP Home only:
 *		You will need to download tasklist.exe and taskkill.exe
 *		separately.
 *	Put these files into C:\Windows\ or something.
 */

class COM_Windows
{
	private
		$pCOM = null;
	
	
	public function __construct()
	{
		$this->pCOM = new COM("WScript.Shell");
	}
	
	
	public function __destruct()
	{
		//nothing to do
	}
	
	
	private function __invoke($sCommand, $bReturnValues = true)
	{
		return $this->pCOM->Run($sCommand, 0, $bReturnValues);
	}
	
	
	public function isStarted()
	{
		$pOutput = $this->pCOM->Exec('tasklist /FO CSV /FI "IMAGENAME eq '.COM_PROCESS.'"');
		$sOutput = $pOutput->StdOut->ReadAll;
		return !(substr($sOutput, 0, 5) == "INFO:");
	}
	
	
	public function startServer()
	{
		if(!$this->isStarted())
		{
			return false;
		}
		
		if(COM_SECURITY)
		{
			$this->pCOM->Exec('psexec -u "'.addslashes(COM_USERNAME).'" -p "'.addslashes(COM_PASSWORD).'" -w "'.addslashes(COM_RELDIR).'" -d "'.addslashes(COM_RELDIR).'\\'.COM_EXEC.'"');
		}
		else
		{
			$this->pCOM->Exec('cmd /C start /D "'.addslashes(COM_RELDIR).'" /B '.COM_EXEC);
		}
		
		return true;
	}
	
	
	public function stopServer()
	{
		$this->pCOM->Exec('taskkill /F /IM '.COM_PROCESS);
	}
	
	
	public function restartServer()
	{
		$this->stopServer();
		sleep(1);
		$this->startServer();
	}
	
	
	public function getConfig()
	{
		$pOutput = $this->pCOM->Exec('cmd /C type "'.addslashes(COM_RELDIR).'\\server.cfg"');
		$aConfig = explode(PHP_EOL, $pOutput->StdOut->ReadAll);
		
		$aOutput = array();
		
		foreach($aConfig as $sLine)
		{
			$aTemp = explode(' ', $sLine, 2);
			
			if(isset($aTemp[1]))
			{
				$aOutput[$aTemp[0]] = trim($aTemp[1]);
			}
		}
		
		return $aOutput;
	}
}