<?php

/* Microtime */
function microtime_float()
{
	list($usec, $sec) = explode(" ", microtime());
	return ((float)$usec + (float)$sec);
}
define("ACL_EXEC_TIME", microtime_float());

/* What OS are we using? */
if(stristr(PHP_OS, 'WIN'))
{ 
	define("WINDOWS", 1);
}
else
{ 
	define("LINUX", 1);
}


/* Check if the key functions exist */
if(!function_exists("ssh2_connect") && defined("LINUX"))
{
	echo <<<EOL
	
	<html>
		<head>
			<title>Error</title>
		</head>
	
		<body style="background-color: #F22; color: #FFF">
			<div align="center">
				<h1>Error</h1>
				
				<p>Sorry, but you don't have php5-ssh2 installed.</p>
			</div>
		</body>
	</html>	
EOL;
	exit;
}

if(!class_exists("COM") && defined("WINDOWS"))
{
	echo <<<EOL
	
	<html>
		<head>
			<title>Error</title>
		</head>
	
		<body style="background-color: #F22; color: #FFF">
			<div align="center">
				<h1>Error</h1>
				
				<p>Sorry, but you don't have COM installed. Odd, I know!</p>
			</div>
		</body>
	</html>	
EOL;
	exit;
}


/* Include 'some' of the key files */
define("WEBSITE_ROOT", dirname(__FILE__));#
ini_set("display_errors", "On");

foreach(glob(WEBSITE_ROOT."/System/*Library/*.php") as $sGlob)
{
	require $sGlob;
}

require WEBSITE_ROOT."/System/Definitions.php";
require WEBSITE_ROOT."/System/BootLoader.php";


/* Parse the input string, obv. */
$_SEO = explode('/', $_SERVER['QUERY_STRING']);
$_SEO[0] = $_SERVER['QUERY_STRING'];

/* Let's check for re-directions. */
$aRedirections = array();

/* Fix */
if(!isset($_SEO[1])) $_SEO[1] = "";

if(array_key_exists($_SEO[1], $aRedirections))
{
	$_SEO[1] = $aRedirections[$_SEO[1]];
}


/* Try and load the module. */
if($_SEO[1])
{
	/* Oh, a module! */
	if(file_exists("Modules/{$_SEO[1]}/Default.php"))
	{
		require "Modules/{$_SEO[1]}/Default.php";
	}
	else
	{
		require "Modules/Error.404/Default.php";
	}
}
else
{
	require "Modules/Default/Default.php";
}
?>