#include <amxmodx>
#include <amxmisc>
#include <engine>
#include <fun>
#include <cstrike>
#include <deathrun_assist>
#include <fakemeta>
#include <hamsandwich>
#include <dhudmessage>


// no buttons pre mode.
// menu hide!
// menu no exit
// menu only T!
// 


#define	FL_WATERJUMP	(1<<11)	
#define	FL_ONGROUND	(1<<9)	
#define TE_BEAMFOLLOW	 22

#define TITLE					"[Deathrun Assist]"
#define MAXPLAYERS				32 + 1

#define ASSIST_MENU_ID				101204
#define SPAWN_TASK				101205


#define CANT_RELOAD_BITSUM	((1<<CSW_HEGRENADE)|(1<<CSW_SMOKEGRENADE)|(1<<CSW_FLASHBANG)|(1<<CSW_KNIFE)|(1<<CSW_C4))


new teamInfo
new CONFIG_HP = 100, CONFIG_ARMOR = 200, CONFIG_HPARMOR_COST = 5200, CONFIG_GRAVITY_COST = 6000, CONFIG_RUN_COST = 6000, CONFIG_STEALTH_COST = 11488, CONFIG_DEAGLE_COST = 12460, CONFIG_LIVE_COST = 16000;
new Activated_HPARMOR[MAXPLAYERS];
new Activated_Gravity[MAXPLAYERS];
new Activated_Run[MAXPLAYERS];
new Activated_Stealth[MAXPLAYERS];
new Activated_Deagle[MAXPLAYERS]

new bool:Mode_ON, MODE_Num = -1, maxPlayers;
new gmsgDeathMsg
new bool:timer[33] = false  , buttons_pressed[33];

new Ticks; 

// Thanks to SW wars mode
new MODEL_NADE_WORLD[] = "models/snowballs/w_snowball.mdl"
new MODEL_NADE_VIEW[] = "models/snowballs/v_snowball.mdl"
new V_ZM_MODEL[] = "models/CS-URBAN_DEATHRUN/v_knife_zombie.mdl"

	
new Blood_spray
new DropBlood
new SNOW_BALL_DAMAGE =			40;
new bool:Freezed[33];
new iTrail, assist_bhop
//

new Last_Three_Rounds[3], current_round = 0, g_msgScreenShake


#define ZOMBIE_PAIN 2
new pain_zombie[ZOMBIE_PAIN][] = 
{
	"la2zombie_source/zombie_pain1.wav",
	"la2zombie_source/zombie_pain2.wav" 
}


#define ZOMBIE_DEATH 2
new death_zombie[ZOMBIE_DEATH][] = 
{
	"la2zombie_source/zombie_die1.wav",
	"la2zombie_source/zombie_die2.wav"
}


new MODE[][100] =
{
	"Побежали!",
	"Невидимка",
	"Зомби",
	"Рембо",
	"Классика",
	"Жертва",
	"Снежки"
}


#include "colors.inl"



public plugin_init() 
{
	register_plugin("Death Run Assistant", "1.3", "Good Hash")
	register_dictionary("deathrun_assist.txt") 
	
	register_clcmd("say /menu", "Deathrun_Assist_Menu", ADMIN_ALL)
	register_clcmd("say menu", "Deathrun_Assist_Menu", ADMIN_ALL)
	register_clcmd("say_team menu", "Deathrun_Assist_Menu", ADMIN_ALL)
	register_clcmd("say_team /menu", "Deathrun_Assist_Menu", ADMIN_ALL)
	register_clcmd("menu", "Deathrun_Assist_Menu")
	
	
	register_clcmd("say", "CMD_modes", ADMIN_ALL)
	
	
	register_event("HLTV", "eventRoundStart", "a", "1=0", "2=0") 
	register_event("DeathMsg","death_msg","a") 
	register_event("CurWeapon","current_weapon","be","1=1")
	register_event("CurWeapon", "checkModel", "be", "1=1")
	//register_event("CurWeapon", "current_weapon", "be", "1=1", "2!29");
	
	
	// Deathrun  Modes goods
	RegisterHam(Ham_Spawn, "player", "player_spawn", 1)
	RegisterHam(Ham_Use, "func_button", "fwdUse")
	RegisterHam(Ham_Touch, "weaponbox", "fwdTouch") 
	RegisterHam(Ham_Touch, "armoury_entity", "fwdTouch")
	RegisterHam( Ham_Touch, "grenade", "FwdHamTouch_Grenade" );	
	RegisterHam(Ham_TakeDamage, "player", "HamTakeDamage");

	register_forward(FM_SetModel,"reset_models")
	register_forward(FM_Think,"fw_Think")
	register_forward(FM_CmdStart, "fwd_CmdStart")
	
	new const grenade[ ] = "grenade";
	register_think( grenade, "FwdGrenadeThink" );
	// Deathrun Modes goods
	
	
	register_clcmd("jointeam", "cmdJoinTeam");
	register_clcmd("chooseteam", "cmdJoinTeam");
	server_cmd ( "sv_maxspeed 2000" );
	server_cmd ( "sv_maxspeed 2000" );
	
	teamInfo = get_user_msgid ("TeamInfo")
	gmsgDeathMsg = get_user_msgid("DeathMsg")
	g_msgScreenShake = get_user_msgid("ScreenShake")
	
	
	assist_bhop = register_cvar ( "assit_bhop", "1" );
	register_cvar ( "death_assist_zm_health", "1000" );
	register_cvar ( "death_assist_zombie_buttons", "3" );
	register_cvar ( "death_assist_snow_buttons", "2" );
	register_cvar ( "death_assist_hunter_buttons", "1" );
	register_cvar ( "death_assist_snow_multi", "1" );
	register_cvar ( "death_assist_mode_rounds", "3" );


	Mode_ON = false;
	Ticks = 25
	
	set_lights ( "z" );
	
	new i;
	for ( i = 0; i < 3; ++i )
	{
		Last_Three_Rounds[i] = -5
	}
	
	maxPlayers = get_maxplayers ();
	//register_clcmd("say drplus" , "SetLivesNative", ADMIN_ALL)
	
	
	// Thanks xPaw for "Non-sprite set to glow! Fix"
	
	new szModel[ 2 ],
		iEntity      = get_maxplayers( ),
		iMaxEntities = get_global_int( GL_maxEntities );
	
	while( ++iEntity <= iMaxEntities ) {
		if( is_valid_ent( iEntity ) && entity_get_int( iEntity, EV_INT_rendermode ) == kRenderGlow ) {
			entity_get_string( iEntity, EV_SZ_model, szModel, 1 );
			
			if( szModel[ 0 ] == '*' )
				entity_set_int( iEntity, EV_INT_rendermode, kRenderNormal );
		}
	}

	
}

public player_spawn(id)
{
	if(!is_user_connected(id) || !is_user_alive(id))
	{
		return PLUGIN_CONTINUE
	}
	
	cs_reset_user_model ( id );
	
	set_task ( 1.1, "check_mode", id + 5050 );
	buttons_pressed[id] = 0;
	Freezed[id] = false;
	
	return PLUGIN_CONTINUE
}


public check_mode ( id )
{
	if ( id > 5050 )
		id -= 5050;
		
	if ( MODE_Num == 2)
	{
		if( cs_get_user_team(id)==CS_TEAM_T )
		{
			strip_user_weapons(id)
			give_item ( id, "weapon_knife");
			cs_set_user_model(id, "zombie_csurban")
			re_zombie_spawn_effects (id )
			
			set_user_health( id, get_cvar_num("death_assist_zm_health"))
		}
		else
		{
			strip_user_weapons(id)
			give_item ( id, "weapon_knife");
			give_item ( id, "weapon_mp5navy" );
			give_item ( id, "ammo_9mm" );
			give_item ( id, "ammo_9mm" );
			give_item ( id, "ammo_9mm" );
			give_item ( id, "ammo_9mm" );
			cs_set_user_bpammo ( id, CSW_MP5NAVY, 550 );
		}
	}
	
	if ( MODE_Num == 0)
	{
		if( cs_get_user_team(id)==CS_TEAM_T )
		{
			strip_user_weapons ( id)     
			give_item( id, "weapon_knife" )   
		}
	}
	
	if ( MODE_Num == 3 )
	{
		if( cs_get_user_team(id)==CS_TEAM_CT )
		{
			strip_user_weapons ( id );
			set_user_health( id , get_user_health( id ) + 50 )
			set_user_rendering( id, kRenderFxNone, 0, 0, 0, kRenderTransAlpha, 0 )
			give_item( id, "weapon_knife")
			give_item( id, "weapon_shield")
			give_item( id, "weapon_glock18")
			cs_set_user_bpammo( id, CSW_GLOCK18, 220)   
		}
	}
	
	if ( MODE_Num == 5 )
	{
		if( cs_get_user_team(id)==CS_TEAM_CT )
		{
			set_user_health( id, 1000 )
			set_user_gravity(id, 0.4)	
			set_user_rendering ( id, kRenderFxGlowShell, 255, 0, 0, kRenderGlow, 16 )
		}
		if ( cs_get_user_team ( id ) == CS_TEAM_CT )
		{
			strip_user_weapons ( id );
			give_item( id, "weapon_knife")
			give_item( id, "weapon_deagle")
			give_item( id, "weapon_awp")
			cs_set_user_bpammo( id, CSW_DEAGLE,100)   
			cs_set_user_bpammo( id, CSW_AWP, 50)
		}
	}
	
	if ( MODE_Num == 6 )
	{
		strip_user_weapons ( id );
		give_item( id, "weapon_hegrenade")
	}
}

public checkModel(id)
{ 
	new CsTeams:team = cs_get_user_team(id)
	
	
	if(team==CS_TEAM_T && MODE_Num == 2 )
	{
		entity_set_string(id,EV_SZ_viewmodel,V_ZM_MODEL)
		set_pev( id, pev_weaponmodel2, "" );
	}	
	return PLUGIN_HANDLED
} 

public plugin_precache() 
{
	precache_model(V_ZM_MODEL);
	engfunc(EngFunc_PrecacheModel,MODEL_NADE_WORLD)
	engfunc(EngFunc_PrecacheModel,MODEL_NADE_VIEW)
	precache_model("models/player/zombie_csurban/zombie_csurban.mdl")
	precache_sound("la2zombie_source/zombie_infec.wav")
	Blood_spray = engfunc(EngFunc_PrecacheModel,"sprites/bloodspray.spr")
	DropBlood = engfunc(EngFunc_PrecacheModel,"sprites/blood.spr")
	iTrail = precache_model("sprites/smoke.spr")

	
	new i;
	
	for (i = 0; i < ZOMBIE_PAIN; i++)
		precache_sound(pain_zombie[i])
		
	for (i = 0; i < ZOMBIE_DEATH; i++)
		precache_sound(death_zombie[i])
		
		
	return PLUGIN_CONTINUE
}


public HamTakeDamage(victim, inflictor, attacker, id)
{
	if ( !is_user_alive ( victim ) || !is_user_alive ( attacker ) || victim < 1 || attacker < 1 )
		return 0;
		
	if(cs_get_user_team(attacker)==CS_TEAM_T && Mode_ON )
	{
		if (is_user_alive(attacker) && MODE_Num == 2)
		{
			if( cs_get_user_team(victim)==CS_TEAM_T )
			{
				return 1
			}
			
			new i, ct_stay;
			for ( i = 1; i < 32; ++i)
				if ( is_user_alive(i))
					if ( get_user_team(i) == 2 )
						ct_stay += 1
			
			if ( ct_stay == 1 )
			{
				util_kill ( attacker, victim, "weapon_knife" );
				client_print(0, print_center, "")
				set_dhudmessage(225, 0, 25, -1.0, 0.25, 0, 6.0, 2.0, 1.0, 1.5)
				show_dhudmessage(0, "%L",0,"ZOMBI_WIN") 
			}
			else
			{
				emit_sound(victim, CHAN_VOICE, "la2zombie_source/zombie_infec.wav", 1.0, ATTN_NORM, 0, PITCH_NORM)
				re_zombie_spawn_effects (victim )
				
				cs_set_user_team( victim, CS_TEAM_T )
				strip_user_weapons(victim)
				give_item ( victim, "weapon_knife");
				cs_set_user_model(victim, "zombie_csurban")
				
				set_user_health( victim, 2*get_cvar_num("death_assist_zm_health"))
				 
				 
				static name[32]
				get_user_name(victim, name, sizeof name -1)
				
				ChatColor(0, "%L",0,"CT_ZOMBI_CHAT", name)
				set_dhudmessage(225, 0, 25, -1.0, 0.25, 0, 6.0, 2.0, 1.0, 1.5)
				show_dhudmessage(0, "%L",0,"CT_ZOMBI_HUD", name) 
				
				cs_set_user_model(victim, "zombie_csurban")
			}
			
		}
	}
	
	if(cs_get_user_team(attacker)==CS_TEAM_CT && Mode_ON )
	{
		if (is_user_alive(victim) && MODE_Num == 2)
		{
			emit_sound(victim, CHAN_VOICE, pain_zombie[random_num(0, ZOMBIE_PAIN - 1)], 1.0, ATTN_NORM, 0, PITCH_NORM)
		}
	}
	
	
	if(cs_get_user_team(attacker)==CS_TEAM_T && Mode_ON )
	{
		if (is_user_alive(victim) && MODE_Num == 5 )
		{
				SetHamParamFloat(4, float(900));
		}
	}

	
	return PLUGIN_CONTINUE
}


public current_weapon(id)
{
	if ( !Mode_ON  )
		return PLUGIN_CONTINUE

	if(cs_get_user_team(id)==CS_TEAM_T && MODE_Num == 2)
	{	
		engclient_cmd(id,"weapon_knife")
	}
	
	if(cs_get_user_team(id)==CS_TEAM_T && MODE_Num == 3)
	{
		if( CANT_RELOAD_BITSUM & (1<<read_data(2)) || read_data(3) > 1 )
			return PLUGIN_CONTINUE

		set_pdata_int(get_pdata_cbase(id, 373), 51, 100, 4)
		
	}
	
	if ( MODE_Num == 6 )
	{
		new weapon_id = read_data(2)
		
		if( weapon_id == CSW_HEGRENADE || weapon_id == CSW_FLASHBANG || weapon_id == CSW_SMOKEGRENADE )
		{
			set_pev(id, pev_viewmodel, engfunc(EngFunc_AllocString, MODEL_NADE_VIEW))
			set_pev(id, pev_viewmodel2,MODEL_NADE_VIEW)
		}
		
	}
	
	
	return PLUGIN_CONTINUE
}



/*
public fwd_emitsound(id, channel, const sound[], Float:volume, Float:attn, flag, pitch)
{
	if(!pev_valid(id))
		return FMRES_IGNORED;
	//|| MODE_Num != 3)

	if(equal(sound,"weapons/m249-1.wav"))
	{
		emit_sound(0, channel, MiniSound, volume, attn, flag, pitch);
		new fullsound[100];
		formatex(fullsound, charsmax(fullsound), "sound/%s", MiniSound );
		emit_sound( 0, channel, fullsound, 1.0, ATTN_NORM, 0, PITCH_NORM );
		return FMRES_SUPERCEDE;
	}
	
	
	
	
	if( containi( sound, "weapons/m249-1.wav" ) != -1 )
	{
		new fullsound[100];
		formatex(fullsound, charsmax(fullsound), "sound/%s", MiniSound );
		emit_sound( id, channel, fullsound, 1.0, ATTN_NORM, 0, PITCH_NORM );
		return FMRES_SUPERCEDE;
	}
	if( containi( sound,  "weapons/m249-2.wav"  ) != -1 )
	{
		emit_sound( id, channel, MiniSound, 1.0, ATTN_NORM, 0, PITCH_NORM );
		return FMRES_SUPERCEDE;
	}
	
	return FMRES_IGNORED;
}*/

public fw_Think(ent)
{

	if(!pev_valid(ent) || MODE_Num != 6 )
		return FMRES_IGNORED
	
	static class[20]
	pev(ent,pev_classname,class,sizeof class - 1)
	

	if(equali(class,"snow_splash"))
		engfunc(EngFunc_RemoveEntity,ent)

		
	return FMRES_IGNORED
}


public FwdGrenadeThink( iEntity )
{
	new Float:dmgtime; 
	
	pev(iEntity,pev_dmgtime,dmgtime);
	//pev(iEntity,pev_speed,1005);
	
	if(dmgtime > get_gametime()) 
	{
		return FMRES_IGNORED;
	}
	else
	{
		remove_entity ( iEntity )
	}
	
	return FMRES_SUPERCEDE;
}



public reset_models(entity,const model[])
{
	
	if(!pev_valid(entity) || MODE_Num != 6 )
		return FMRES_IGNORED
		
	if(equali(model,"models/w_hegrenade.mdl"))
	{
		engfunc(EngFunc_SetModel,entity,MODEL_NADE_WORLD)
		return FMRES_SUPERCEDE
		
	}
	else if(equali(model,"models/w_flashbang.mdl"))
		engfunc(EngFunc_SetModel,entity,MODEL_NADE_WORLD)
	else if(equali(model,"models/w_smokegrenade.mdl"))
		engfunc(EngFunc_SetModel,entity,MODEL_NADE_WORLD)
		

	return FMRES_IGNORED
}




public fwdUse(ent, idcaller, idactivator, use_type, Float:value) 
{     
	if (is_user_alive(idactivator) && get_user_team(idactivator) == 1 ) 
	{     
		if ( Mode_ON )
		{
			switch ( MODE_Num )
			{
				case 0:
				{
					client_print(idactivator, print_center, "Вы выбрали %s!", MODE[MODE_Num] )     
					return HAM_SUPERCEDE     
				}
				case 1:
				{
					client_print(idactivator, print_center, "Вы выбрали %s", MODE[MODE_Num])     
					return HAM_SUPERCEDE     
				}
				case 2:
				{
					if ( buttons_pressed[idactivator] >= get_cvar_num ( "death_assist_zombie_buttons" ) )
					{
						client_print(idactivator, print_center, "%L",idactivator,"ZOMBIE_STUPID" )     
						return HAM_SUPERCEDE     
					}
					else
					{
						buttons_pressed[idactivator] += 1;
						client_print(idactivator, print_center, "%L",idactivator,"ZOMBIE_BUTTONS", get_cvar_num ( "death_assist_zombie_buttons" )-buttons_pressed[idactivator] )     
					}
				}
				case 3:
				{
					client_print(idactivator, print_center, "%L",idactivator,"REMBO_BUTTONS" )
					return HAM_SUPERCEDE     
				}
				case 5:
				{
					if ( buttons_pressed[idactivator] >= get_cvar_num ( "death_assist_hunter_buttons" ) )
					{
						client_print(idactivator, print_center, "%L",idactivator,"HUNTER_GONE" )     
						return HAM_SUPERCEDE     
					}
					else
					{
						buttons_pressed[idactivator] += 1;
						client_print(idactivator, print_center, "%L",idactivator,"HUNTER_BUTTONS", get_cvar_num ( "death_assist_hunter_buttons" )-buttons_pressed[idactivator] )     
					}
				}
				case 6:
				{
					if ( buttons_pressed[idactivator] >= get_cvar_num ( "death_assist_snow_buttons" ) )
					{
						client_print(idactivator, print_center, "%L",idactivator,"SNOW_FREEZED" )     
						return HAM_SUPERCEDE     
					}
					else
					{
						buttons_pressed[idactivator] += 1;
						client_print(idactivator, print_center, "%L",idactivator,"SNOW_BUTTONS", get_cvar_num ( "death_assist_snow_buttons" )-buttons_pressed[idactivator] )     
					}
				}
			}
		}
		else
		{
			client_print(idactivator, print_center, "Вы не выбрали никакого режима!" )     
			return HAM_SUPERCEDE     
		}
		  
	}

	return HAM_IGNORED     
} 


public fwdTouch(ent, id) 
{     
	if ( is_user_alive(id) )     
		if (  MODE_Num > 0 )
		{
			switch (MODE_Num)
			{
				case 0:
					return HAM_SUPERCEDE;
				case 1:
					return HAM_SUPERCEDE;
				case 5:
					return HAM_SUPERCEDE;
				case 6:
					return HAM_SUPERCEDE;
			}
		}

	return HAM_IGNORED     
}   

public unfreeze ( id )
{
	if ( id > 202020 )
		id -= 202020;
	
	if ( is_user_connected ( id ) )
		Freezed[id] = false;
}


public FwdHamTouch_Grenade( iEntity, id ) 
{
	if((!pev_valid(iEntity)) || MODE_Num != 6 )
		return FMRES_IGNORED
	
	new classname[20],classname2[20],Float:origin[3],owner = pev(iEntity,pev_owner)
	
	pev(iEntity,pev_origin,origin)
	pev(id,pev_classname,classname2,sizeof classname2 - 1)
	pev(iEntity,pev_classname,classname,sizeof classname - 1)
	
	
	if(equali(classname,"grenade") && equali(classname2,"player"))
	{
		if(is_user_alive(id))
		{
			if(get_user_health(id) > SNOW_BALL_DAMAGE)
			{
				sw_effect(origin)
				sw_effect(origin)
				set_user_health(id, get_user_health(id) - (SNOW_BALL_DAMAGE))
				
				Freezed[id] = true;
				if ( !task_exists( id + 202020 ) )
					set_task ( 1.0, "unfreeze", id + 202020 );
				//remove_entity ( iEntity )
				//sw_splash(iEntity,origin)
				
			}
			else if(get_user_health(id) <= SNOW_BALL_DAMAGE)
			{
				sw_effect(origin)
				util_kill(owner,id, "weapon_hegrenade")
				set_pev(iEntity, pev_solid, SOLID_NOT)
				set_pev(iEntity, pev_velocity, Float:{9999.9, 9999.9, 9999.9})
				//remove_entity ( iEntity )
			}	
		}else
		{	
			sw_effect(origin);
		}
		
	}
	else if(equali(classname,"grenade"))
	{
		// Miss!!
		if ( get_cvar_num ( "death_assist_snow_multi" ) > 0 )
			set_pev(iEntity, pev_velocity, Float:{999.0, 999.0, 0.0})
		else
		{
			set_pev(iEntity, pev_velocity, Float:{0.0, 0.0, 0.0})
			set_pev(iEntity, pev_solid, SOLID_NOT)
			set_pev(iEntity, pev_movetype, MOVETYPE_NONE)
			engfunc(EngFunc_SetOrigin, iEntity, origin)
		}
		
		set_pev(iEntity, pev_classname, "snow_splash")
		set_pev(iEntity,pev_nextthink,get_gametime() + 100)
		sw_effect(origin)
		sw_effect(origin)
		sw_effect(origin)
		
	}
	
	
	return FMRES_IGNORED
	
	
}


public util_kill(killer, victim, weapon[])
{
	if (get_user_team(killer) != get_user_team(victim))
	{
		user_silentkill(victim);
		make_deathmsg(killer, victim, 0, weapon);

		set_user_frags(killer, get_user_frags(killer) + 1);

		new money = cs_get_user_money(killer) + 300;
		if (money >= 16000)
			cs_set_user_money(killer, 16000);
		else
			cs_set_user_money(killer, money, 1);
	}
	else
	{
		if (get_cvar_num("mp_friendlyfire") == 1)
		{
			user_silentkill(victim);
			make_deathmsg(killer, victim, 0, weapon);

			set_user_frags(killer, get_user_frags(killer) - 1);

			new money = cs_get_user_money(killer) - 3300;
			if (money <= 0)
				cs_set_user_money(killer, 0);
			else
				cs_set_user_money(killer, money, 1);
		}
	}

	message_begin(MSG_BROADCAST, get_user_msgid("ScoreInfo"));
	write_byte(killer);			 // Destination
	write_short(get_user_frags(killer));	 // Frags
	write_short(cs_get_user_deaths(killer)); // Deaths
	write_short(0);				 // Player class
	write_short(get_user_team(killer));	 // Team
	message_end();

	message_begin(MSG_BROADCAST, get_user_msgid("ScoreInfo"));
	write_byte(victim);			 // Destination
	write_short(get_user_frags(victim));	 // Frags
	write_short(cs_get_user_deaths(victim)); // Deaths
	write_short(0);				 // Player class
	write_short(get_user_team(victim));	 // Team
	message_end();

	static kname[32];
	static vname[32];
	static kteam[10];
	static vteam[10];
	static kauthid[32];
	static vauthid[32];

	get_user_name(killer, kname, sizeof(kname));
	get_user_team(killer, kteam, sizeof(kteam));
	get_user_authid(killer, kauthid, sizeof(kauthid));

	get_user_name(victim, vname, sizeof(vname));
	get_user_team(victim, vteam, sizeof(vteam));
	get_user_authid(victim, vauthid, sizeof(vauthid));

	log_message("^"%s<%d><%s><%s>^" killed ^"%s<%d><%s><%s>^" with ^"%s^"", 
	kname, get_user_userid(killer), kauthid, kteam, 
 	vname, get_user_userid(victim), vauthid, vteam, weapon);
}


public Check_Mode_Bad ( id, num )
{
	if ( !timer[id] && !Mode_ON )
	{
		new i;
		for ( i = 0; i < 3; ++i )
		{
			if ( Last_Three_Rounds[i] == num )
			{
				return true;
			}
		}
	}
	
	return false;
}

public Disable_Menu ( id )
{
	if ( task_exists ( id + 41292 ) )
	{
		remove_task ( id + 41292 );
	}
}

public CMD_modes(id, level, cid)
{

	if(  !timer[id] ) 
	{
		if (  get_user_team(id) != 1 || Mode_ON ) 
		{     
			client_print(id, print_center, "")     
			return PLUGIN_CONTINUE     
		}
		
		
		new message[192];
		read_args(message, 191)
		remove_quotes(message)
		
		
		if (  containi( message, "/free" ) != -1 ||  contain(message, "free") != -1 )
		{
			
			if ( Check_Mode_Bad ( id, 0 ) )
			{
				new returntext[147];
				formatex(returntext, charsmax(returntext), "%L", id, "MODES_PER_ROUND", get_cvar_num("death_assist_mode_rounds") )
				colored_message( id, returntext,4 )
				return PLUGIN_HANDLED;
			}
			
			
			MODE_Num = 0;
			Mode_ON = true   
			timer[id] = false;
			
			current_round += 1;
			if ( current_round >= 3 )
				current_round = 0;
			Last_Three_Rounds[current_round] = MODE_Num;
			        
			set_dhudmessage(0, 255, 0, 0.01, 0.5, 0, 6.0, 5.0, 1.0, 1.5,false)
			show_dhudmessage(0, "%L",0,"FREE_GO")      
			
			set_user_health( id, 300 )
			
			new i
			for ( i = 1; i < 33; i++ ) 
			{     
				if ( is_user_alive ( i ) )
				{
					strip_user_weapons ( i)     
					give_item( i, "weapon_knife" )   
				}
			}     
			
			set_task ( 0.1, "Disable_Menu", id );
		}
		
		if (  containi( message, "/invis" ) != -1 ||  contain(message, "invis" ) != -1 )
		{
			if ( Check_Mode_Bad ( id, 1 ) )
			{
				new returntext[147];
				formatex(returntext, charsmax(returntext), "%L", id, "MODES_PER_ROUND", get_cvar_num("death_assist_mode_rounds") )
				colored_message( id, returntext,4 )
				return PLUGIN_HANDLED;
			}
			
			
			MODE_Num = 1;
			Mode_ON = true   
			timer[id] = false;
			
			current_round += 1;
			if ( current_round >= 3 )
				current_round = 0;
			Last_Three_Rounds[current_round] = MODE_Num;
			
			set_dhudmessage(0, 255, 0, 0.01, 0.5, 0, 6.0, 5.0, 1.0, 1.5,false)
			show_dhudmessage(0, "%L",0,"INVISE_GO")       
			
			set_user_health( id, 250 )
			
			set_user_rendering( id, kRenderFxNone, 0, 0, 0, kRenderTransAlpha, 0 )
			
			set_task ( 0.1, "Disable_Menu", id );
			
		}
		
		if (  containi( message, "/zombie" ) != -1 ||  contain(message, "zombie") != -1 ||  contain(message, "/zm") != -1  )
		{
			if ( Check_Mode_Bad ( id, 2 ) )
			{
				new returntext[147];
				formatex(returntext, charsmax(returntext), "%L", id, "MODES_PER_ROUND", get_cvar_num("death_assist_mode_rounds") )
				colored_message( id, returntext,4 )
				return PLUGIN_HANDLED;
			}
			
			
			MODE_Num = 2;
			Mode_ON = true   
			timer[id] = false;
			
			current_round += 1;
			if ( current_round >= 3 )
				current_round = 0;
			Last_Three_Rounds[current_round] = MODE_Num;
			
			strip_user_weapons(id)
			give_item ( id, "weapon_knife");
			cs_set_user_model(id, "zombie_csurban")
			re_zombie_spawn_effects (id )
			
			set_user_health( id, get_cvar_num("death_assist_zm_health"))
			
			set_dhudmessage(0, 255, 0, 0.01, 0.5, 0, 6.0, 5.0, 1.0, 1.5,false)
			show_dhudmessage(0, "%L",0,"ZOMBI_GO")      
			set_lights ( "c" );
			
			
			set_task ( 0.1, "Disable_Menu", id );
			
		}
		
		if (  containi( message, "/rembo" ) != -1  ||  contain(message, "rembo") != -1  )
		{
			if ( Check_Mode_Bad ( id, 3 ) )
			{
				new returntext[147];
				formatex(returntext, charsmax(returntext), "%L", id, "MODES_PER_ROUND", get_cvar_num("death_assist_mode_rounds") )
				colored_message( id, returntext,4 )
				return PLUGIN_HANDLED;
			}
			
			
			MODE_Num = 3;
			Mode_ON = true   
			timer[id] = false;
			
			current_round += 1;
			if ( current_round >= 3 )
				current_round = 0;
			Last_Three_Rounds[current_round] = MODE_Num;
			
			set_dhudmessage(0, 255, 0, 0.01, 0.5, 0, 6.0, 5.0, 1.0, 1.5,false)
			show_dhudmessage(0, "%L",0,"REMBO_GO")    
			
			new i;
			
			for (i = 1; i < 33; i++) 
			{ 
				if ( is_user_alive ( i ) )
				{
					strip_user_weapons ( i );
					set_user_health( i , get_user_health( i ) + 50 )
					set_user_rendering( i, kRenderFxNone, 0, 0, 0, kRenderTransAlpha, 0 )
					give_item( i, "weapon_knife")
					give_item( i, "weapon_shield")
					give_item( i, "weapon_glock18")
					cs_set_user_bpammo( i, CSW_GLOCK18, 220)   
				}
			}
			
			
			set_user_health( id , get_user_health( id ) + 200 )
				
			strip_user_weapons ( id );
			set_user_rendering( id );
			
			new name[33];
			get_user_name(id, name, 33);
			server_cmd ( "dr_assist_rembogun %s 1000", name) ;
			set_user_gravity(id, 0.9)
			 
			set_task ( 0.1, "Disable_Menu", id );
			
		}
		
		if (  containi( message, "/class1c" ) != -1  )
		{
			
			
			current_round += 1;
			if ( current_round >= 3 )
				current_round = 0;
			Last_Three_Rounds[current_round] = MODE_Num;
			
			MODE_Num = -1;
			Mode_ON = true   
			timer[id] = false;
			
			
			set_dhudmessage(0, 255, 0, 0.01, 0.5, 0, 6.0, 5.0, 1.0, 1.5,false)
			show_dhudmessage(0, "%L",0,"CLASSIC_GO")    
			
			set_task ( 0.1, "Disable_Menu", id );
			
			
			return PLUGIN_HANDLED;
			
		}
		
		if (  containi( message, "/hunters" ) != -1  )
		{
			
			if ( Check_Mode_Bad ( id, 5 ) )
			{
				new returntext[147];
				formatex(returntext, charsmax(returntext), "%L", id, "MODES_PER_ROUND", get_cvar_num("death_assist_mode_rounds") )
				colored_message( id, returntext,4 )
				return PLUGIN_HANDLED;
			}
			
			
			MODE_Num  = 5;
			Mode_ON = true   
			timer[id] = false;
			
			current_round += 1;
			if ( current_round >= 3 )
				current_round = 0;
			Last_Three_Rounds[current_round] = MODE_Num;
			
			
			set_dhudmessage(0, 255, 0, 0.01, 0.5, 0, 6.0, 5.0, 1.0, 1.5,false)
			show_dhudmessage(0, "%L",0,"HUNTER_GO")   

			
			
			set_user_health( id, 1000 )
			set_user_gravity(id, 0.4)	
			set_user_rendering ( id, kRenderFxGlowShell, 255, 0, 0, kRenderGlow, 16 )
			new i;
			
			for (i = 1; i < 33; i++) 
			{ 
				if ( is_user_alive ( i ) )
				{
					if ( cs_get_user_team ( i ) == CS_TEAM_CT )
					{
						strip_user_weapons ( i );
						give_item( i, "weapon_knife")
						give_item( i, "weapon_deagle")
						give_item( i, "weapon_awp")
						cs_set_user_bpammo( i, CSW_DEAGLE,100)   
						cs_set_user_bpammo( i, CSW_AWP, 50)
					}
				}
			}
			
			set_task ( 0.1, "Disable_Menu", id );
			
			return PLUGIN_HANDLED;
			
		}
		
		if (  containi( message, "/snowballs" ) != -1  )
		{
			
			if ( Check_Mode_Bad ( id, 6 ) )
			{
				new returntext[147];
				formatex(returntext, charsmax(returntext), "%L", id, "MODES_PER_ROUND", get_cvar_num("death_assist_mode_rounds") )
				colored_message( id, returntext,4 )
				return PLUGIN_HANDLED;
			}
			
			
			MODE_Num  = 6;
			Mode_ON = true   
			timer[id] = false;
			
			current_round += 1;
			if ( current_round >= 3 )
				current_round = 0;
			Last_Three_Rounds[current_round] = MODE_Num;
			
			
			set_dhudmessage(0, 255, 0, 0.01, 0.5, 0, 6.0, 5.0, 1.0, 1.5,false)
			show_dhudmessage(0, "%L",0,"Snow_GO")   
			
			
			new i;
			
			for (i = 1; i < 33; i++) 
			{ 
				if ( is_user_alive ( i ) )
				{
						strip_user_weapons ( i );
						//give_item( i, "weapon_knife")
						give_item( i, "weapon_hegrenade")
				}
			}
			
			set_task ( 0.1, "Disable_Menu", id );
			
			return PLUGIN_HANDLED;
			
		}

	}
	else 
	{    
		client_print( id,print_chat, "%s Время выбора режима прошло!", TITLE )
		client_print(0,print_chat, "%L",0,"CLASSIC_GO")
		set_task ( 0.1, "Disable_Menu", id );
	}    
	
	return PLUGIN_CONTINUE
}

public re_zombie_spawn_effects (id )
{
	const UNIT_SECOND = (1<<12)
	
	message_begin(MSG_ONE_UNRELIABLE, g_msgScreenShake, _, id)
	write_short(UNIT_SECOND*4) // amplitude
	write_short(UNIT_SECOND*2) // duration
	write_short(UNIT_SECOND*10) // frequency
	message_end()
	
	static origin[3]
	
	get_user_origin(id, origin)
	message_begin(MSG_PVS, SVC_TEMPENTITY, origin)
	write_byte(TE_IMPLOSION) // TE id
	write_coord(origin[0]) // x
	write_coord(origin[1]) // y
	write_coord(origin[2]) // z
	write_byte(128) // radius
	write_byte(20) // count
	write_byte(3) // duration
	message_end()
	message_begin(MSG_PVS, SVC_TEMPENTITY, origin)
	write_byte(TE_DLIGHT) // TE id
	write_coord(origin[0]) // x
	write_coord(origin[1]) // y
	write_coord(origin[2]) // z
	write_byte(20) // radius
	write_byte(125) // r
	write_byte(22) // g
	write_byte(12) // b
	write_byte(2) // life
	write_byte(0) // decay rate
	message_end()
}


public eventRoundStart() 
{     
	new i  
	
	Mode_ON = false    
	MODE_Num = -1;
	Ticks = 25
	
	set_lights ( "z" );
	
	
	for(i=1;i<= 33;i++) 
	{
		if(is_user_connected(i)) 
		{
			timer[i] = false  
			cs_reset_user_model(i)
			set_user_rendering( i )
			
			if ( cs_get_user_team(i)==CS_TEAM_T && !is_user_bot ( i ) )
				set_task ( 1.0, "T_Menu_Try", i + 41292, _, _, "a", Ticks );
		}
	}  
	
	 
}  


public T_Menu_Try ( id )
{
	if ( id > 41292 )
		id -= 41292
	
	Ticks -= 1;
	
	if ( Ticks < 1 )
	{
		if ( task_exists ( id + 41292 ) )
			remove_task ( id + 41292 );	
		
		//client_cmd ( id, "say /class1c" );
		set_task ( 1.1, "Hide_Menu", id + 41293 );
		
		timer[id] = true
	}
		
	if ( is_user_connected ( id ) )
		if ( !Mode_ON  )
			T_Menu ( id )
		else
		{
			show_menu(id, 0, "^n", 1);
			client_cmd ( id, "say /class1c" );
		}
}

public Hide_Menu(id)
{
	if ( id > 41293 )
		id -= 41293
	
	show_menu(id, 0, "^n", 1);
	client_cmd ( id, "say /class1c" );
}


public death_msg()  
{     
	new id = read_data(2)  
	
	if ( Mode_ON && MODE_Num == 2 )
		if (cs_get_user_team(id)!=CS_TEAM_T)
			emit_sound(id, CHAN_VOICE, death_zombie[random_num(0, ZOMBIE_DEATH - 1)], 1.0, ATTN_NORM, 0, PITCH_NORM)
	Activated_HPARMOR[id] = 0;
	Activated_Gravity[id] = 0;
	Activated_Run[id] = 0;
	Activated_Stealth[id] = 0;
	Activated_Deagle[id] = 0;
}


public client_putinserver ( id )
{
	client_cmd(id, "bind F3 menu")
	set_task ( 1.0, "updateGood_HashHUD", id + 5016 );
}
	

public updateGood_HashHUD ( id )
{
	if ( id > 5016 )
		id -= 5016;
	
	new timestring[31],timeleft_minutes, timeleft_seconds,  T_counter = 0, CT_countedAlive = 0, CT_countedDead = 0;
	
	get_time("%H:%M",timestring,8)
	
	timeleft_minutes = get_timeleft()/60
	timeleft_seconds = get_timeleft()%60
	
	new name[33], T_names[200], message[500], Now_MOD[300], zapytaya[7];
	static o;
	
	for ( o = 1; o < 32; ++o )
	{
		if ( !is_user_connected(o) )
			continue
		
		if ( cs_get_user_team(o)==CS_TEAM_T )
		{
			get_user_name ( o, name, 33);
			
			if ( T_counter > 0 )
				format ( zapytaya, charsmax(zapytaya), "%s", ", ")
			else
				format ( zapytaya, charsmax(zapytaya), "%s", "")
				
			formatex ( T_names, charsmax(T_names), "%s%s %s", T_names, zapytaya, name );
			T_counter += 1; // ololo =(
		}	
		
		if ( cs_get_user_team(o)==CS_TEAM_CT )
		{
			if ( is_user_alive (o) )
				CT_countedAlive += 1;
			else
				CT_countedDead += 1;
		}
		
	}
	
	new a = MODE_Num;
	if ( a < 0 )
		copy ( Now_MOD, charsmax(Now_MOD), "Классика" )
	else
		copy ( Now_MOD, charsmax(Now_MOD), MODE[MODE_Num] )
		
	set_hudmessage ( 255, 255, 255, 0.015, 0.15, 0, 6.0, 2.0, 0.1, 0.2, 4 )
	formatex(message, charsmax(message), "%L", id, "HUD_STATUS", Now_MOD, timestring, timeleft_minutes, timeleft_seconds, T_names, CT_countedAlive+CT_countedDead+T_counter, maxPlayers, CT_countedAlive, CT_countedAlive+CT_countedDead)
	show_hudmessage(id, message);
	
	set_task ( 1.0, "updateGood_HashHUD", id + 5016 );
}


public cmdJoinTeam(id) 
{
	///Deathrun_Assist_Menu ( id );
	///set_task ( 0.1, "Deathrun_Assist_Menu", id + ASSIST_MENU_ID );
}


public Deathrun_Assist_Menu ( id )
{
	
	if ( id > ASSIST_MENU_ID )
		id -= ASSIST_MENU_ID
		
	new i_Menu, menuTitle[127], main1[127], main2[127], main3[127], NEXT[20], BACK[20], EXIT[20];
	
	formatex(menuTitle, charsmax(menuTitle), "%L", id, "MENU_TITLE_MAIN");
	formatex(main1, charsmax(main1), "%L", id, "MENU_MAIN_FREE");
	formatex(main2, charsmax(main2), "%L", id, "MENU_MAIN_OPERATIONS");
	formatex(main3, charsmax(main3), "%L", id, "MENU_MAIN_BLACK");
	formatex(NEXT, charsmax(NEXT), "%L", id, "NEXT");
	formatex(BACK, charsmax(BACK), "%L", id, "BACK");
	formatex(EXIT, charsmax(EXIT), "%L", id, "EXIT");
	i_Menu = menu_create(menuTitle, "__Deathrun_Assist_Menu")
	menu_additem(i_Menu, main1, "1", 0)
	menu_additem(i_Menu, main2, "2", 0)
	menu_additem(i_Menu, main3, "3", 0)
	menu_addblank(i_Menu, 7)
	menu_addblank(i_Menu, 8)
	menu_addblank(i_Menu, 9)
	menu_setprop(i_Menu, MPROP_NEXTNAME, NEXT)
	menu_setprop(i_Menu, MPROP_BACKNAME, BACK)
	menu_setprop(i_Menu, MPROP_EXITNAME, EXIT)
	menu_setprop(i_Menu, MPROP_EXIT, MEXIT_ALL)
	menu_display(id, i_Menu, 0)
}

public resetspeed(who)
{
	new newSpeed;
	/*if ( newSpeed == 3 )
		newSpeed = 500;
	else if ( newSpeed == 5 )
		newSpeed = 900;
	else*/
	newSpeed = 250;
	
	entity_set_float( who, EV_FL_maxspeed, float(newSpeed) )
}
	
public set_stealth ( id )
{
	if ( is_user_alive( id ) && Activated_Stealth[id] )
	{
		set_user_rendering(id,kRenderFxNone, 0,0,0, kRenderTransTexture, 1 )
	}
	
}
public TestLivesNative ( id )
{
	new lives = get_user_lives ( id );
	client_print( id, print_chat, "%s lives are %i", TITLE, lives )
	
}

public SetLivesNative ( id )
{
	new lives = get_user_lives ( id );
	set_user_lives ( id, lives + 2 );
	lives = get_user_lives ( id );
	client_print( id, print_chat, "%s lives are %i", TITLE, lives )
	
}


public client_PreThink(id) 
{
	
	if ( get_pcvar_num ( assist_bhop ) < 1 )
		return PLUGIN_CONTINUE;
	/*
				[ Bunny Hop Production ]
	*/
	
	entity_set_float(id, EV_FL_fuser2, 0.0)	
	

	if (entity_get_int(id, EV_INT_button) & 2) 
	{	
		

		new flags = entity_get_int(id, EV_INT_flags)

		if (flags & FL_WATERJUMP)
			return PLUGIN_CONTINUE
			
		if ( entity_get_int(id, EV_INT_waterlevel) >= 2 )
			return PLUGIN_CONTINUE
			
		if ( !(flags & FL_ONGROUND) )
			return PLUGIN_CONTINUE

		new Float:velocity[3];
		
		entity_get_vector(id, EV_VEC_velocity, velocity)
			
		velocity[2] += 250.0
		
		entity_set_vector(id, EV_VEC_velocity, velocity)
		
		entity_set_int(id, EV_INT_gaitsequence, 6)
		
		set_user_maxspeed(id , float ( 999) );
	}
	else
		resetspeed ( id );
	
	if (is_user_alive(id))
	{
		set_stealth(id);
		if ( Freezed[id] )
			set_user_maxspeed ( id, float(55 ) );
		/*if ( Activated_Run[id] )
		{
			set_user_maxspeed(id, float(400))
		}
		else if ( MODE_Num == 5 && ( cs_get_user_team ( id ) == CS_TEAM_T ))
			set_user_maxspeed( id, float(900))
		else if ( MODE_Num == 3 && ( cs_get_user_team ( id ) == CS_TEAM_T ))
			set_user_maxspeed( id, float( 500 ))*/
	}
	/*
				[ Bunny Hop Production ]
	*/
	
	
	return PLUGIN_CONTINUE
}

public T_Menu ( id )
{
		
		
	new i_Menu, menuTitle[127], main1[127], main2[127], main3[127], main4[127], main5[127],  main6[127], main7[127], NEXT[20], BACK[20], EXIT[20];
	
	formatex(menuTitle, charsmax(menuTitle), "%L", id, "MENU_TITLE_T", Ticks );
	formatex(main1, charsmax(main1), "%s", MODE[0] )     
	formatex(main2, charsmax(main2), "%s", MODE[1] )   
	formatex(main3, charsmax(main3), "%s", MODE[2] )     
	formatex(main4, charsmax(main4), "%s", MODE[3] )   
	formatex(main5, charsmax(main5), "%s", MODE[4] )   
	formatex(main6, charsmax(main6), "%s", MODE[5] )   
	formatex(main7, charsmax(main7), "%s", MODE[6] )   
	formatex(NEXT, charsmax(NEXT), "%L", id, "NEXT");
	formatex(BACK, charsmax(BACK), "%L", id, "BACK");
	i_Menu = menu_create(menuTitle, "__T_Menu")
	menu_additem(i_Menu, main1, "1", 0)
	menu_additem(i_Menu, main2, "2", 0)
	menu_additem(i_Menu, main3, "3", 0)
	menu_additem(i_Menu, main4, "4", 0)
	menu_additem(i_Menu, main5, "5", 0)
	menu_additem(i_Menu, main6, "6", 0)
	menu_additem(i_Menu, main7, "7", 0)
	menu_setprop(i_Menu, MPROP_NEXTNAME, NEXT)
	menu_setprop(i_Menu, MPROP_BACKNAME, BACK)
	menu_setprop(i_Menu, MPROP_EXITNAME, EXIT)
	menu_setprop(i_Menu, MPROP_EXIT,-1)
	menu_display(id, i_Menu, 0)
	
	return;
}

public __T_Menu(id, menu, item)
{
	if (item == MENU_EXIT)
	{
		menu_destroy(menu)
		return PLUGIN_HANDLED
	}
	
	
	if ( Mode_ON  || timer[id] == true )
	{
		menu_destroy(menu)
		return PLUGIN_HANDLED
	}
	
	new s_Data[6], s_Name[64], i_Access, i_Callback
	menu_item_getinfo(menu, item, i_Access, s_Data, charsmax(s_Data), s_Name, charsmax(s_Name), i_Callback)
    
	new i_Key = str_to_num(s_Data)
		
		
	switch(i_Key)
	{
		case 1:
		{
			client_cmd ( id, "say /free" );
		}
		case 2:
		{
			client_cmd ( id, "say /invise" );
		}
		case 3:
		{
			client_cmd ( id, "say /zm" );
		}
		case 4:
		{
			client_cmd ( id, "say /rembo" );
		}
		case 5:
		{
			client_cmd ( id, "say /class1c" );
		}
		case 6:
		{
			client_cmd ( id, "say /hunters" );
		}
		case 7:
		{
			client_cmd ( id, "say /snowballs" );
		}
	}
	


	menu_destroy(menu)
	return PLUGIN_HANDLED
}


public __Deathrun_Assist_Menu(id, menu, item)
{
	if (item == MENU_EXIT)
	{
		menu_destroy(menu)
		return PLUGIN_HANDLED
	}

	new s_Data[6], s_Name[64], i_Access, i_Callback
	menu_item_getinfo(menu, item, i_Access, s_Data, charsmax(s_Data), s_Name, charsmax(s_Name), i_Callback)
    
	new i_Key = str_to_num(s_Data)

	switch(i_Key)
	{
		case 1:
		{
			Free_Menu(id)
		}
		case 2:
		{
			client_cmd ( id, "buyequip" );
			//PayMent_Menu(id)
		}
		case 3:
		{
			Black_Fun_Menu(id)
		}
	}

	menu_destroy(menu)
	return PLUGIN_HANDLED
}


public Black_Fun_Menu ( id )
{
	new i_Menu, menuTitle[127], main1[127], main2[127],  NEXT[20], BACK[20], EXIT[20];
	
	formatex(menuTitle, charsmax(menuTitle), "%L", id, "MENU_TITLE_BLACK");
	formatex(main1, charsmax(main1), "%L", id, "MENU_BLACK_LIVE_BUY", 1 );
	formatex(main2, charsmax(main2), "%L", id, "MENU_BLACK_LIVE_SELL", CONFIG_GRAVITY_COST );
	formatex(NEXT, charsmax(NEXT), "%L", id, "NEXT");
	formatex(BACK, charsmax(BACK), "%L", id, "BACK");
	formatex(EXIT, charsmax(EXIT), "%L", id, "EXIT");
	i_Menu = menu_create(menuTitle, "__Black_Fun_Menu")
	menu_additem(i_Menu, main1, "100", 0)
	menu_additem(i_Menu, main2, "101", 0)
	menu_addblank(i_Menu, 7)
	menu_addblank(i_Menu, 8)
	menu_addblank(i_Menu, 9)
	menu_setprop(i_Menu, MPROP_NEXTNAME, NEXT)
	menu_setprop(i_Menu, MPROP_BACKNAME, BACK)
	menu_setprop(i_Menu, MPROP_EXITNAME, EXIT)
	menu_setprop(i_Menu, MPROP_EXIT, MEXIT_ALL)
	menu_display(id, i_Menu, 0)
}


public PayMent_Menu ( id )
{
	new i_Menu, menuTitle[127], main1[127], main2[127], main3[127], main4[127], main5[127], NEXT[20], BACK[20], EXIT[20];
	
	formatex(menuTitle, charsmax(menuTitle), "%L", id, "MENU_TITLE_PAY");
	formatex(main1, charsmax(main1), "%L", id, "MENU_PAY_HPARMOR", CONFIG_HP, CONFIG_ARMOR, CONFIG_HPARMOR_COST );
	formatex(main2, charsmax(main2), "%L", id, "MENU_PAY_GRAVITY", CONFIG_GRAVITY_COST );
	formatex(main3, charsmax(main3), "%L", id, "MENU_PAY_RUN", CONFIG_RUN_COST );
	formatex(main4, charsmax(main4), "%L", id, "MENU_PAY_STEALTH", CONFIG_STEALTH_COST );
	formatex(main5, charsmax(main5), "%L", id, "MENU_PAY_DEAGLE", CONFIG_DEAGLE_COST );
	formatex(NEXT, charsmax(NEXT), "%L", id, "NEXT");
	formatex(BACK, charsmax(BACK), "%L", id, "BACK");
	formatex(EXIT, charsmax(EXIT), "%L", id, "EXIT");
	i_Menu = menu_create(menuTitle, "__PayMent_Menu")
	menu_additem(i_Menu, main1, "1", 0)
	menu_additem(i_Menu, main2, "2", 0)
	menu_additem(i_Menu, main3, "3", 0)
	menu_additem(i_Menu, main4, "4", 0)
	menu_additem(i_Menu, main5, "5", 0)
	menu_addblank(i_Menu, 7)
	menu_addblank(i_Menu, 8)
	menu_addblank(i_Menu, 9)
	menu_setprop(i_Menu, MPROP_NEXTNAME, NEXT)
	menu_setprop(i_Menu, MPROP_BACKNAME, BACK)
	menu_setprop(i_Menu, MPROP_EXITNAME, EXIT)
	menu_setprop(i_Menu, MPROP_EXIT, MEXIT_ALL)
	menu_display(id, i_Menu, 0)
}



public Free_Menu ( id )
{
	new i_Menu, menuTitle[127], main1[127], main2[127], main3[127], NEXT[20], BACK[20], EXIT[20];
	
	formatex(menuTitle, charsmax(menuTitle), "%L", id, "MENU_TITLE_MAIN");
	formatex(main1, charsmax(main1), "%L", id, "MENU_FREE_TRAIL");
	formatex(main2, charsmax(main2), "%L", id, "MENU_TRAIL_OFF");
	formatex(main3, charsmax(main3), "%L", id, "MENU_CAM_SET");
	formatex(NEXT, charsmax(NEXT), "%L", id, "NEXT");
	formatex(BACK, charsmax(BACK), "%L", id, "BACK");
	formatex(EXIT, charsmax(EXIT), "%L", id, "EXIT");
	i_Menu = menu_create(menuTitle, "__Free_Menu")
	menu_additem(i_Menu, main1, "1", 0)
	menu_additem(i_Menu, main2, "2", 0)
	menu_additem(i_Menu, main3, "3", 0)
	menu_addblank(i_Menu, 7)
	menu_addblank(i_Menu, 8)
	menu_addblank(i_Menu, 9)
	menu_setprop(i_Menu, MPROP_NEXTNAME, NEXT)
	menu_setprop(i_Menu, MPROP_BACKNAME, BACK)
	menu_setprop(i_Menu, MPROP_EXITNAME, EXIT)
	menu_setprop(i_Menu, MPROP_EXIT, MEXIT_ALL)
	menu_display(id, i_Menu, 0)
}


public __Black_Fun_Menu(id, menu, item)
{
	if (item == MENU_EXIT)
	{
		menu_destroy(menu)
		return PLUGIN_HANDLED
	}

	new s_Data[6], s_Name[64], i_Access, i_Callback
	menu_item_getinfo(menu, item, i_Access, s_Data, charsmax(s_Data), s_Name, charsmax(s_Name), i_Callback)
    
	new i_Key = str_to_num(s_Data)

	Buy_Something ( id, i_Key )

	menu_destroy(menu)
	return PLUGIN_HANDLED
}



public __Free_Menu(id, menu, item)
{
	if (item == MENU_EXIT)
	{
		menu_destroy(menu)
		return PLUGIN_HANDLED
	}

	new s_Data[6], s_Name[64], i_Access, i_Callback
	menu_item_getinfo(menu, item, i_Access, s_Data, charsmax(s_Data), s_Name, charsmax(s_Name), i_Callback)
    
	new i_Key = str_to_num(s_Data)

	switch(i_Key)
	{
		case 1:
		{
			client_cmd ( id, "say trail random" );
			client_print(id, print_chat, "%L", id, "MENU_FREE_TRAIL", TITLE );	
		}
		case 2:
		{
			client_cmd ( id, "say trail off" );
		}
		case 3:
		{
			client_cmd ( id, "say /cam" );
		}
	}

	menu_destroy(menu)
	return PLUGIN_HANDLED
}


public __PayMent_Menu(id, menu, item)
{
	if (item == MENU_EXIT)
	{
		menu_destroy(menu)
		return PLUGIN_HANDLED
	}

	new s_Data[6], s_Name[64], i_Access, i_Callback
	menu_item_getinfo(menu, item, i_Access, s_Data, charsmax(s_Data), s_Name, charsmax(s_Name), i_Callback)
    
	new i_Key = str_to_num(s_Data)

	Buy_Something ( id, i_Key )

	menu_destroy(menu)
	return PLUGIN_HANDLED
}

public Buy_Something ( id, ItemID )
{
	new returntext[147];
	
	if ( !is_user_alive(id) )
	{
		formatex(returntext, charsmax(returntext), "%L", id, "DEAD_TRY_BUY", TITLE);
		colored_message( id, returntext,4 )
		return PLUGIN_HANDLED
	}
   
	new money = cs_get_user_money(id)
	
	switch(ItemID)
	{
		case 1:
		{
			if (Activated_HPARMOR[id]  >= 1)
			{
				return PLUGIN_HANDLED;
			}
			if ( money >= CONFIG_HPARMOR_COST )
			{
				cs_set_user_money(id, money - CONFIG_HPARMOR_COST, 0)
				Activated_HPARMOR[id] += 1;
				cs_set_user_armor(id, 200, CS_ARMOR_VESTHELM);
				set_user_health(id, get_user_health ( id ) + 100 );
				
				formatex(returntext, charsmax(returntext), "%L", id, "BOUGHT_HP_ARMOR", TITLE);
				colored_message( id, returntext,3 )
			}
			else
			{
				formatex(returntext, charsmax(returntext), "%L", id, "NOT_ENOUGH_MONEY", TITLE);
				colored_message( id, returntext,4 )
			}
		
		}
		case 2:
		{
			if (Activated_Gravity[id]  >= 1)
			{
				return PLUGIN_HANDLED;
			}
			if (money >= CONFIG_GRAVITY_COST)
			{
				cs_set_user_money(id, money - CONFIG_GRAVITY_COST, 0)
				Activated_Gravity[id] += 1;
				SetGravity( id )
				
				formatex(returntext, charsmax(returntext), "%L", id, "BOUGHT_GRAVITY", TITLE);
				colored_message( id, returntext,3 )
			}
			else
			{
				formatex(returntext, charsmax(returntext), "%L", id, "NOT_ENOUGH_MONEY", TITLE);
				colored_message( id, returntext,4 )
			}
		
		}
		case 3:
		{
			if (Activated_Run[id]  >= 1)
			{
				return PLUGIN_HANDLED;
			}
			if (money >= CONFIG_RUN_COST)
			{
				cs_set_user_money(id, money - CONFIG_RUN_COST, 0)
				Activated_Run[id] += 1;
				
				formatex(returntext, charsmax(returntext), "%L", id, "BOUGHT_RUN", TITLE);
				colored_message( id, returntext,3 )
			}
			else
			{
				formatex(returntext, charsmax(returntext), "%L", id, "NOT_ENOUGH_MONEY", TITLE);
				colored_message( id, returntext,4 )
			}
		
		}
		case 4:
		{
			if (Activated_Stealth[id]  >= 1)
			{
				return PLUGIN_HANDLED;
			}
			if (money >= CONFIG_STEALTH_COST)
			{
				cs_set_user_money(id, money - CONFIG_STEALTH_COST, 0)
				Activated_Stealth[id] += 1;
				
				formatex(returntext, charsmax(returntext), "%L", id, "BOUGHT_STEALTH", TITLE);
				colored_message( id, returntext,3 )
			}
			else
			{
				formatex(returntext, charsmax(returntext), "%L", id, "NOT_ENOUGH_MONEY", TITLE);
				colored_message( id, returntext,4 )
			}
		
		}
		case 5:
		{
			if ( Mode_ON && MODE_Num == 2 )
			{
				formatex(returntext, charsmax(returntext), "%L", id, "ZOMBI_NO_WEAPON", TITLE);
				colored_message( id, returntext,4 )
				
				return PLUGIN_HANDLED;
			}
			
			if (Activated_Deagle[id]  >= 1)
			{
				return PLUGIN_HANDLED;
			}
			if (money >= CONFIG_DEAGLE_COST)
			{
				cs_set_user_money(id, money - CONFIG_DEAGLE_COST, 0)
				strip_user_weapons ( id );
				give_item ( id, "weapon_deagle" );
				give_item ( id, "weapon_knife" );
				
				formatex(returntext, charsmax(returntext), "%L", id, "BOUGHT_DEAGLE", TITLE);
				colored_message( id, returntext,3 )
				
				Activated_Deagle[id] += 1;
			}
			else
			{
				formatex(returntext, charsmax(returntext), "%L", id, "NOT_ENOUGH_MONEY", TITLE);
				colored_message( id, returntext,4 )
			}
		
		}
		case 100:
		{
			if (money >= CONFIG_LIVE_COST)
			{
				cs_set_user_money(id, money - CONFIG_LIVE_COST, 0)
				
				new lives = get_user_lives ( id );
				
				set_user_lives ( id, lives + 1 );
				
	
				formatex(returntext, charsmax(returntext), "%L", id, "BOUGHT_LIVE", TITLE, lives + 1 );
				colored_message( id, returntext,3 )
				
			}
			else
			{
				formatex(returntext, charsmax(returntext), "%L", id, "NOT_ENOUGH_MONEY", TITLE);
				colored_message( id, returntext,4 )
			}
		
		}
		case 101:
		{
			new lives = get_user_lives ( id );
			
			if ( lives >= 1 )
			{	
				set_user_lives ( id, lives - 1 );
				cs_set_user_money(id, money + CONFIG_LIVE_COST-2500, 1)
				
	
				formatex(returntext, charsmax(returntext), "%L", id, "SELL_LIVE", TITLE, lives - 1 );
				colored_message( id, returntext,3 )
				
			}
			else
			{
				formatex(returntext, charsmax(returntext), "%L", id, "NOT_ENOUGH_SOULS", TITLE);
				colored_message( id, returntext,4 )
			}
		
		}
	}
	
	return PLUGIN_CONTINUE;
}

public SetGravity( id )
{

	if ( !is_user_alive(id) )
	{
		return;
	}


	if ( Activated_Gravity[id] )
	{
		set_user_gravity( id, 0.4)//get_cvar_float ("jump_high"));
	}
	else
		set_user_gravity( id, 1.0)

	return;
}

sw_effect(Float:fOrigin[3])
 {
	 new origin[3]
	 FVecIVec(fOrigin,origin)
	
	 message_begin(MSG_BROADCAST,SVC_TEMPENTITY)
	 write_byte(TE_BLOODSPRITE)
	 write_coord(origin[0]+random_num(-20,20))
	 write_coord(origin[1]+random_num(-20,20))
	 write_coord(origin[2]+random_num(-20,20))
	 write_short(Blood_spray)
	 write_short(DropBlood)
	 write_byte(255)
	 write_byte(15)
	 message_end()
 }



public sw_kill(victim,killer,hs )
{
	new money = cs_get_user_money(killer)
	
	if (cs_get_user_money(killer) < 16000)
		cs_set_user_money(killer,money + 300,1)
		
	set_msg_block(gmsgDeathMsg,1)
	user_kill(victim,1)
	set_user_frags(killer,get_user_frags(killer) + 1)
	
	new wpnid,clip,ammo,wpn[32]
	wpnid = get_user_weapon(killer,clip,ammo)
	
	get_weaponname(wpnid,wpn,31)
	replace(wpn,31,"weapon_","")
	message_begin( MSG_ALL, gmsgDeathMsg,{0,0,0},0)
	write_byte(killer)
	write_byte(victim)
	write_byte(hs)
	write_string(wpn)
	message_end()
	
	new namea[24],namev[24],authida[20],authidv[20],teama[8],teamv[8]
	
	get_user_name(killer,namea,23) 
	get_user_team(killer,teama,7) 
	get_user_authid(killer,authida,19) 
	get_user_name(victim,namev,23) 
	get_user_team(victim,teamv,7) 
	get_user_authid(victim,authidv,19) 
	log_message("^"%s<%d><%s><%s>^" killed ^"%s<%d><%s><%s>^" with ^"%s^"", namea,get_user_userid(killer),authida,teama,namev,get_user_userid(victim),authidv,teamv, wpn )
}

public snowball_bug ( id )
{
	if ( MODE_Num != 6 )
		return	PLUGIN_CONTINUE
		
	if ( id > 5017 )
		id -= 5017;

	if ( !is_user_alive ( id ) )
		return PLUGIN_CONTINUE;

	give_item(id,"weapon_hegrenade")			
	engclient_cmd(id,"weapon_hegrenade")

	return PLUGIN_CONTINUE
}



bool:SHARED_IsGrenade( iWeapon )
{
	if ( iWeapon == CSW_HEGRENADE )
		return true;
	
	return false;
}




public grenade_throw( index, greindex, wId )
{
	
	if ( MODE_Num != 6 )
		return	
		
	if ( SHARED_IsGrenade( wId ) )
	{
		new iWidth = 3;

		Create_TE_BEAMFOLLOW( greindex, iTrail, 5, iWidth, 76, 231, 245, 196 );
		
		set_task ( 0.2, "snowball_bug", index + 5017 );
		
		set_task ( 5.0, "delete_grena", greindex + 5018 )
		
	}

	return;
}

public delete_grena ( ent )
{
	if ( ent > 5018 )
		ent -= 5018

	if(pev_valid(ent)) remove_entity(ent) 
}


stock Create_TE_BEAMFOLLOW(entity, iSprite, life, width, red, green, blue, alpha){

	message_begin( MSG_BROADCAST, SVC_TEMPENTITY )
	write_byte( TE_BEAMFOLLOW )
	write_short( entity )			// entity
	write_short( iSprite )			// model
	write_byte( life )				// life
	write_byte( width )				// width
	write_byte( red )				// red
	write_byte( green )				// green
	write_byte( blue )				// blue
	write_byte( alpha )				// brightness
	message_end()
}
