#include <amxmodx>
#include <zombieplague>
#include <dhudmessage>

#define PLUGIN "[ZP] Extra Item: Nemesis"
#define VERSION "0.2"
#define AUTHOR "Unreal/fezh/Shidla/QuZ/tERoR"

new g_nemesis, g_msgSayText, g_maxplayers, g_countnem
new pcvar_enabled, pcvar_cost, pcvar_hudtime

public plugin_init()
{
    register_plugin(PLUGIN, VERSION, AUTHOR)
    pcvar_enabled = register_cvar("zp_nemesis_buy", "1")
    pcvar_cost = register_cvar("zp_nemesis_cost", "70")
    pcvar_hudtime = register_cvar("zp_nemesis_hudtime", "5.0")

    g_nemesis = zp_register_extra_item("Купить дьявола", get_pcvar_num(pcvar_cost) , ZP_TEAM_ANY)

    g_maxplayers = get_maxplayers()
    g_msgSayText = get_user_msgid("SayText")

    register_cvar("zp_extra_nemesis", VERSION, FCVAR_SERVER|FCVAR_EXTDLL|FCVAR_UNLOGGED|FCVAR_SPONLY)
}

public plugin_cfg()
{
    g_countnem = 0
}

public zp_extra_item_selected(id, item)
{
    if(!get_pcvar_num( pcvar_enabled)) return PLUGIN_HANDLED

    if(item == g_nemesis)
    {
        if(g_countnem >= 3) 
        { 
            colored_print(id, "^x04[ZP]^x01 Вы исчерпали лимит покупки дьявола на карту!") 
            return ZP_PLUGIN_HANDLED 
        }
        else
        {
            g_countnem ++
            zp_make_user_nemesis(id)
            colored_print(id, "^x04[ZP]^x01 Вы купили дьявола!")
            set_task(get_pcvar_float( pcvar_hudtime ), "nemesis_message", id)
        }
    }
    return PLUGIN_HANDLED
}

public nemesis_message(id)
{
    new szName[32]
    get_user_name(id, szName, 31)
    set_dhudmessage(255, 0, 0, 0.05, 0.45, 1, 0.0, 5.0, 1.0, 1.0)
    show_dhudmessage(0, "Игрок %s купил дьявола!", szName)
}

stock colored_print(target, const message[],  any:...)
{
    static buffer[512]

    if(!target)
    {
        static player
        for(player = 1; player <= g_maxplayers; player ++)
        {
            if(!is_user_connected(player)) continue

            vformat(buffer, charsmax(buffer), message, 3)

            message_begin(MSG_ONE_UNRELIABLE, g_msgSayText, _, player)
            write_byte(player)
            write_string(buffer)
            message_end()
        }
    }
    else
    {
        vformat(buffer, charsmax( buffer ), message, 3)

        message_begin(MSG_ONE, g_msgSayText, _, target)
        write_byte(target)
        write_string(buffer)
        message_end()
    }
}  