//
// TRACKER SCHEME BY ShadE - icq 201027404
//
// sections:
//		colors			- all the colors used by the scheme
//		basesettings	- contains settings for app to use to draw controls
//		fonts			- list of all the fonts used by app
//		borders			- description of all the borders
//
// notes:
// 		hit ctrl-alt-shift-R in the app to reload this file
//
Scheme
{
	//////////////////////// COLORS ///////////////////////////
	Colors
	{
		// base colors
		"BaseText"		"255 255 255 255"		// 216 222 211 255 Schriftfarbe in der Console und einigen anderen Textfeldern
		"BrightBaseText"	"131 77 61 255"			// 131 77 61 255 Schriftfarbe der Buttons sowie markierten Text in Menues/Kontextmenues etc
		"SelectedText"		"0 0 0 255"			// 255 255 255 255 Schriftfarbe fuer markierten Text [mit der Maus markieren]
		"DimBaseText"		"255 255 255 255"		// 160 170 149 255 Schriftfarbe der nicht markierten Buttons bzw Text in Kontextmenues
		"LabelDimText"		"255 255 255 255"		// 160 170 149 255 Schriftfarbe fuer die ganzen Info Texte zB unter Maus Reverse Mouse oder so
		"ControlText"		"255 255 255 255"		// 216 222 211 255 Schriftfarbe fuer die Buttons die man ankreuzen kann wo man ein haeckchen setzen muss
		"BrightControlText"	"255 255 255 255" 		// 196 181 80 255 Schriftfarbe fuer aktive Buttons
		"DisabledText1"		"255 255 255 255"		// 117 128 111 255 Schriftfarbe fuer Buttons die man nicht druecken kann zB im Server Browser Connect oder Quick refresh
		"DisabledText2"		"0 0 0 0"			// 40 46 34 255 Siehe DisabledText1 nur dass das hier auf dem ersten drauf liegt damit es cooler aussieht oder so
		"DimListText"		"255 255 255 255"		// 117 134 102 255 offline friends, unsubscribed games, etc.
	
		// background colors
		"ControlBG"		"7 8 0 180"			// 76 88 68 255 Die Haupthintergrundfarbe der Menues sowie die Farbe der Scrollbalken
		"ControlDarkBG"		"37 37 37 255"			// 90 106 80 255 Hintergrundfarbe der Scrollleiste unter dem Scrollbalken
		"WindowBG"		"131 77 61 180"		// 62 70 55 255 Zweite Hintergrund Farbe zB Console innere Teil und alle andere Texteingabe Menues zB Name in den Optionen
		"SelectionBG"		"146 61 10 255"			// 149 136 49 255 Markierungsfarbe wenn man was mit der Maus markiert
		"SelectionBG2"		"0 0 0 255"			// 40 46 34 255 Markierungsfarbe im Hintergrund bzw inaktive Markierung im Hintergrund zB Wenn man im Serverbrowser auf View Info geht und der Serverbrowser dann im Hintergrund ist der markierte Server bekommt die Farbe
		"ListBG"		"131 77 61 180"		// 62 70 55 255 Dritte Hintergrundfarbe zB Serverbrowser oder Friends oder die Kaestchen die man ankreuzen kann
		
		// titlebar colors
		"TitleText"		"11 11 11 255"			// 255 255 255 255 Titel Text Farbe zB unter Options oben links Options usw
		"TitleDimText"		"153 153 153 255"		// 136 145 128 255 Titel Text im Hintergrund bzw wenn das Fenster inaktiv ist
		"TitleBG"		"0 0 0 0"			// 76 88 68 0 Hintergrundfarbe des Titels oben einfach auf 0 setzen und es hat die haupthintergrundfarbe
		"TitleDimBG"		"0 0 0 0"			// 76 88 68 0 Hintergrundfarbe des Titels wenn Fenster im Hintergrund bzw inaktiv
		
		// slider tick colors
		"SliderTickColor"	"146 61 10 255"			// 127 140 127 255 Farbe der Streifen bei nem Regler (die kleinen Markierungsstriche + Zahlen)
		"SliderTrackColor"	"71 31 5 255"			// 31 31 31 255 Hintergrundfarbe der Balken (Brightness, Gamma, Sensitivity...)
		
		// border colors
		"BorderBright"		"146 61 10 175"			// 136 145 128 255 Umrandung der Fenster und Buttons oben und links
		"BorderDark"		"100 42 7 175"			// 40 46 34 255 Umrandung der Fenster und Buttons unten und rechts
		"BorderSelection"	"0 0 0 255"			// 0 0 0 255 Umrandung der Buttons wo die Maus als letzte war oder so 
	}

	///////////////////// BASE SETTINGS ////////////////////////
	// default settings for all panels
	// controls use these to determine their settings
	BaseSettings
	{
		"FgColor"			"ControlText"
		"BgColor"			"ControlBG"
		"LabelBgColor"			"0 0 0 0"
		"SubPanelBgColor"		"ControlBG"

		"DisabledFgColor1"		"DisabledText1" 
		"DisabledFgColor2"		"DisabledText2"			// set this to the BgColor if you don't want it to draw

		"TitleBarFgColor"		"TitleText"
		"TitleBarDisabledFgColor"	"TitleDimText"
		"TitleBarBgColor"		"TitleBG"
		"TitleBarDisabledBgColor"	"TitleDimBG"

		"TitleBarIcon"			"resource/icon_steam"
		"TitleBarDisabledIcon"		"resource/icon_steam_disabled"

		"TitleButtonFgColor"		"BorderBright"
		"TitleButtonBgColor"		"ControlBG"
		"TitleButtonDisabledFgColor"	"TitleDimText"
		"TitleButtonDisabledBgColor"	"TitleDimBG"

		"TextCursorColor"		"BaseText"		// color of the blinking text cursor in text entries
		"URLTextColor"			"BrightBaseText"	// color that URL's show up in chat window

		Menu
		{
			"FgColor"		"146 61 10 255"
			"BgColor"		"0 0 0 200"
			"ArmedFgColor"		"146 61 10 255"
			"ArmedBgColor"		"146 61 10 255"
			"DividerColor"		"BorderDark"

			"TextInset"		"6"
		}

		MenuButton	  // the little arrow on the side of boxes that triggers drop down menus
		{
			"ButtonArrowColor"	"DimBaseText"		// color of arrows
		   	"ButtonBgColor"		"100 100 100 255"		// bg color of button. same as background color of text edit panes 
			"ArmedArrowColor"	"BrightBaseText"	// color of arrow when mouse is over button
			"ArmedBgColor"		"DimBaseText"		// bg color of button when mouse is over button
		}

		Slider
		{
			"SliderFgColor"		"ControlBG"		// handle with which the slider is grabbed
			"SliderBgColor"		"ControlDarkBG"		// area behind handle
		}

		ScrollBarSlider
		{
			"BgColor"			"ControlBG"		// this isn't really used
			"ScrollBarSliderFgColor"	"ControlBG"		// handle with which the slider is grabbed
			"ScrollBarSliderBgColor"	"ControlDarkBG"		// area behind handle
			"ButtonFgColor"			"DimBaseText"		// color of arrows
		}


		// text edit windows
		"WindowFgColor"				"BaseText"		// off-white
		"WindowBgColor"				"WindowBG"		// redundant. can we get rid of WindowBgColor and just use WindowBG?
		"WindowDisabledFgColor"			"DimBaseText"
		"WindowDisabledBgColor"			"ListBG"		// background of chat conversation
		"SelectionFgColor"			"SelectedText"		// fg color of selected text
		"SelectionBgColor"			"SelectionBG"
		"ListSelectionFgColor"			"SelectedText"
		"ListBgColor"				"ListBG"		// background of server browser control, etc
		"BuddyListBgColor"			"ListBG"		// background of buddy list pane
		
		// App-specific stuff
		"ChatBgColor"				"WindowBG"

		// status selection
		"StatusSelectFgColor"		"BrightBaseText"
		"StatusSelectFgColor2"		"BrightControlText"	// this is the color of the friends status

		// checkboxes
		"CheckButtonBorder1"   		"BorderDark"		// the left checkbutton border
		"CheckButtonBorder2"   		"BorderBright"		// the right checkbutton border
		"CheckButtonCheck"		"BrightControlText"	// color of the check itself
		"CheckBgColor"			"ListBG"

		// buttons (default fg/bg colors are used if these are not set)
//		"ButtonArmedFgColor"
//		"ButtonArmedBgColor"
//		"ButtonDepressedFgColor"	"BrightControlText"
//		"ButtonDepressedBgColor"

		// buddy buttons
		BuddyButton
		{
			"FgColor1"			"ControlText"
			"FgColor2"			"DimListText"
			"ArmedFgColor1"			"146 61 10 255"
			"ArmedFgColor2"			"0 0 0 255"
			"ArmedBgColor"			"SelectionBG"
		}

		Chat
		{
			"TextColor"		"BrightControlText"
			"SelfTextColor"		"BaseText"
			"SeperatorTextColor"	"DimBaseText"
		}

		InGameDesktop
		{
			"MenuColor"		"0 0 0 255"
			"ArmedMenuColor"	"206 153 153 255"
			"DepressedMenuColor" 	"206 153 153 255"
			"WidescreenBarColor" 	"0 0 0 0"
			"MenuItemVisibilityRate" "0"  // time it takes for one menu item to appear
			"MenuItemHeight"	"25"
			"GameMenuInset"		"30"
		}

		"SectionTextColor"		"BrightControlText"	// text color for IN-GAME, ONLINE, OFFLINE sections of buddy list
		"SectionDividerColor"		"BorderDark"		// color of line that runs under section name in buddy list
	}

	//
	//////////////////////// FONTS /////////////////////////////
	//
	// describes all the fonts
	Fonts
	{
		// fonts are used in order that they are listed
		// fonts listed later in the order will only be used if they fulfill a range not already filled
		// if a font fails to load then the subsequent fonts will replace
		"Default"
		{
			"1"
			{
				"name"		"04b08"
				"tall"		"6"
				"weight"	"0"
			}
		}
		"DefaultUnderline"
		{
			"1"
			{
				"name"		"04b08"
				"tall"		"6"
				"weight"	"0"
				"underline" "1"
			}
		}
		"DefaultSmall"
		{
			"1"
			{
				"name"		"04b08"
				"tall"		"6"
				"weight"	"0"
			}
		}
		"DefaultVerySmall"
		{
			"1"
			{
				"name"		"04b08"
				"tall"		"6"
				"weight"	"0"
			}
		}
		"MenuLarge"
		{
			"1"
			{
				"name"		"pearl jam yield"
				"tall"		"11"
				"weight"	"50"
				"antialias" "1"
			}
			"2"
			{
				"name"		"Journal"
				"tall"		"25"
				"weight"	"0"
				"antialias" "1"
			}
		}

		// this is the symbol font
		"Marlett"
		{
			"1"
			{
				"name"		"Marlett"
				"tall"		"14"
				"weight"	"0"
				"symbol"	"1"
			}
		}
		
		"EngineFont"
		{
			"1"
			{
				"name"		"04b08"
				"tall"		"6"
				"weight"	"0"
				"yres"	"480 599"
				"dropshadow"	"1"
			}
			"2"
			{
				"name"		"04b08"
				"tall"		"6"
				"weight"	"0"
				"yres"		"600 767"
				"dropshadow"	"0"
			}
			"3"
			{
				"name"		"04b08"
				"tall"		"6"
				"weight"	"0"
				"yres"	"768 1023"
				"dropshadow"	"1"
			}
			"4"
			{
				"name"		"04b08"
				"tall"		"6"
				"weight"	"0"
				"yres"	"1024 1199"
				"dropshadow"	"1"
			}
			"5"
			{
				"name"		"Verdana Bold"
				"tall"		"24"
				"weight"	"0"
				"yres"	"1200 6000"
				"dropshadow"	"1"
			}
			"6"
			{
				"name"		"Verdana"
				"tall"		"12"
				"weight"		"600"
				"dropshadow"	"1"
			}
			"7"
			{
				"name"		"Arial"
				"tall"		"11"
				"weight"		"800"
				"dropshadow"	"1"
			}
		}	
		
		"CreditsFont"
		{
			"1"
			{
				"name"		"Trebuchet MS"
				"tall"		"18"
				"weight"	"600"
				"antialias"	"1"
			}
		}

		"Legacy_CreditsFont" // Added to accomodate 3rd party server plugins, etc. This version should not scale.
		{
			"1"
			{
				"name"		"Trebuchet MS"
				"tall"		"20"
				"weight"	"700"
				"antialias"	"1"
				"yres"	"1 10000"
			}
		}
	}

	//
	//////////////////// BORDERS //////////////////////////////
	//
	// describes all the border types
	Borders
	{
		// references to other borders
		BaseBorder		"InsetBorder"
		ComboBoxBorder		"InsetBorder"
		BrowserBorder		"InsetBorder"
		ButtonBorder		"RaisedBorder"
		FrameBorder		"RaisedBorder"
		TabBorder		"RaisedBorder"
		MenuBorder		"RaisedBorder"
		
		// standard borders
		InsetBorder
		{
			"inset" "0 0 1 1"
			Left
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "BorderBright"
					"offset" "1 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "BorderBright"
					"offset" "0 0"
				}
			}
		}

		RaisedBorder
		{
			"inset" "0 0 1 1"
			Left
			{
				"1"
				{
					"color" "BorderBright"
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "0 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "BorderBright"
					"offset" "0 1"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "0 0"
				}
			}
		}

		// special border types
		TitleButtonBorder
		{
			"inset" "0 0 1 1"
			Left
			{
				"1"
				{
					"color" "BorderBright"
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "1 0"
				}
			}

			Top
			{
				"4"
				{
					"color" "BorderBright"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "0 0"
				}
			}
		}

		TitleButtonDisabledBorder
		{
			"inset" "0 0 1 1"
			Left
			{
				"1"
				{
					"color" "BgColor"
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "BgColor"
					"offset" "1 0"
				}
			}
			Top
			{
				"1"
				{
					"color" "BgColor"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "BgColor"
					"offset" "0 0"
				}
			}
		}

		TitleButtonDepressedBorder
		{
			"inset" "1 1 1 1"
			Left
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "BorderBright"
					"offset" "1 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "BorderBright"
					"offset" "0 0"
				}
			}
		}

		ScrollBarButtonBorder
		{
			"inset" "1 0 0 0"
			Left
			{
				"1"
				{
					"color" "BorderBright"
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "1 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "BorderBright"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "0 0"
				}
			}
		}

		ScrollBarButtonDepressedBorder
		{
			"inset" "2 2 0 0"
			Left
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "BorderBright"
					"offset" "1 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "BorderBright"
					"offset" "0 0"
				}
			}
		}
		
		TabActiveBorder
		{
			"inset" "0 0 1 0"
			Left
			{
				"1"
				{
					"color" "BorderBright"
					"offset" "0 0"
				}
			}

			Right
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "1 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "BorderBright"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "ControlBG"
					"offset" "6 2"
				}
			}
		}


		ToolTipBorder
		{
			"inset" "0 0 1 0"
			Left
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "0 0"
				}
			}

			Right
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "1 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "0 0"
				}
			}
		}

		// this is the border used for default buttons (the button that gets pressed when you hit enter)
		ButtonKeyFocusBorder
		{
			"inset" "0 0 1 1"
			Left
			{
				"1"
				{
					"color" "BorderSelection"
					"offset" "0 0"
				}
				"2"
				{
					"color" "BorderBright"
					"offset" "0 1"
				}
			}
			Top
			{
				"1"
				{
					"color" "BorderSelection"
					"offset" "0 0"
				}
				"2"
				{
					"color" "BorderBright"
					"offset" "1 0"
				}
			}
			Right
			{
				"1"
				{
					"color" "BorderSelection"
					"offset" "0 0"
				}
				"2"
				{
					"color" "BorderDark"
					"offset" "1 0"
				}
			}
			Bottom
			{
				"1"
				{
					"color" "BorderSelection"
					"offset" "0 0"
				}
				"2"
				{
					"color" "BorderDark"
					"offset" "1 1"
				}
			}
		}

		ButtonDepressedBorder
		{
			"inset" "2 1 1 1"
			Left
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "BorderBright"
					"offset" "1 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "BorderBright"
					"offset" "0 0"
				}
			}
		}
	}
}