/*

Changelog:

- v1.0
* First public release.

*/

#include <amxmodx>
#include <amxmisc>
#include <fun>
#include <cstrike>
#include <hamsandwich>

#define PLUGIN "Reset Player"
#define VERSION "1.0"
#define AUTHOR "Kristaps"

new bool:g_has_reseted_player[33]
new reset_player_money
new reset_player_items
new reset_player_hp
new reset_player_ap
new reset_player_frags
new reset_player_deaths
new reset_player_again

public plugin_init() {
	register_plugin(PLUGIN, VERSION, AUTHOR)
	
	register_dictionary("reset_player.txt")
	
	register_concmd("amx_reset_player", "reset_player", ADMIN_SLAY, "<target>")
	
	RegisterHam(Ham_Spawn, "player", "spawned", 1)
	
	register_cvar(PLUGIN,VERSION,FCVAR_SERVER)
	
	reset_player_money = register_cvar("reset_player_money","1")
	reset_player_items = register_cvar("reset_player_items","1")
	reset_player_hp = register_cvar("reset_player_hp","1")
	reset_player_ap = register_cvar("reset_player_ap","1")
	reset_player_frags = register_cvar("reset_player_frags","0")
	reset_player_deaths = register_cvar("reset_player_deaths","0")
	reset_player_again = register_cvar("reset_player_again","0")
}

public client_disconnect(id) {
	g_has_reseted_player[id] = false
}

public spawned(id) {
	if (g_has_reseted_player[id]) {
		g_has_reseted_player[id] = false
	}
}

public reset_player(id,level,cid) {
	if (!cmd_access(id,level,cid,2))
		return PLUGIN_HANDLED
	
	new arg[32]
	read_argv(1,arg,31)
	
	new player = cmd_target(id,arg,7)
	if (!player) 
		return PLUGIN_HANDLED
	
	new name[32]
	new admin[32]
	get_user_name(player,name,31)
	get_user_name(id,admin,31)
	
	if(!is_user_alive(player))
		return PLUGIN_HANDLED
	
	if(get_pcvar_num(reset_player_again) == 1) {
		g_has_reseted_player[player] = false
	}
	if(g_has_reseted_player[player]) {
		client_print(id, print_console, "%L", id, "ADMIN_ALREADY_RESETED")
	}
	else {
		client_print(0, print_chat, "%L", 0, "ADMIN_RESETED_PLAYER", admin, name)
		if(get_pcvar_num(reset_player_again) == 0) {
			g_has_reseted_player[player] = true
		}
		if(get_pcvar_num(reset_player_money) == 1) {
			cs_set_user_money(player, get_cvar_num("mp_startmoney"))
		}
		if(get_pcvar_num(reset_player_items) == 1) {
			strip_user_weapons(player)
			give_item(player, "weapon_knife")
			new CsTeams:team = cs_get_user_team(player)
			if (team == CS_TEAM_T) {
				give_item(player, "weapon_glock18")
				cs_set_user_bpammo(player, CSW_GLOCK18, 24)
			}
			else if(team == CS_TEAM_CT) {
				give_item(player, "weapon_usp")
				cs_set_user_bpammo(player, CSW_USP, 24)
			}
		}
		if(get_pcvar_num(reset_player_hp) == 1) {
			set_user_health(player, 100)
		}
		if(get_pcvar_num(reset_player_ap) == 1) {
			cs_set_user_armor(player, 0, CS_ARMOR_VESTHELM)
		}
		if(get_pcvar_num(reset_player_frags) == 1) {
			set_user_frags(player, 0)
		}
		if(get_pcvar_num(reset_player_deaths) == 1) {
			cs_set_user_deaths(id, 0)
		}
	}
	return PLUGIN_HANDLED
}