#include <amxmodx>

#define PLUGIN_NAME	"Count Down En"
#define PLUGIN_VERSION	"1.3"
#define PLUGIN_AUTHOR	"K.K.Lv"

new const filename[] = "cd_time.ini";

new g_config[64];

new Array:g_message;
new Array:g_targettime;
new Array:g_colors;
new Array:g_effect;

new g_num;

new g_current;

new cvar_time_interval;

public plugin_init()
{
	register_plugin(PLUGIN_NAME, PLUGIN_VERSION, PLUGIN_AUTHOR);
	
	g_message = ArrayCreate(256);
	g_colors = ArrayCreate(3);
	g_targettime = ArrayCreate(10);
	g_effect = ArrayCreate(1, 1);
	
	cvar_time_interval = register_cvar("time_interval", "30");
	
	register_srvcmd("amx_countdown", "start_count_down");
	
	get_localinfo("amxx_configsdir",g_config,63);
	format(g_config,63,"%s/%s",g_config, filename);
	if (!file_exists(g_config)) {
		write_file(g_config, ";This is use to store time for coundown plugin^n;e.g:^"New Year^" ^"20110101^" ^"125090125^" ^"2^" ^"There is(are) %daynum% day(s) to %event%.^"");
	}
	LoadFile();
}

public start_count_down() {
	
	if (g_current >= g_num)
		g_current = 0;
	if (g_num == 0)	return;
	
	new szmessage[256], sztargettime[10];
	new ieffect;
	new color[3];
	
	ArrayGetString(g_message, g_current, szmessage, charsmax(szmessage));
	ArrayGetString(g_targettime, g_current, sztargettime, charsmax(sztargettime));
	ArrayGetArray(g_colors, g_current, color);
	ieffect = ArrayGetCell(g_effect, g_current);
	
	new sztimes[7][10];
	new const time_replace[][] = {"%year%", "%month%", "%day%", "%hour%", "%minute%", "%second%", "%weekname%"};	
	new const mtime[][] = {"%Y", "%m", "%d", "%H", "%M", "%S", "%A"}
	
	for (new i = 0; i < 7; i++) {
		get_time(mtime[i], sztimes[i], charsmax(sztimes[]));
		replace_all(szmessage, charsmax(szmessage), time_replace[i], sztimes[i]);
	}
	
	new szdatenow[10]
	format(szdatenow, charsmax(szdatenow), "%s%s%s", sztimes[0], sztimes[1], sztimes[2]);
	
	new szdaynum[5];
	new target_time = parse_time(sztargettime, "%Y%m%d");
	new days = (target_time - get_systime())/86400;
	num_to_str(days, szdaynum, charsmax(szdaynum));
	replace_all(szmessage, charsmax(szmessage), "%daynum%", szdaynum);
	
	if (days == 0 || str_to_num(sztargettime) < str_to_num(szdatenow)) {
		++g_current;
		start_count_down();
		return;
	}
	
	set_hudmessage(color[0], color[1], color[2], -1.0, 0.05, ieffect, 0.5, 12.0, 0.1, 2.0, -1)
	
	show_hudmessage(0, "%s", szmessage);
	//client_print(0, print_chat, "There is(are) %d day(s).", g_days);
	++g_current;
	
	set_task(get_pcvar_float(cvar_time_interval), "start_count_down", 1987);
}

LoadFile()
{
	ArrayClear(g_colors);
	ArrayClear(g_effect);
	ArrayClear(g_message);
	
	g_current = 0;
	g_num = 0;
	
	new szevent[64], sztime[10], szmessage[256], szcolors[12], szeffect[2], szmap[32], color[3];
	new ieffect;
	new text[1024];
	
	get_mapname(szmap, charsmax(szmap));
	
	new fp = fopen(g_config, "rt");
	if (!fp) 
		return 0;
	while (!feof(fp)){
		fgets(fp, text, charsmax(text));
		if (text[0] == ';' || text[0] == '/' && text[1] == '/' || text[0] == ' ')
			continue;
		if (parse(text, szevent, charsmax(szevent), sztime, charsmax(sztime), szcolors, charsmax(szcolors), szeffect, charsmax(szeffect), szmessage, charsmax(szmessage)) < 1)	continue;
		
		ieffect = str_to_num(szeffect);
		color[2] = str_to_num(szcolors[6]);
		szcolors[6] = 0
		color[1] = str_to_num(szcolors[3]);
		szcolors[3] = 0;
		color[0] = str_to_num(szcolors[0]);
		
		replace_all(szmessage, charsmax(szmessage), "%event%", szevent);
		replace_all(szmessage, charsmax(szmessage), "%map%", szmap);
		replace_all(szmessage, charsmax(szmessage), "\n", "^n");
		
		ArrayPushString(g_message, szmessage);
		ArrayPushString(g_targettime, sztime);
		ArrayPushCell(g_effect, ieffect)
		ArrayPushArray(g_colors, color);
		g_num++;
	}
	//server_print("There is(are) %d line(s)", g_num);
	server_cmd("amx_countdown");
	return 1;
}

/*
*	  GM-Serv.Ru
*	 , , , , , ...
*	: , ,  
*/