#include <amxmodx>
#include <hamsandwich>
#include <cstrike>
#include <fun>
#include <fakemeta>

new const PLUGIN[] = "Revive teammate"
new const VERSION[] = "2.0.1"

new const PREFIX[] = "[RevTM]"

enum {Primary, Secondary, He, Flash1, Flash2, Smoke}

// These weapons will be given to a revived player if rev_give_weaps cvar is enabled
// Leave an empty string ("") to disable the weapon
new const WEAPONS_CT[][] =
{	
	"weapon_m4a1",			// primary
	"weapon_usp",			// secondary
	"weapon_hegrenade",		// he
	"weapon_flashbang",		// flash1
	"weapon_flashbang",		// flash2
	"weapon_smokegrenade"		// smoke
}

new const WEAPONS_TERR[][] =
{
	"weapon_ak47",			// primary
	"weapon_glock18",		// secondary
	"weapon_hegrenade",		// he
	"weapon_flashbang",		// flash1
	"weapon_flashbang",		// flash2
	"weapon_smokegrenade"		// smoke
}

new cvarTeam, cvarHudMsgOn, cvarRevPriceCt, cvarRevPriceTerr, cvarGiveWeaps,

g_HudSyncMsg, g_MsgSayText

public plugin_init()
{
	register_plugin(PLUGIN, VERSION, "beast")
	
	register_dictionary("revive_teammate.txt")
	
	register_clcmd("say /revtm", "ReviveMenu")
	register_clcmd("say_team /revtm", "ReviveMenu")
	
	/* rev_team:
	   0 - disables the plugin
	   1 - enables it only for CT's
	   2 - enables it only for Terr's
	   3 - enables it for both teams
	*/
	cvarTeam = register_cvar("rev_team", "3")
	
	/* rev_hudmsg:
	   0 - disables the revival announcement hud message
	   1 - enables it
	*/
	cvarHudMsgOn = register_cvar("rev_hudmsg", "1")
	
	/* rev_price_ct:
	   Price for CT's to revive a teammate
	*/
	cvarRevPriceCt = register_cvar("rev_price_ct", "10000")
	
	/* rev_price_terr:
	   Price for Terr's to revive a teammate
	*/
	cvarRevPriceTerr = register_cvar("rev_price_terr", "10000")
	
	/* rev_give_weaps:
	   0 - does not give weapons and armor to revived players
	   1 - gives it only to revived CT's
	   2 - gives it only to revived Terr's
	   3 - gives it to both teams
	*/
	cvarGiveWeaps = register_cvar("rev_give_weaps", "3")
	
	register_cvar(PLUGIN, VERSION, FCVAR_SPONLY | FCVAR_SERVER)
	
	g_HudSyncMsg = CreateHudSyncObj()
	
	g_MsgSayText = get_user_msgid("SayText")
}

public ReviveMenu(id)
{
	if(!is_user_alive(id))
	{
		client_printcolor(id, "/g%s/y %L", PREFIX, id, "DEAD_DENYED")
		return PLUGIN_HANDLED_MAIN
	}
	
	new CsTeams:teamBuyer = cs_get_user_team(id), revPrice
	
	switch(get_pcvar_num(cvarTeam))
	{	
		case 0: return PLUGIN_HANDLED_MAIN
		case 1:
		{
			if(teamBuyer == CS_TEAM_CT)
				revPrice = get_pcvar_num(cvarRevPriceCt)
			
			else
				return PLUGIN_HANDLED_MAIN
		}
		case 2: 
		{
			
			if(teamBuyer == CS_TEAM_T)
				revPrice = get_pcvar_num(cvarRevPriceTerr)
			
			else
				return PLUGIN_HANDLED_MAIN
		}
		default:
		{
			if(teamBuyer == CS_TEAM_CT)
				revPrice = get_pcvar_num(cvarRevPriceCt)
			
			else
				revPrice = get_pcvar_num(cvarRevPriceTerr)
		}
	}
	
	if(cs_get_user_money(id) < revPrice)
	{
		client_printcolor(id, "/g%s/y %L", PREFIX, id, "MONEY_SHORT", revPrice)
		return PLUGIN_HANDLED_MAIN
	}
	
	new menuName[32], name[32], info[3], players[32], num, i, tempId, deadTeammates, CsTeams:teamTempId
	
	formatex(menuName, charsmax(menuName), "%L", id, "MENU_NAME")
	
	new menu = menu_create(menuName, "MenuHandler")

	get_players(players, num, "bh")

	for(i = 0; i < num; i++)
	{
		tempId = players[i]
		
		teamTempId = cs_get_user_team(tempId)
		
		if(teamBuyer == teamTempId)
		{	
			deadTeammates++
			
			get_user_name(tempId, name, charsmax(name))
			
			num_to_str(tempId, info, charsmax(info))

			menu_additem(menu, name, info)
		}
	}
	
	if(!deadTeammates)
	{
		client_printcolor(id, "/g%s/y %L", PREFIX, id, "ALL_TMMS_ALIVE")
		return PLUGIN_HANDLED_MAIN
	}
	
	menu_display(id, menu)
	
	return PLUGIN_CONTINUE
}

public MenuHandler(id, menu, item)
{
	if(item == MENU_EXIT)
	{
		menu_destroy(menu)
		return PLUGIN_HANDLED
	}
		
	if(!is_user_alive(id))
	{
		client_printcolor(id, "/g%s/y %L", PREFIX, id, "DEAD_DENYED")
		
		menu_destroy(menu)
		return PLUGIN_HANDLED
	}

	new access, info[3], name[32], callback
	
	menu_item_getinfo(menu, item, access, info, charsmax(info), name, charsmax(name), callback)
	
	menu_destroy(menu)	

	new target = str_to_num(info)
	
	if(is_user_alive(target))
		return PLUGIN_HANDLED
		
	new CsTeams:teamBuyer = cs_get_user_team(id), CsTeams:teamTarget = cs_get_user_team(target)
	
	if(teamBuyer != teamTarget)
		return PLUGIN_HANDLED
	
	new money = cs_get_user_money(id), revPrice
	
	if(teamBuyer == CS_TEAM_CT)
		revPrice = get_pcvar_num(cvarRevPriceCt)
	
	else
		revPrice = get_pcvar_num(cvarRevPriceTerr)
	
	if(money < revPrice)
	{
		client_printcolor(id, "/g%s/y %L", PREFIX, id, "MONEY_SHORT", revPrice)
		return PLUGIN_HANDLED
	}
		
	new nameBuyer[32], nameTarget[32]
		
	get_user_name(id, nameBuyer, charsmax(nameBuyer))
	get_user_name(target, nameTarget, charsmax(nameTarget))		
		
	ExecuteHamB(Ham_CS_RoundRespawn, target)
		
	switch(get_pcvar_num(cvarGiveWeaps))
	{	
		case 1: if(teamTarget == CS_TEAM_CT) GiveWeapons(target, WEAPONS_CT[Primary], WEAPONS_CT[Secondary], WEAPONS_CT[He], WEAPONS_CT[Flash1], WEAPONS_CT[Flash2], WEAPONS_CT[Smoke])
		case 2: if(teamTarget == CS_TEAM_T) GiveWeapons(target, WEAPONS_TERR[Primary], WEAPONS_TERR[Secondary], WEAPONS_TERR[He], WEAPONS_TERR[Flash1], WEAPONS_TERR[Flash2], WEAPONS_TERR[Smoke])
		case 3:
		{
			if(teamTarget == CS_TEAM_CT)
				GiveWeapons(target, WEAPONS_CT[Primary], WEAPONS_CT[Secondary], WEAPONS_CT[He], WEAPONS_CT[Flash1], WEAPONS_CT[Flash2], WEAPONS_CT[Smoke])
		
			else
				GiveWeapons(target, WEAPONS_TERR[Primary], WEAPONS_TERR[Secondary], WEAPONS_TERR[He], WEAPONS_TERR[Flash1], WEAPONS_TERR[Flash2], WEAPONS_TERR[Smoke])
		}
	}
	
	cs_set_user_money(id, money - revPrice, 1)
		
	if(get_pcvar_num(cvarHudMsgOn))
	{
		set_hudmessage(255, 85, 0, 0.01, 0.26, 0, 6.0, 6.0, 0.1, 2.0, -1)
		ShowSyncHudMsg(0, g_HudSyncMsg, "%L", LANG_PLAYER, "HAS_REVIVED", nameBuyer, nameTarget)
	}
	
	return PLUGIN_HANDLED
}

GiveWeapons(id, primWeapon[], secWeapon[], he[], flash1[], flash2[], smoke[])
{
	StripPlayerWeapons(id)
	
	give_item(id, "weapon_knife")
	give_item(id, "item_assaultsuit")
	
	if(primWeapon[0] == 'w')
	{
		give_item(id, primWeapon)
		
		new primWeaponId = get_weaponid(primWeapon)
		
		cs_set_user_bpammo(id, primWeaponId, GetWeaponMaxBpammo(primWeaponId))
	}
	
	if(secWeapon[0] == 'w')
	{
		give_item(id, secWeapon)
		
		new secWeaponId = get_weaponid(secWeapon)
		
		cs_set_user_bpammo(id, secWeaponId, GetWeaponMaxBpammo(secWeaponId))
	}
	
	if(he[0] == 'w')
		give_item(id, he)
	
	if(flash1[0] == 'w')
		give_item(id, flash1)

	if(flash2[0] == 'w')
		give_item(id, flash2)

	if(smoke[0] == 'w')
		give_item(id, smoke)
}

stock StripPlayerWeapons(id)
{
	strip_user_weapons(id)
	set_pdata_int(id, 116, 0) // bugfix: http://forums.alliedmods.net/showthread.php?t=90106
}
	
stock GetWeaponMaxBpammo(weapon)
{
	new bp
	
	switch(weapon)
	{
		case CSW_SCOUT, CSW_AUG, CSW_SG550, CSW_GALIL, CSW_FAMAS, CSW_G3SG1, CSW_SG552, CSW_AK47: bp = 90
		case CSW_MAC10, CSW_FIVESEVEN, CSW_UMP45, CSW_USP, CSW_P90: bp = 100
		case CSW_ELITE, CSW_GLOCK18, CSW_MP5NAVY, CSW_TMP: bp = 120
		case CSW_XM1014, CSW_M3: bp = 32
		case CSW_DEAGLE: bp = 35
		case CSW_M249: bp = 200
		case CSW_P228: bp = 52
		case CSW_AWP: bp = 30
	}
	
	return bp
}

client_printcolor(const id, const input[], any:...)
{
	static msg[191]
	
	vformat(msg, charsmax(msg), input, 3)
	
	replace_all(msg, charsmax(msg), "/g", "^4")
	replace_all(msg, charsmax(msg), "/y", "^1")

	if(is_user_connected(id))
	{
		message_begin(MSG_ONE_UNRELIABLE, g_MsgSayText, _, id)
		write_byte(id)
		write_string(msg)
		message_end()
	}
}