/* Plugin generated by AMXX-Studio */

#include <amxmodx>
#include <amxmisc>
#include <engine>
#include <fakemeta>
#include <fakemeta_util>
#include <hamsandwich>
#include <dhudmessage>
#include <WPMGPrintChatColor>

#define PLUGIN "Checkpoints"
#define VERSION "0.6"
#define AUTHOR "Psycrow"

#define GreenCP 		"models/n21_deathrun/checkpoints/checkpoint-green.mdl"
#define BlueCP 			"models/n21_deathrun/checkpoints/checkpoint-blue.mdl"
#define OrangeCP 		"models/n21_deathrun/checkpoints/checkpoint-orange.mdl"
#define PurpleCP 		"models/n21_deathrun/checkpoints/checkpoint-purple.mdl"
#define YellowCP 		"models/n21_deathrun/checkpoints/checkpoint-yellow.mdl"
#define FinishCP 		"models/n21_deathrun/checkpoints/checkpoint-finish.mdl"

#define DHUD_POSITION 0, 255, 0, -1.0, 0.8, 2, 1.05, 1.05, 0.05, 3.0
#define MAX_MONEY 16000
#define MAX_CHECKPOINTS_LOAD 10

#if cellbits == 32
	#define OFFSET_CSMONEY 115
#else
	#define OFFSET_CSMONEY 140
#endif

new
g_TotalCheckpoints, 					//-    
g_Checkpoint_id[MAX_CHECKPOINTS_LOAD],			//id  
bool: g_Checkpoint_complete[MAX_CHECKPOINTS_LOAD][33], 	//  (1) (2)
Float: g_orig_x[MAX_CHECKPOINTS_LOAD],			// x
Float: g_orig_y[MAX_CHECKPOINTS_LOAD],			// y
Float: g_orig_z[MAX_CHECKPOINTS_LOAD],			// z
g_msgMoney,
bool: g_save_cpl,					//   
g_Finished[33],						//   .
g_fin_pos						//, 

public plugin_natives()	
	register_native("n21_teleport_cp", "teleport", 1)

public plugin_precache()
{
	precache_model(GreenCP)
	precache_model(BlueCP)
	precache_model(OrangeCP)
	precache_model(PurpleCP)
	precache_model(YellowCP)
	precache_model(FinishCP)
}

public plugin_init()
{
	register_plugin(PLUGIN, VERSION, AUTHOR)
	
	register_cvar("cv_checkpoint_money","1") //   ?
	register_cvar("cv_checkpoint_teleport","1") //    ?
	register_cvar("cv_checkpoint_money_give","300") //       
	register_cvar("cv_checkpoint_money_koef","1") //         ?
	register_cvar("cv_checkpoint_money_last_first","6000") //          
	register_cvar("cv_checkpoint_money_last_second","4000") //   
	register_cvar("cv_checkpoint_money_last_third","3500") //   
	
	register_clcmd( "say /checkpoint", "Checkpoint_menu" )
	register_clcmd( "say_team /checkpoint", "Checkpoint_menu" )
	RegisterHam(Ham_Spawn, "player", "hook_spawn_post", 1)
	register_forward(FM_Touch,"fwdTouch")
	register_logevent("Startround", 2, "1=Round_Start")
	register_event("SendAudio", "EndRound", "a", "2&%!MRAD_rounddraw") //      
	register_event("SendAudio", "EndRound", "a", "2&%!MRAD_terwin") //      
	register_event("SendAudio", "EndRound", "a", "2&%!MRAD_ctwin") //      
	register_logevent("EndRound", 2, "0=World triggered","1=Round_End")
	
	get_maps_cfg()
	set_checkpoints()
	
	g_msgMoney = get_user_msgid("Money")
}

public get_maps_cfg()
{
	new map[32]
	get_mapname(map, charsmax(map))
	formatex(map,charsmax(map),"%s.ini",map)
	
	new cfgDir[64], i_Dir, i_File[128]
	get_configsdir(cfgDir,31)
	formatex(cfgDir,63,"%s/next21_checkpoints",cfgDir)
	
	i_Dir = open_dir(cfgDir, i_File, charsmax(i_File))
	
	if (i_Dir)
	{
		while (next_file(i_Dir, i_File, charsmax(i_File)))
		{
			if (i_File[0] == '.')
				continue
				
			if(equal(map, i_File))
			{
				format(i_File,128,"%s/%s",cfgDir, i_File)
				get_checkpoints(i_File)
			}
		}
	}
}

public set_maps_cfg()
{
	new map[32]
	get_mapname(map, charsmax(map))
	formatex(map,charsmax(map),"%s.ini",map)
	
	new cfgDir[64], i_File[128]
	get_configsdir(cfgDir,31)
	formatex(cfgDir,63,"%s/next21_checkpoints",cfgDir)
	
	format(i_File,128,"%s/%s",cfgDir, map)
	
	delete_file(i_File)
	if(g_TotalCheckpoints != 0)
		for(new i=0; i<g_TotalCheckpoints; i++)
		{
			new text[128], Float:fOrigin[3]
			pev(g_Checkpoint_id[i],pev_origin,fOrigin)
			format(text,128,"^"%f^" ^"%f^" ^"%f^"",fOrigin[0], fOrigin[1], fOrigin[2])
			write_file(i_File, text, i) 
		}
}

public get_checkpoints(i_File[128])
{	
	new
	i_orig_x[32],
	i_orig_y[32],
	i_orig_z[32],
	sfLineData[512],
	file = fopen(i_File,"rt")
	
	while(file && !feof(file))
	{
		fgets(file, sfLineData, charsmax(sfLineData))
			
		if (containi(sfLineData,";") > -1)
			continue
			
		parse(sfLineData, i_orig_x, charsmax(i_orig_x), i_orig_y, charsmax(i_orig_y), i_orig_z, charsmax(i_orig_z))
					
		g_orig_x[g_TotalCheckpoints] = str_to_float(i_orig_x)
		g_orig_y[g_TotalCheckpoints] = str_to_float(i_orig_y)
		g_orig_z[g_TotalCheckpoints] = str_to_float(i_orig_z)
			
		g_TotalCheckpoints++
		
		if(get_count_lines(i_File) == g_TotalCheckpoints) //     
			break
		
		if(g_TotalCheckpoints >= MAX_CHECKPOINTS_LOAD)
		{
			server_print("[%s] Reached checkpoints limit", PLUGIN)
			break
		}
	}
	
	if(file)
		fclose(file)
	
	if(g_TotalCheckpoints == 1)
		server_print("[%s] Loaded one Checkpoint", PLUGIN)
	else
		server_print("[%s] Loaded %d Checkpoints", PLUGIN, g_TotalCheckpoints)
}

public set_checkpoints()
{
	for(new i=0; i<g_TotalCheckpoints; i++)
	{
		new Ent = create_entity("info_target")
		if(is_valid_ent(Ent))
		{	
			g_Checkpoint_id[i] = Ent
			
			if(i == g_TotalCheckpoints-1)
				entity_set_model(Ent, FinishCP)
			else
			{
				new color = random_num(0,4)
				switch(color)
				{
					case 0: entity_set_model(Ent, GreenCP)
					case 1: entity_set_model(Ent, BlueCP)
					case 2: entity_set_model(Ent, OrangeCP)
					case 3: entity_set_model(Ent, PurpleCP)
					case 4: entity_set_model(Ent, YellowCP)
				}
			}
				
			new Float:fOrigin[3]
			fOrigin[0] = g_orig_x[i]
			fOrigin[1] = g_orig_y[i]
			fOrigin[2] = g_orig_z[i]
			entity_set_origin(Ent, fOrigin)
			set_pev(Ent, pev_sequence, 0)
			set_pev(Ent, pev_framerate, 1.0)
			entity_set_size(Ent,Float:{-45.0, -45.0, -45.0}, Float:{45.0, 45.0, 45.0})
			entity_set_int(Ent,EV_INT_solid,SOLID_TRIGGER)
			set_pev(Ent,pev_movetype, MOVETYPE_FLY)
			set_pev(Ent, pev_effects, 8)
		}
	}
}

public Startround()
{
	for(new i=0; i<g_TotalCheckpoints; i++)
	{
		entity_set_int(g_Checkpoint_id[i],EV_INT_solid,SOLID_TRIGGER)
		for(new j=0; j<32; j++)
			g_Checkpoint_complete[i][j] = false
	}
	g_fin_pos = 0
	
	for(new i=0; i<33; i++)
		g_Finished[i] = 0
}

public EndRound()
{
	for(new i=0; i<g_TotalCheckpoints; i++)
	{
		entity_set_int(g_Checkpoint_id[i],EV_INT_solid,SOLID_NOT)
		for(new j=0; j<32; j++)
			g_Checkpoint_complete[i][j] = false
	}
			
	g_fin_pos = 0
	
	//    ,  g_Finished[id]  
	
	for(new i=0; i<33; i++)
		g_Finished[i] = 0
}

public hook_spawn_post(id)
	if(get_cvar_num("cv_checkpoint_teleport"))
		teleport(id)

public teleport(id)
{
	for(new i=g_TotalCheckpoints-1; i>=0; i--)
	{
		if(g_Checkpoint_complete[i][id])
		{
			new Float:origin[3]
			entity_get_vector(g_Checkpoint_id[i],EV_VEC_origin,origin)
			set_pev(id, pev_origin, origin)
			break
		}
	}
}

public fwdTouch(ent, id)
{
	if(!is_user_alive(id) || !is_user_connected(id))
		return
	
	if(!is_valid_ent(ent))
		return
 
	for(new i=0; i<g_TotalCheckpoints; i++)
	{
		if(ent == g_Checkpoint_id[i] && !g_Checkpoint_complete[i][id])	
		{		
			g_Checkpoint_complete[i][id] = true
			
			set_dhudmessage(DHUD_POSITION)
			new reward
			
			if(i == g_TotalCheckpoints-1)
			{
				g_fin_pos++
				show_dhudmessage(id, "Вы прошли через последний чекпоинт и финишировали на^n %d месте", g_fin_pos)
				new pl_name[32] 
				get_user_name(id, pl_name, 31) 	
				PrintChatColor(0, PRINT_COLOR_PLAYERTEAM, "!g[%s] !tИгрок !g%s !tпришел к финишу на !g%d !tместе", PLUGIN, pl_name, g_fin_pos) 
				
				if(g_fin_pos == 1)
					reward = get_cvar_num("cv_checkpoint_money_last_first")
				else if(g_fin_pos == 2)
					reward = get_cvar_num("cv_checkpoint_money_last_second")
				else if(g_fin_pos == 3)
					reward = get_cvar_num("cv_checkpoint_money_last_third")
				else
				{
					reward = get_cvar_num("cv_checkpoint_money_give")
					if(get_cvar_num("cv_checkpoint_money_koef"))
						reward = reward * (i+1)
				}
				
				g_Finished[id] = g_fin_pos
			}
			else
			{
				reward = get_cvar_num("cv_checkpoint_money_give")
				if(get_cvar_num("cv_checkpoint_money_koef"))
					reward = reward * (i+1)
				show_dhudmessage(id, "Вы прошли через чекпоинт %d",i+1)
			}
			if(get_cvar_num("cv_checkpoint_money"))
			{
				new curr_money = get_pdata_int(id, OFFSET_CSMONEY)
	
				if(curr_money+reward > MAX_MONEY)
					reward = MAX_MONEY-curr_money
			
				set_pdata_int(id, OFFSET_CSMONEY, curr_money+reward)
			
				message_begin(MSG_ONE, g_msgMoney, _, id)
				write_long(curr_money+reward)
				write_byte(1)
				message_end()
			
				PrintChatColor(id, PRINT_COLOR_PLAYERTEAM, "!g[%s] !tВы получаете !g%d$", PLUGIN, reward) 
			}
		}
	}
}

public Checkpoint_menu(id)
{
	if(!(get_user_flags(id) & ADMIN_BAN))
	{
		PrintChatColor(id, PRINT_COLOR_PLAYERTEAM, "!g[%s] !tУ вас нет прав на эту функцию", PLUGIN) 
		return PLUGIN_HANDLED
	}	
	
	new menu_name[90]
	format(menu_name, 90, "\rРасстановка чекпоинтов^n\dТекущий чекпоинт: %d/%d", g_TotalCheckpoints+1, MAX_CHECKPOINTS_LOAD+1)

	new i_menu = menu_create(menu_name, "menu_handler")
	
	if(g_TotalCheckpoints == MAX_CHECKPOINTS_LOAD)
		menu_additem(i_menu, "\dУстановить Чекпоинт", "1", 0)
	else menu_additem(i_menu, "\wУстановить Чекпоинт", "1", 0)
	
	if(g_TotalCheckpoints == 0)
		menu_additem(i_menu, "\dУдалить предыдущий Чекпоинт", "2", 0)
	else menu_additem(i_menu, "\wУдалить предыдущий Чекпоинт", "2", 0)
	
	if(g_TotalCheckpoints == 0)
		menu_additem(i_menu, "\dУдалить все Чекпоинты", "3", 0)
	else menu_additem(i_menu, "\wУдалить все Чекпоинты", "3", 0)
	
	if(!g_save_cpl)
		menu_additem(i_menu, "\dСохранить изменения", "4", 0)
	else menu_additem(i_menu, "\wСохранить изменения", "4", 0)

	menu_setprop(i_menu, MPROP_EXIT, MEXIT_ALL)
	menu_setprop(i_menu, MPROP_EXITNAME, "\yВыход")
	menu_display(id, i_menu, 0)
		
	return PLUGIN_HANDLED
}

public menu_handler(id, menu, item)
{
	if (item == MENU_EXIT)
	{
		menu_destroy(menu)
		return PLUGIN_HANDLED
	}

	new s_Data[6], s_Name[64], i_Access, i_Callback
	menu_item_getinfo(menu, item, i_Access, s_Data, charsmax(s_Data), s_Name, charsmax(s_Name), i_Callback)
    
	new i_Key = str_to_num(s_Data)
	
	switch(i_Key)
	{
		case 1:
		{
			if(g_TotalCheckpoints == MAX_CHECKPOINTS_LOAD)
			{
				PrintChatColor(id, PRINT_COLOR_PLAYERTEAM, "!g[%s] !tПревышен максимум", PLUGIN) 
				Checkpoint_menu(id)
				return PLUGIN_HANDLED
			}
						
			new Ent = create_entity("info_target")
			if(is_valid_ent(Ent))
			{	
				PrintChatColor(id, PRINT_COLOR_PLAYERTEAM, "!g[%s] !tЧекпоинт установлен", PLUGIN) 

				g_save_cpl = true
				g_TotalCheckpoints++
				
				g_Checkpoint_id[g_TotalCheckpoints-1] = Ent
				entity_set_model(Ent, FinishCP)
				
				new Float:fOrigin[3]
				fm_get_aim_origin(id, fOrigin)
				fOrigin[2]+=60
				
				entity_set_origin(Ent, fOrigin)
				set_pev(Ent, pev_sequence, 0)
				set_pev(Ent, pev_framerate, 1.0)
				entity_set_size(Ent,Float:{-45.0, -45.0, -45.0}, Float:{45.0, 45.0, 45.0})
				entity_set_int(Ent,EV_INT_solid,SOLID_TRIGGER)
				set_pev(Ent,pev_movetype, MOVETYPE_FLY)
				set_pev(Ent, pev_effects, 8)
				
				if(g_TotalCheckpoints != 1)
				{
					for(new i=0; i<g_TotalCheckpoints-1; i++)
					{
						new color = random_num(0,4)
						switch(color)
						{
							case 0: entity_set_model(g_Checkpoint_id[i], GreenCP)
							case 1: entity_set_model(g_Checkpoint_id[i], BlueCP)
							case 2: entity_set_model(g_Checkpoint_id[i], OrangeCP)
							case 3: entity_set_model(g_Checkpoint_id[i], PurpleCP)
							case 4: entity_set_model(g_Checkpoint_id[i], YellowCP)
						}
					}
				}
			}
			Checkpoint_menu(id)
		}
		case 2:
		{
			if(g_TotalCheckpoints == 0)
			{
				PrintChatColor(id, PRINT_COLOR_PLAYERTEAM, "!g[%s] !tНа карте нет Чекпоинтов", PLUGIN) 
				Checkpoint_menu(id)
				return PLUGIN_HANDLED
			}
			
			PrintChatColor(id, PRINT_COLOR_PLAYERTEAM, "!g[%s] !tЧекпоинт удален", PLUGIN)
			
			g_save_cpl = true
			g_TotalCheckpoints--
			
			remove_entity(g_Checkpoint_id[g_TotalCheckpoints])
			
			if(g_TotalCheckpoints != 0)
				entity_set_model(g_Checkpoint_id[g_TotalCheckpoints-1], FinishCP)
				
			Checkpoint_menu(id)
		}
		case 3:
		{
			if(g_TotalCheckpoints == 0)
			{
				PrintChatColor(id, PRINT_COLOR_PLAYERTEAM, "!g[%s] !tНа карте нет Чекпоинтов", PLUGIN) 
				Checkpoint_menu(id)
				return PLUGIN_HANDLED
			}
			
			g_save_cpl = true
			
			for(new i=0; i<g_TotalCheckpoints; i++)
				remove_entity(g_Checkpoint_id[i])
				
			PrintChatColor(id, PRINT_COLOR_PLAYERTEAM, "!g[%s] !tБыло удалено !g%d !tЧекпоинтов", PLUGIN, g_TotalCheckpoints)
				
			g_TotalCheckpoints = 0
			
			Checkpoint_menu(id)
		}
		case 4:
		{
			if(!g_save_cpl)
			{
				Checkpoint_menu(id)
				return PLUGIN_HANDLED
			}
			
			g_save_cpl = false
			set_maps_cfg()
			
			PrintChatColor(id, PRINT_COLOR_PLAYERTEAM, "!g[%s] !tСохранено", PLUGIN)
			Checkpoint_menu(id)
		}
	}
	return PLUGIN_HANDLED
}

stock get_count_lines(szFileName[])
{
	new fHandle = fopen(szFileName, "rt")
	if(!fHandle)
		return 0

	new szBuffer[2], iLines

	while(!feof(fHandle))
	{
		fgets(fHandle, szBuffer, 1)
		if (!szBuffer[0])
			continue
				
		iLines++
	}

	fclose(fHandle)
	return iLines
}
