#include <amxmodx> 
#include <amxmisc>
#include <engine>
#include <cstrike>
#include <fun>

#define TASK_PLANT		15100
#define TASK_NOTICE		15300

#define LASERMINE_INT_TEAM	EV_INT_iuser1
#define LASERMINE_OWNER		EV_INT_iuser3
#define DMG_BULLET		(1<<1)
#define MAX_MINES		100

new MINE_COST
new FRAGMONEY
new LASER_HIT_DMG
new MINE_HEALTH
new MAX_MINES_CVAR

new beam, boom
new player_mines_ent[33][MAX_MINES]
new player_mines_count[33]
new bool:g_settinglaser[33]
new g_msgDeathMsg
new g_msgScoreInfo
new g_msgDamage
new g_msgStatusText
new Float:plspeed[33]
new plsetting[33]

public plugin_modules() {
	require_module("engine")
	require_module("cstrike")
	require_module("fun")
}

detonate_mine(iCurrent, iHit) {
	
	new Float:vOrigin[3]
	entity_get_vector(iCurrent, EV_VEC_origin, vOrigin)

	message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
	write_byte(99) //99 = KillBeam
	write_short(iCurrent)
	message_end()

	message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
	write_byte(3)
	write_coord(floatround(vOrigin[0]))
	write_coord(floatround(vOrigin[1]))
	write_coord(floatround(vOrigin[2]))
	write_short(boom)
	write_byte(50)
	write_byte(15)
	write_byte(0)
	message_end()

	radius_damage(vOrigin, 1, 50)

	new id,slot

	//id = Entvars_Get_Edict(iCurrent, EV_ENT_owner)
	remove_entity(iCurrent)





	// clear this from the list of live lasermines
	for (id=1;id<33;id++) {
		for (slot=0;slot<MAX_MINES;slot++) {
			if (player_mines_ent[id][slot] == iCurrent) {
				player_mines_ent[id][slot] = -1
				player_mines_count[id] = player_mines_count[id] - 1
   
				if (iHit == -1){
					client_print(id, print_chat, "[LaserMines] Твоя мина взорвалась.")
				} else {
					new szNetName[32]
					entity_get_string(iHit, EV_SZ_netname, szNetName, 32)
					client_print(id, print_chat, "[LaserMines] %s detonated your mine.",szNetName)
				}
				break
			}
		}
	}

}

public CreateLaserMine_Progress(id){ 


	if (!CreateCheck(id))
		return PLUGIN_HANDLED
	g_settinglaser[id] = true
	//
	// Progress Bar (Activate) -- This was taken almost directly from xeroblood!
	//
	message_begin( MSG_ONE, 108, {0,0,0}, id )
	write_byte(1)   // duration
	write_byte(0)   // duration
	message_end()


	new PID[1] 
	PID[0] = id
	set_task(1.0, "CreateLaserMine", (TASK_PLANT + id), PID, 1)

	return PLUGIN_HANDLED;
}

public StopCreateLaserMine(id)
{
	if (task_exists((TASK_PLANT + id)))
	{
		remove_task((TASK_PLANT + id))
	}
	g_settinglaser[id] = false
	//
	// Progress Bar (Terminate)
	//
	message_begin(MSG_ONE, 108, {0,0,0}, id)
	write_byte(0) // duration
	write_byte(0) // duration
	message_end()

	return PLUGIN_HANDLED
}

public bool:CreateCheck(id){
	new Status = get_cvar_num( "amx_lasermine" )
	if( Status != 1  ){
		client_print(id, print_chat, "[Lasermines] Лазерная мина не активна.")
		return false
	}

	if(entity_get_int(id, EV_INT_deadflag) != 0)
		return false
 
	if(is_user_alive(id) == 0)
		return false

	if(player_mines_count[id] >= MAX_MINES_CVAR) {
		client_print(id, print_chat, "[Lasermines] Максимум мин поставлено.")
		return false
	}
	if (cs_get_user_money(id) < MINE_COST) {
		client_print(id, print_chat, "[Lasermines] У тебя нету денег чтобы купить лазерную мину! ($%d needed)", MINE_COST)	
		return false	
	}
	new Float:vOrigin[3]
	new Float:vAngles[3]
	new NewEnt
	new Float:MinBox[3]
	new Float:MaxBox[3]
	new Float:vNormal[3]
	new Float:vTraceDirection[3]
	new Float:vTraceEnd[3]
	new Float:vTraceResult[3]

	entity_get_vector(id, EV_VEC_origin, vOrigin)
	entity_get_vector(id, EV_VEC_v_angle, vAngles)

	NewEnt = create_entity("info_target")

	if(NewEnt == 0) {
		return false
	}

	entity_set_string(NewEnt, EV_SZ_classname, "lasermine")
	
	entity_set_int(NewEnt, EV_INT_movetype, 5) //5 = movetype_fly, No grav, but collides.
	entity_set_int(NewEnt, EV_INT_solid, 0) 
	
	entity_set_model(NewEnt, "models/v_tripmine.mdl")
	
	entity_set_float(NewEnt, EV_FL_frame, 0.0)
	entity_set_int(NewEnt, EV_INT_body, 3)
	entity_set_int(NewEnt, EV_INT_sequence, 7) // 7 = TRIPMINE_WORLD
	entity_set_float(NewEnt, EV_FL_framerate, 0.0)

	entity_set_float(NewEnt, EV_FL_takedamage, 1.0)
	entity_set_float(NewEnt, EV_FL_dmg, 100.0)
	entity_set_float(NewEnt, EV_FL_health, float(MINE_HEALTH))

	entity_set_int(NewEnt, EV_INT_iuser2, 0) //0 Will be for inactive.


	MinBox[0] = -8.0
	MinBox[1] = -8.0
	MinBox[2] = -8.0
	MaxBox[0] = 8.0
	MaxBox[1] = 8.0
	MaxBox[2] = 8.0

	entity_set_vector(NewEnt, EV_VEC_mins, MinBox)
	entity_set_vector(NewEnt, EV_VEC_maxs, MaxBox)


	velocity_by_aim(id, 64, vTraceDirection)

	vTraceEnd[0] = vTraceDirection[0] + vOrigin[0]
	vTraceEnd[1] = vTraceDirection[1] + vOrigin[1]
	vTraceEnd[2] = vTraceDirection[2] + vOrigin[2]

	trace_line(id, vOrigin, vTraceEnd, vTraceResult)

	if(trace_normal(id, vOrigin, vTraceEnd, vNormal) == 0) {
		remove_entity(NewEnt)
		client_print(id, print_chat, "[Lasermines] Ты должен поставить лазер на стену!")
		g_settinglaser[id] = false
		return false
	}
	remove_entity(NewEnt)

	return true
}

public CreateLaserMine(PID[]){
	new id = PID[0]
	new Float:vOrigin[3]
	new Float:vAngles[3]
	entity_get_vector(id, EV_VEC_origin, vOrigin)
	entity_get_vector(id, EV_VEC_v_angle, vAngles)

	new NewEnt
	NewEnt = create_entity("func_breakable"/*"info_target"*/)

	if(NewEnt == 0) {
		return PLUGIN_HANDLED_MAIN
	}

	entity_set_string(NewEnt, EV_SZ_classname, "lasermine")
	
	entity_set_int(NewEnt, EV_INT_movetype, 5) //5 = movetype_fly, No grav, but collides.
	entity_set_int(NewEnt, EV_INT_solid, 0) 
	
	entity_set_model(NewEnt, "models/v_tripmine.mdl")
	
	entity_set_float(NewEnt, EV_FL_frame, 0.0)
	entity_set_int(NewEnt, EV_INT_body, 3)
	entity_set_int(NewEnt, EV_INT_sequence, 7) // 7 = TRIPMINE_WORLD
	entity_set_float(NewEnt, EV_FL_framerate, 0.0)

	entity_set_float(NewEnt, EV_FL_takedamage, 1.0)
	entity_set_float(NewEnt, EV_FL_dmg, 100.0)
	entity_set_float(NewEnt, EV_FL_health, float(MINE_HEALTH))

	entity_set_int(NewEnt, EV_INT_iuser2, 0) //0 Will be for inactive.

	new Float:MinBox[3]
	new Float:MaxBox[3]

	MinBox[0] = -8.0
	MinBox[1] = -8.0
	MinBox[2] = -8.0
	MaxBox[0] = 8.0
	MaxBox[1] = 8.0
	MaxBox[2] = 8.0

	entity_set_vector(NewEnt, EV_VEC_mins, MinBox)
	entity_set_vector(NewEnt, EV_VEC_maxs, MaxBox)

	new Float:vNewOrigin[3]
	new Float:vNormal[3]
	new Float:vTraceDirection[3]
	new Float:vTraceEnd[3]
	new Float:vTraceResult[3]
	new Float:vEntAngles[3]

	velocity_by_aim(id, 64, vTraceDirection)

	vTraceEnd[0] = vTraceDirection[0] + vOrigin[0]
	vTraceEnd[1] = vTraceDirection[1] + vOrigin[1]
	vTraceEnd[2] = vTraceDirection[2] + vOrigin[2]

	trace_line(id, vOrigin, vTraceEnd, vTraceResult)

	if(trace_normal(id, vOrigin, vTraceEnd, vNormal) == 0) {
		remove_entity(NewEnt)
		g_settinglaser[id] = false
		client_print(id, print_chat, "[Lasermines] Ты должен поставить лазер на стену!")
		return PLUGIN_HANDLED_MAIN
	}


	new slot = 0;
	for (slot = 0; slot < MAX_MINES; slot++) {
		if (player_mines_ent[id][slot] == -1)
			break;
	}
	if (slot >= MAX_MINES)  //unhandled error
		return PLUGIN_HANDLED_MAIN
 
	player_mines_ent[id][slot] = NewEnt
	player_mines_count[id] = player_mines_count[id] + 1

	vNewOrigin[0] = vTraceResult[0] + (vNormal[0] * 8.0)
	vNewOrigin[1] = vTraceResult[1] + (vNormal[1] * 8.0)
	vNewOrigin[2] = vTraceResult[2] + (vNormal[2] * 8.0)

	entity_set_origin(NewEnt, vNewOrigin)
	vector_to_angle(vNormal, vEntAngles)

	entity_set_vector(NewEnt, EV_VEC_angles, vEntAngles)

	new Float:vBeamEnd[3]
	new Float:vTracedBeamEnd[3]
	vBeamEnd[0] = vNewOrigin[0] + (vNormal[0] * 8192)
	vBeamEnd[1] = vNewOrigin[1] + (vNormal[1] * 8192)
	vBeamEnd[2] = vNewOrigin[2] + (vNormal[2] * 8192)
	trace_line(-1, vNewOrigin, vBeamEnd, vTracedBeamEnd)
	entity_set_vector(NewEnt, EV_VEC_vuser1, vTracedBeamEnd)

	emit_sound(NewEnt, CHAN_WEAPON, "weapons/mine_deploy.wav", 1.0, ATTN_NORM, 0, PITCH_NORM)
	emit_sound(NewEnt, CHAN_VOICE, "weapons/mine_charge.wav", 1.0, ATTN_NORM, 0, PITCH_NORM)

	new args[4]
	num_to_str(NewEnt,args,4)
	
	entity_set_int(NewEnt, LASERMINE_INT_TEAM, int:cs_get_user_team(id))
	entity_set_int(NewEnt, LASERMINE_OWNER,id)
	g_settinglaser[id] = false
	cs_set_user_money(id,cs_get_user_money(id) - MINE_COST)
	ShowAmmo(id)
	set_task(3.0, "LaserMine_Activate", 0, args, 4)

	return PLUGIN_HANDLED_MAIN
}

ShowAmmo(id)     
{ 
    new ammo[51] 
    format(ammo, 50, "LaserMines: %i", MAX_MINES_CVAR - player_mines_count[id]) 

    message_begin(MSG_ONE, g_msgStatusText, {0,0,0}, id) 
    write_byte(0) 
    write_string(ammo) 
    message_end() 
} 

public LaserMine_Activate(MineID[]) {

	new EntID = str_to_num(MineID)
	new iCurrent = find_ent_by_model(-1,"lasermine","models/v_tripmine.mdl") 
	if(iCurrent == 0)
		return PLUGIN_CONTINUE

	new Float:vOrigin[3]
	entity_get_vector(EntID, EV_VEC_origin, vOrigin)

	new Float:vEnd[3]
	entity_get_vector(EntID, EV_VEC_vuser1, vEnd)
	new teamid = entity_get_int(EntID, LASERMINE_INT_TEAM)
	if(teamid == 1){
		message_begin(MSG_BROADCAST,SVC_TEMPENTITY) 
		write_byte(0)
		write_coord(floatround(vOrigin[0]))
		write_coord(floatround(vOrigin[1]))
		write_coord(floatround(vOrigin[2]))
		write_coord(floatround(vEnd[0])) //Random
		write_coord(floatround(vEnd[1])) //Random
		write_coord(floatround(vEnd[2])) //Random
		write_short(beam)
		write_byte(0)
		write_byte(0)
		write_byte(3) //Life
		write_byte(5) //Width
		write_byte(0)//wave
		write_byte(255) // r
		write_byte(0) // g
		write_byte(0) // b
		write_byte(255)
		write_byte(0)
		message_end() 
	}else{

		message_begin(MSG_BROADCAST,SVC_TEMPENTITY) 
		write_byte(0)
		write_coord(floatround(vOrigin[0]))
		write_coord(floatround(vOrigin[1]))
		write_coord(floatround(vOrigin[2]))
		write_coord(floatround(vEnd[0])) //Random
		write_coord(floatround(vEnd[1])) //Random
		write_coord(floatround(vEnd[2])) //Random
		write_short(beam)
		write_byte(0)
		write_byte(0)
		write_byte(3) //Life
		write_byte(5) //Width
		write_byte(0)//wave
		write_byte(0) // r
		write_byte(0) // g
		write_byte(255) // b
		write_byte(255)
		write_byte(0)
		message_end() 
	}
	entity_set_int(EntID, EV_INT_iuser2, 1) //1 Will be for active.
	entity_set_int(EntID, EV_INT_solid, 2) //1 Will be for active.

	emit_sound(EntID, CHAN_VOICE, "weapons/mine_activate.wav", 1.0, ATTN_NORM, 0, PITCH_NORM)
	return PLUGIN_CONTINUE
}

public LaserMineThink() {
	if(get_cvar_num( "amx_lasermine" ) != 1  )
		return PLUGIN_HANDLED

	new iCurrent
	iCurrent = find_ent_by_class(-1, "lasermine")
	while(iCurrent != 0) {
		if(entity_get_int(iCurrent, EV_INT_iuser2) == 1) {
			new Float:vOrigin[3]
			entity_get_vector(iCurrent, EV_VEC_origin, vOrigin)

			new Float:vEnd[3]
			entity_get_vector(iCurrent, EV_VEC_vuser1, vEnd)

			new Float:vTrace[3]
			new iHit
			iHit = trace_line(iCurrent, vOrigin, vEnd, vTrace)

			new Float:health[1]
			health[0] = entity_get_float(iCurrent, EV_FL_health)

			new teamid = entity_get_int(iCurrent, LASERMINE_INT_TEAM)
	
			if (health[0] <= 0) {
				detonate_mine(iCurrent,-1)
			}else{
				if(iHit > 0 ) {
					new szClassName[32]
					entity_get_string(iHit, EV_SZ_classname, szClassName, 32)
					if(equal(szClassName, "player")){
						if(is_user_alive(iHit) && !get_user_godmode(iHit)){ 
							new iHitTeam = int:cs_get_user_team(iHit)
							new iHitHP = get_user_health(iHit) - LASER_HIT_DMG
							new id = entity_get_int(iCurrent,LASERMINE_OWNER)//, szNetName[32]

							if(iHitHP <= 0){
								new hitscore						
								if (get_cvar_num("mp_friendlyfire") == 0){
									if(iHitTeam != teamid){
										hitscore = 1
										cs_set_user_money(id,cs_get_user_money(id) + FRAGMONEY)
										//set_user_health(iHit, 0)	
										//entity_set_float(iHit, EV_FL_health,0.0)
										emit_sound(iHit, CHAN_WEAPON, "debris/beamstart9.wav", 1.0, ATTN_NORM, 0, PITCH_NORM )
										set_score(id,iHit,hitscore,iHitHP)
										//entity_get_string(iHit, EV_SZ_netname, szNetName, 32)
										//client_print(id, print_chat, "[LaserMines] %s killed your mine.",szNetName)
									}
								}else{
									if(iHitTeam != teamid){
										hitscore = 1
										cs_set_user_money(id,cs_get_user_money(id) + FRAGMONEY)
									}else{
										hitscore = -1									
										cs_set_user_money(id,cs_get_user_money(id) - FRAGMONEY)
									}
									//set_user_health(iHit, 0)
									//entity_set_float(iHit, EV_FL_health, 0.0)
									emit_sound(iHit, CHAN_WEAPON, "debris/beamstart9.wav", 1.0, ATTN_NORM, 0, PITCH_NORM )
									set_score(id,iHit,hitscore,iHitHP)
									//entity_get_string(iHit, EV_SZ_netname, szNetName, 32)
									//client_print(id, print_chat, "[LaserMines] %s killed your mine.",szNetName)
								}
							}else{
								set_user_health(iHit, iHitHP)
								message_begin(MSG_ONE_UNRELIABLE, g_msgDamage, {0,0,0}, iHit) 
								write_byte(LASER_HIT_DMG)
								write_byte(LASER_HIT_DMG)
								write_long(DMG_BULLET)
								write_coord(floatround(vOrigin[0]))
								write_coord(floatround(vOrigin[1]))
								write_coord(floatround(vOrigin[2]))
								message_end()
							}
						}
					}
				}
			}
		}

		iCurrent =  find_ent_by_class(iCurrent, "lasermine")
	}
	return PLUGIN_CONTINUE
}

public LaserMine_LaserThink() {
	if(get_cvar_num( "amx_lasermine" ) != 1  )
		return PLUGIN_HANDLED

	new iCurrent
	iCurrent = find_ent_by_class(-1, "lasermine")
	while(iCurrent != 0){
		if(entity_get_int(iCurrent, EV_INT_iuser2) == 1){
			new Float:vOrigin[3]
			entity_get_vector(iCurrent, EV_VEC_origin, vOrigin)
	
			new Float:vEnd[3]
			entity_get_vector(iCurrent, EV_VEC_vuser1, vEnd)
				
			new teamid = entity_get_int(iCurrent, LASERMINE_INT_TEAM)

			if(teamid == 1){
				message_begin(MSG_BROADCAST,SVC_TEMPENTITY) 
				write_byte(0)
				write_coord(floatround(vOrigin[0]))
				write_coord(floatround(vOrigin[1]))
				write_coord(floatround(vOrigin[2]))
				write_coord(floatround(vEnd[0])) //Random
				write_coord(floatround(vEnd[1])) //Random
				write_coord(floatround(vEnd[2])) //Random
				write_short(beam)
				write_byte(0)
				write_byte(0)
				write_byte(3) //Life
				write_byte(5) //Width
				write_byte(0)//wave
				write_byte(255) // r
				write_byte(0) // g
				write_byte(0) // b
				write_byte(255)
				write_byte(0)
				message_end() 
			}else{
				message_begin(MSG_BROADCAST,SVC_TEMPENTITY) 
				write_byte(0)
				write_coord(floatround(vOrigin[0]))
				write_coord(floatround(vOrigin[1]))
				write_coord(floatround(vOrigin[2]))
				write_coord(floatround(vEnd[0])) //Random
				write_coord(floatround(vEnd[1])) //Random
				write_coord(floatround(vEnd[2])) //Random
				write_short(beam)
				write_byte(0)
				write_byte(0)
				write_byte(3) //Life
				write_byte(5) //Width
				write_byte(0)//wave
				write_byte(0) // r
				write_byte(0) // g
				write_byte(255) // b
				write_byte(255)
				write_byte(0)
				message_end() 
			}
		}
		iCurrent =  find_ent_by_class(iCurrent, "lasermine")
	}
	return PLUGIN_CONTINUE
}

public set_score(id,target,hitscore,HP){

//	entity_set_float(id, EV_FL_frags, entity_get_float(id, EV_FL_frags) + hitscore)
//	entity_set_float(target, EV_FL_frags, entity_get_float(target, EV_FL_frags) + 1.0)

	new idfrags = get_user_frags(id) + hitscore	
	set_user_frags(id, idfrags)
	
	new tarfrags = get_user_frags(target) + 1
	set_user_frags(target,tarfrags)
	
	new idteam = int:cs_get_user_team(id)
	new iddeaths = get_user_deaths(id)


	message_begin(MSG_ALL, g_msgDeathMsg, {0, 0, 0} ,0)
	write_byte(id)
	write_byte(target)
	write_byte(0)
	write_string("lasermine")
	message_end()

	message_begin(MSG_ALL, g_msgScoreInfo)
	write_byte(id)
	write_short(idfrags)
	write_short(iddeaths)
	write_short(0)
	write_short(idteam)
	message_end()

	set_msg_block(g_msgDeathMsg, BLOCK_ONCE)

	//entity_set_float(target, EV_FL_health,float(HP))
	set_user_health(target, HP)

}

public standing(id) {
	if (!g_settinglaser[id])
		return PLUGIN_CONTINUE

	entity_set_float(id, EV_FL_maxspeed, 1.0)
//	ShowAmmo(id)

	return PLUGIN_CONTINUE
}

public client_PostThink(id) {
	if (!g_settinglaser[id] && plsetting[id]){
		resetspeed(id)
	}
	else if (g_settinglaser[id] && !plsetting[id]) {
		plspeed[id] = entity_get_float(id, EV_FL_maxspeed)
		entity_set_float(id, EV_FL_maxspeed, 1.0)
	}
	plsetting[id] = g_settinglaser[id]
	return PLUGIN_CONTINUE
}

public resetspeed(who) {
	entity_set_float(who, EV_FL_maxspeed, plspeed[who])
}

public client_connect(id){
	new j
	for (j=0;j<MAX_MINES;j++) {
		player_mines_ent[id][j] = -1
		player_mines_count[id] = 0
	}
	g_settinglaser[id] = false
	return PLUGIN_CONTINUE
}

public client_disconnect(id){
	if(get_cvar_num( "amx_lasermine" ) != 1  )
		return PLUGIN_CONTINUE

	reset_laser(id)
	g_settinglaser[id] = false
	return PLUGIN_CONTINUE
}

public newround(id){
	if(get_cvar_num( "amx_lasermine" ) != 1  )
		return PLUGIN_CONTINUE
	plspeed[id] = entity_get_float(id, EV_FL_maxspeed)
	reset_laser(id)
	g_settinglaser[id] = false
	return PLUGIN_CONTINUE
}

public DeathEvent(){
	if(get_cvar_num( "amx_lasermine" ) != 1  )
		return PLUGIN_CONTINUE

	new id = read_data(2)

	if (task_exists(id))
		remove_task(id)
	g_settinglaser[id] = false
	return PLUGIN_CONTINUE
}

public reset_laser(id){
	if(get_cvar_num( "amx_lasermine" ) != 1  )
		return PLUGIN_CONTINUE

	new j, iCurrent
	player_mines_count[id] = 0

	for (j=0;j<MAX_MINES;j++) {
		if (player_mines_ent[id][j] != -1) {
 
			iCurrent = player_mines_ent[id][j]
 
			new Float:vOrigin[3]
			entity_get_vector(iCurrent, EV_VEC_origin, vOrigin)
  
			message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
			write_byte(99) //99 = KillBeam
			write_short(iCurrent)
			message_end()
/*
			message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
			write_byte(3)
			write_coord(floatround(vOrigin[0]))
			write_coord(floatround(vOrigin[1]))
			write_coord(floatround(vOrigin[2]))
			write_short(boom)
			write_byte(50)
			write_byte(15)
			write_byte(0)
			message_end()
 
			radius_damage(vOrigin, 1, 50)
 */
			remove_entity(iCurrent)
  
			player_mines_ent[id][j] = -1
  
		}
	}
	return PLUGIN_CONTINUE
}

public check_cvars(){
	if (get_cvar_num("amx_lasermine_ammo") > 100) {
		server_print("[Lasermines] amx_lasermine_ammo can't be greater than 100, setting cvar to 100 now.")
		set_cvar_num("amx_lasermine_ammo", 100)
	}
	if (get_cvar_num("amx_lasermine_ammo") < 1) {
		server_print("[Lasermines] amx_lasermine_ammo can't be less than 1, setting cvar to 1 now.")
		set_cvar_num("amx_lasermine_ammo", 1)
	}
	if (get_cvar_num("amx_lasermine_health") > 8000){
		server_print("[Lasermines] amx_lasermine_health can't be greater than 8000, setting cvar to 8000 now.")
		set_cvar_num("amx_lasermine_health", 8000)	
	}
	if (get_cvar_num("amx_lasermine_health") < 1) {
		server_print("[Lasermines] amx_lasermine_health can't be less than 1, setting cvar to 1 now.")
		set_cvar_num("amx_lasermine_health", 1)
	}
	if (get_cvar_num("amx_lasermine_cost") > 16000){
		server_print("[Lasermines] amx_lasermine_cost can't be greater than 16000, setting cvar to 16000 now.")
		set_cvar_num("amx_lasermine_cost", 16000)	
	}
	if (get_cvar_num("amx_lasermine_cost") < 0) {
		server_print("[Lasermines] amx_lasermine_cost can't be less than 0, setting cvar to 0 now.")
		set_cvar_num("amx_lasermine_cost", 100)
	}
	if (get_cvar_num("amx_lasermine_dmg") < 1) {
		server_print("[Lasermines] amx_lasermine_dmg can't be less than 1, setting cvar to 1 now.")
		set_cvar_num("amx_lasermine_dmg", 1)
	}
	if (get_cvar_num("amx_lasermine_fragmoney") < 100) {
		server_print("[Lasermines] amx_lasermine_dmg can't be less than 100, setting cvar to 100 now.")
		set_cvar_num("amx_lasermine_dmg", 100)
	}

	MAX_MINES_CVAR = get_cvar_num("amx_lasermine_ammo")
	FRAGMONEY = get_cvar_num("amx_lasermine_fragmoney")
	MINE_COST = get_cvar_num("amx_lasermine_cost")
	MINE_HEALTH = get_cvar_num("amx_lasermine_health")
	LASER_HIT_DMG = get_cvar_num("amx_lasermine_dmg")

}
public plugin_precache() {
	precache_sound("weapons/mine_deploy.wav")
	precache_sound("weapons/mine_charge.wav")
	precache_sound("weapons/mine_activate.wav")
	precache_sound("debris/beamstart9.wav")
	precache_model("models/v_tripmine.mdl")
	beam = precache_model("sprites/laserbeam.spr")
	boom = precache_model("sprites/zerogxplode.spr")

	return PLUGIN_CONTINUE 
}

public server_changelevel(map[]){

	MAX_MINES_CVAR = get_cvar_num("amx_lasermine_ammo")
	FRAGMONEY = get_cvar_num("amx_lasermine_fragmoney")
	MINE_COST = get_cvar_num("amx_lasermine_cost")
	MINE_HEALTH = get_cvar_num("amx_lasermine_health")
	LASER_HIT_DMG = get_cvar_num("amx_lasermine_dmg")

}
public plugin_init(){ 
	register_plugin("LaserMine Entity","1.0","+ARUKARI-") 
	register_clcmd("+setlaser","CreateLaserMine_Progress")
   	register_clcmd("-setlaser","StopCreateLaserMine")
	register_cvar( "amx_lasermine", "1", FCVAR_UNLOGGED )

	register_event("DeathMsg", "DeathEvent", "a")
 	register_event("CurWeapon", "standing", "be", "1=1")
	register_event("ResetHUD", "newround", "b")

	register_cvar("amx_lasermine_ammo","100")
	register_cvar("amx_lasermine_dmg","10000")
	register_cvar("amx_lasermine_cost","0")
	register_cvar("amx_lasermine_fragmoney","1")
	register_cvar("amx_lasermine_health","5000")

	g_msgDeathMsg = get_user_msgid("DeathMsg")
	g_msgScoreInfo = get_user_msgid("ScoreInfo")
	g_msgDamage = get_user_msgid("Damage")
	g_msgStatusText = get_user_msgid("StatusText")

	set_task(0.01, "LaserMineThink", 0, "", 0, "b")
	set_task(0.1, "LaserMine_LaserThink", 0, "", 0, "b")
	set_task(2.0,"check_cvars",0,"",0,"b")

	return PLUGIN_CONTINUE 
}
