# -*- coding:Utf-8 -*-

"""
   ***** PaintBall v1.5a By L'In20Cible. *****
   
   Description :
      A simple paintball effects script.
   
   Requirements:
      - Mattie's EventScripts v2.0+
         Download link : http://forums.eventscripts.com/
      - Es_Tools
         Download link : http://forums.eventscripts.com/viewforum.php?f=42

   Features :
      - 5 different paint colors.
      - Paintball effects don't affect players. (Only walls)
      - A Say command to change your own paint color.
         Syntax : !paintball
         
   Compatible games :
      - Counter Strike:Source
      - Half Life 2:DeathMatch
      
   Installation :
      - Download the script PaintBall v1.5a by L'In20Cible.
         Download link : http://addons.eventscripts.com/addons/view/pb
      - Extract the zip file to your game owner folder.
      - Add the following line to your autoexec.cfg file :
         es_xload paintball
      - Reboot your server.
         
   Credits :
      - L'In20Cible for the code.
      - SoulDesigner for the paintball textures.
      - sn4k3 for the idea ?
      
   Version Notes :
      - v1.0 (2009-06-08)
         - First release.
      - v1.1 (2009-06-09)
         - Remove the paintball effects at knife impact.
      - v1.3 (2009-06-09)
         - Added a say command for change your own paint color.
      - v1.4 (2009-06-12)
         - Added new textures.
         - Added new effects more realistic.
      - v1.5 (2009-06-13)
         - Added colors name translation.
         - Remove the current player color in the choice menu.
         - Now compatible with the official es_tools release.
         - Added pb_ prefix to the new textures names. (to download the news textures)
      - v1.5a (2009-06-13)
         - Fixed the player name error.
      
   ***** Don't edit below this line unless you know what you'are doing. *****
"""

import es
import random
import usermsg
import langlib
import popuplib

# Information.
pb_info = es.AddonInfo() 
pb_info.name = 'Paintball Effects' 
pb_info.basename = 'paintball'
pb_info.version = '1.5a by L\'in20Cible'
pb_info.url = 'http://addons.eventscripts.com/addons/view/pb'
pb_info.description = 'Simple Paintball Effects'
pb_info.author = 'L\'In20Cible' 
es.ServerVar('paintball_version', pb_info.version).makepublic()

# Global.
advert = es.ServerVar('pb_advert')
colors = ['cyan', 'green', 'pink', 'orange', 'yellow']
strings = langlib.Strings(es.getAddonPath('paintball') + '/paintball.ini')

def load():
   init()
   es.doblock('corelib/noisy_on')
   
def unload():
   es.doblock('corelib/noisy_off')
   
   for popup in popups: popuplib.delete(popup)
   
# Events.
def es_map_start(event_var):
   init()
   
def round_start(event_var):
   est_check()
   
def round_freeze_end(event_var):
   if int(advert): sendMessage('advert')
   
# Initialization.
def init():
   est_check()
   es.server.queuecmd('es_xmexec ../addons/eventscripts/paintball/paintball.cfg')
   
   for color in colors:
      es.stringtable('downloadables', 'materials/paintball/pb_%s.vmt' % color)
      es.stringtable('downloadables', 'materials/paintball/pb_%s.vtf' % color)
      
def est_check():
   if not es.exists('variable', 'est_version'): sendMessage('es_tools')
   
# Language.
def getText(string, language, tokens = None):
   return strings(string, tokens, language)
   
def getLang(userid):
   return langlib.getLangAbbreviation(es.getclientvar(userid, 'cl_language'))
   
def sendMessage(message):
   for player in [userid for userid in es.getUseridList() if not es.isbot(userid)]:
      es.tell(player, '#multi', '#green[Paintball] %s' % getText(message, getLang(player)))
   
# Settings.
popups = []
settings = {}

def player_say(event_var):
   if event_var['text'].lower() == '!paintball':
      popup = 'paintball_%s' % event_var['userid']
      if not popuplib.exists(popup):
         lang = getLang(event_var['userid'])
         menu = popuplib.easymenu(popup, None, select)
         menu.settitle(getText('title', lang))
         setting = getSetting(event_var['userid'])
         if not setting == 'random':
            menu.addoption('random', getText('random', lang))
         for color in colors:
            if not setting == color:
               menu.addoption(color, getText(color, lang))
            else:
               continue
         popups.append(popup)
         
      if not popuplib.isqueued(popup, event_var['userid']): popuplib.send(popup, event_var['userid'])
            
def select(userid, choice, popup):
   settings[str(userid)] = choice
   index = es.createplayerlist(userid)[int(userid)]['index']
   for player in [user for user in es.getUseridList() if not es.isbot(user)]:
      lang = getLang(player)
      usermsg.saytext2(player, index, '\x04[Paintball] %s' % getText('change', lang, {'player':es.getplayername(userid), 'color':getText(choice, lang)}))
   es.playsound(userid, 'buttons/button14.wav', 1.0)
   
   if popup in popups: popups.remove(popup)
   if popuplib.exists(popup): popuplib.delete(popup)
      
def getSetting(userid):
   if settings.has_key(userid) and settings[userid] in colors:
      return settings[userid]
   else:
      return 'random'
   
# Effect.
def getTexture(userid):
   if settings.has_key(userid) and settings[userid] in colors:
      return settings[userid]
   else:
      return random.choice(colors)
   
def bullet_impact(event_var):
   es.server.queuecmd('est_effect_35 #h 0 paintball/pb_%s.vmt "%s %s %s"' % (getTexture(event_var['userid']), event_var['x'], event_var['y'], event_var['z']))