/* Plugin generated by AMXX-Studio */

/*
	CS Flags Editor
	===============
	by commonbullet
	
	Part of CS Flags plugin
	
	Credits, Requirements, Specs:
	-----------------------------
	Refer to CS Flags plugin
	
	Command:
	---------
	csflags_edit - toggles flag editing mode; edition is made through menus,
		       so it's supposed to be intuitive.
	
	Important: make sure there's a csflags inside amxx configs directory
	
	
	
	Thanks to all translators!
	---------------------------
	arkshine, Dav3, Deviance, Howdy, SAMURAI16, SeToY
	
*/

#define VERSION "1.08"

#define MENUID_MAIN 1

#define ACCESS_CSFLAGS_EDITOR ADMIN_ADMIN

#define MAX_CSFLAGS 5 // hard limit

#define pev_flagname pev_targetname
#define pev_flagid pev_iuser3
#define pev_hitbox pev_iuser1
#define CLASSNAME_CSFLAG_EDIT "__csflag"
#define CLASSNAME_CSFLAG "csflag"

#define MODEL_FLAGS "models/csflags/csflags.mdl"
#define FILE_CSFLAGS_CFG "/csflags/%s.cfg"
#define CSFLAGS_CONFIG_DIR "/csflags"

#define INTERVAL_FAKE_THINK 1.0
#define TASKID_FAKE_THINK 9489

#define MENU_KEYS_CREATE (1 << 0) | (1 << 7)
#define MENU_KEYS_EDIT (1 << 0) | (1 << 1) | (1 << 2) | (1 << 3) | (1 << 4) | (1 << 5) | (1 << 7)

#define SOUND_CREATE "spk sound/buttons/button3"
#define SOUND_ERROR "spk sound/buttons/button10"
#define SOUND_TRANSFORM "spk sound/buttons/blip1"
#define SOUND_DELETE "spk sound/weapons/357_cock1"
#define SOUND_WARNING "spk sound/buttons/blip1"
#define SOUND_SAVED "spk sound/buttons/button5"

#define SPRITE_LINE "sprites/white.spr"

#define MSG_ERROR_CREATE_FLAG "Could not create flag, because there's already 5 flags or flag entity could not be created."
#define MSG_ERROR_WRITE_CFG "No flag has been created, nothing has been written"
#define MSG_ERROR_LOAD_CFG "CFG file not created yet, no flags have been loaded"
#define MSG_WRITE_CFG "Found %d flags. CFG file saved successfully"
#define MSG_LOAD_CFG "Loaded %d flags from cfg file"
#define MSG_CSFLAGS_STOPPED "[CSFlags] CSflags have been stopped because an ADMIN is editing flag points for this map"
#define MSG_ERROR_BEING_EDITED "Flags are already being edited by other admin, try later."
#define MSG_ERROR_DIR_NOT_FOUND "Cannot open editor because there's no 'csflags' folder in your amxx configs directory." 
#define MSG_ERROR_INVALID_ID "Invalid id 0 - editor can't run in a server console."

#define MENU_BODY_MAIN "\y[CSFLAGS_EDIT]^n^n\w1. Create^n^n\r8. Save & Exit"
#define MENU_BODY_EDIT "\y[CSFLAGS_EDIT]^n^n\w1. Fetch^n2. Rotate CCW^n3. Rotate CW^n4. Rename^n5. Change Hitbox^n6. Delete^n\r8. Save & Exit"


#define CMD_TOGGLE_EDIT "csflags_edit"

#define MAX_HITBOXES 3

#define HITBOX_ID_NORMAL 0
#define HITBOX_ID_LARGER 1
#define HITBOX_ID_LARGE 2

#define HITBOX_NORMAL {{-24.0, -24.0, -64.0}, {24.0, 24.0, 64.0}}
#define HITBOX_LARGER {{-60.0, -60.0, -80.0}, {60.0, 60.0, 80.0}}
#define HITBOX_LARGE {{-100.0, -100.0, -128.0}, {100.0, 100.0, 128.0}}


#define HITBOX_MAX 1
#define HITBOX_MIN 0

#include <amxmodx>
#include <amxmisc>
#include <fakemeta>

new g_Selected = -1
new g_LastSelected = -1
new g_Editor
new g_EditMode
new g_EditorOrigin[3]
new g_FlagEnts[MAX_CSFLAGS]
new g_MenuCreate
new g_MenuEdit
new g_Playing
new g_OptionsMenuCreate[256]
new g_OptionsMenuEdit[256]

new sprite_line

new const g_HitBoxName[3][] =
{
	"Normal",
	"Larger",
	"Large"
}

public plugin_init() {
	register_plugin("csflags_editor", VERSION, "commonbullet")
	g_MenuCreate = register_menuid("menucreateflag")
	g_MenuEdit = register_menuid("menueditflag")
	register_menucmd(g_MenuCreate, 1023, "menu_create_flag_handler")
	register_menucmd(g_MenuEdit, 1023,"menu_edit_flag_handler")	
	register_concmd(CMD_TOGGLE_EDIT, "toggle_csflags_edit", ACCESS_CSFLAGS_EDITOR)
	register_concmd("flagname", "set_flagname", ACCESS_CSFLAGS_EDITOR)
	
	register_dictionary("csflags_editor.txt")
}
public plugin_precache() {
	precache_model(MODEL_FLAGS)
	sprite_line = precache_model(SPRITE_LINE)
}

public menu_create_flag() {
	if(!strlen(g_OptionsMenuCreate)) {
		format(g_OptionsMenuCreate, 255, "%L", LANG_PLAYER, "MENU_BODY_MAIN")
	}
	show_menu(g_Editor, MENU_KEYS_CREATE, g_OptionsMenuCreate, _, "menucreateflag")
}

public menu_edit_flag() {
	if(!strlen(g_OptionsMenuEdit)) {
		format(g_OptionsMenuEdit, 255, "%L", LANG_PLAYER, "MENU_BODY_EDIT")
	}
	show_menu(g_Editor, MENU_KEYS_EDIT, g_OptionsMenuEdit, _, "menueditflag")
}

public menu_create_flag_handler(id, key) {
	if(key == 0) {
		if(!create_flag()) {
			send_msg("MSG_ERROR_CREATE_FLAG" , 1)
			exec_command(SOUND_ERROR)
		}
	}
	if(key == 7) save_and_exit()
}

public menu_edit_flag_handler(id, key) {
	if(g_Selected > -1) {
		if(key == 0) {
			new Float:flagorigin[3]
			pev(g_Editor, pev_origin, flagorigin)
			flagorigin[2] -= 12.0
			engfunc(EngFunc_SetOrigin, g_FlagEnts[g_Selected], flagorigin)
			menu_edit_flag()
		}
		else if(key == 1 || key == 2) {
			new Float:angles[3]
			pev(g_FlagEnts[g_Selected], pev_angles, angles)
			angles[1] = (key == 1) ? angles[1] - 30.0 : angles[1] + 30.0
			engfunc(EngFunc_MakeVectors, angles)
			angles[1] = (angles[1] < 0) ? angles[1] + 360.0 : (angles[1] > 360.0) ? angles[1] - 360.0 : angles[1]
			set_pev(g_FlagEnts[g_Selected], pev_angles, angles)
			exec_command(SOUND_TRANSFORM)
			menu_edit_flag()
		}
		else if(key == 3)		
			exec_command("messagemode flagname")
		else if(key == 4) {
			new hitbox
			hitbox = pev(g_FlagEnts[g_Selected], pev_hitbox)
			hitbox = hitbox + 1 < MAX_HITBOXES ? hitbox + 1 : 0
			set_pev(g_FlagEnts[g_Selected], pev_hitbox, hitbox)
			exec_command(SOUND_TRANSFORM)
			paint_hitbox(g_FlagEnts[g_Selected])
			menu_edit_flag()
		}
		else if(key == 5)
			delete_flag(g_Selected)
		else if(key == 7)
			save_and_exit()
	}
}

public set_flagname(id, level, cid) {
	if(!cmd_access(id, level, cid, 1))
		return PLUGIN_HANDLED
	new flagname[16]
	read_argv(1, flagname, 15)
	if(strlen(flagname) && g_Editor == id && g_EditMode && g_Selected > -1) {
		set_pev(g_FlagEnts[g_Selected], pev_flagname, flagname)
		exec_command(SOUND_TRANSFORM)
	}
	return PLUGIN_HANDLED
}


public toggle_csflags_edit(id, level, cid) {
	
	if(!cmd_access(id, level, cid, 1))
		return PLUGIN_HANDLED	
	
	if(g_EditMode) {
		if(id != g_Editor) {
			console_print(id, "%L", id, "MSG_ERROR_BEING_EDITED")
			return PLUGIN_HANDLED
		}
		remove_task(TASKID_FAKE_THINK)
		g_EditMode = 0
		
		g_OptionsMenuCreate[0] = 0
		g_OptionsMenuEdit[0] = 0
		
		if(g_Playing) {
			server_cmd("amx_csflags_restart")
			g_Playing = 0
		}
	}
	else {
		
		if(!id) {
			server_print(MSG_ERROR_INVALID_ID)
			return PLUGIN_HANDLED
		}
		
		new cfgdir[65]
		
		get_configsdir(cfgdir, 64)
		format(cfgdir[strlen(cfgdir)], 65 - strlen(cfgdir), "%s", CSFLAGS_CONFIG_DIR)
		
		if(!dir_exists(cfgdir)) {		
			console_print(id, "%L", id, "MSG_ERROR_DIR_NOT_FOUND")
			return PLUGIN_HANDLED
		}		
		
		if(is_plugin_loaded("csflags")) {
			if (get_xvar_num(get_xvar_id("g_CSFlagsState"))) {
				server_cmd("amx_csflags_stop")
				g_Playing = 1
				client_print(id, print_chat, "%L", id, "MSG_CSFLAGS_STOPPED")
			}
		}
		
		new count
		g_Selected = -1
		g_LastSelected = -1
		g_EditMode = 1
		g_Editor = id
		count = load_config()
		if(count) {
			new msg[64]
			format(msg, 63, "%L", g_Editor, "MSG_LOAD_CFG", count)
			send_msg(msg)
			
		}
		else send_msg("MSG_ERROR_LOAD_CFG", 1)
		set_task(INTERVAL_FAKE_THINK, "fake_think", TASKID_FAKE_THINK, _, _, "b")		
	}
	return PLUGIN_HANDLED
}




save_and_exit() {
	
	new count
	new flag
	remove_task(TASKID_FAKE_THINK)
	g_EditMode = 0	
	count = write_cfg()
	
	if(count) {
		new msg[64]
		format(msg, 63, "%L", g_Editor, "MSG_WRITE_CFG", count)
		send_msg(msg)
		exec_command(SOUND_SAVED)
	}
	else {
		send_msg("MSG_ERROR_WRITE_CFG" , 1)
		exec_command(SOUND_WARNING)
	}
	
	for(new i = 0; i < MAX_CSFLAGS; i++)
		g_FlagEnts[i] = 0
	
	while((flag = engfunc(EngFunc_FindEntityByString, flag, "classname", CLASSNAME_CSFLAG_EDIT)))
		engfunc(EngFunc_RemoveEntity, flag)
	
	if(g_Playing) {
		server_cmd("amx_csflags_restart")
		g_Playing = 0
	}
	
	g_OptionsMenuCreate[0] = 0
	g_OptionsMenuEdit[0] = 0
}

delete_flag(flagid) {
	if(g_FlagEnts[flagid]) {
		engfunc(EngFunc_RemoveEntity, g_FlagEnts[flagid])
		g_FlagEnts[flagid] = 0
		exec_command(SOUND_DELETE)
		if(g_Selected == flagid) {
			g_Selected = -1
			g_LastSelected = -1
		}
	}
}

create_flag() {	
	new flagid = -1
	new flag
	
	for(new i = 0; i < MAX_CSFLAGS; i++) {
		if(g_FlagEnts[i] == 0) {
			flagid = i
			break
		}
	}
	if(flagid > -1) {	
		flag = engfunc(EngFunc_CreateNamedEntity, engfunc(EngFunc_AllocString, "cycler_sprite"))
		if(pev_valid(flag)) {			
			new flagname[16]
			new Float:flagorigin[3]
			format(flagname, 15, "Flag_%d", flagid)
			pev(g_Editor, pev_origin, flagorigin)	
			flagorigin[2] -= 12.0
			engfunc(EngFunc_SetOrigin, flag, flagorigin)
			set_pev(flag, pev_model, MODEL_FLAGS)
			set_pev(flag, pev_framerate, 0)
			set_pev(flag, pev_flagid, flagid)
			dllfunc(DLLFunc_Spawn, flag)
			set_pev(flag, pev_flagname, flagname)
			set_pev(flag, pev_classname, CLASSNAME_CSFLAG_EDIT)
			g_FlagEnts[flagid] = flag
			exec_command(SOUND_CREATE)
		}
	}
	return flag
}

show_info() {
	
	static info[128]		
	new flagname[16]
	
	pev(g_FlagEnts[g_Selected], pev_flagname, flagname, 15)	
	format(info, 127, 
		"Flagname: %s^nHitBox: %s",
		flagname,
		g_HitBoxName[pev(g_FlagEnts[g_Selected], pev_hitbox)])
		
	set_hudmessage (200 , 180 , 0, 0.7, 0.1, 0, 0.1, INTERVAL_FAKE_THINK, 0.0, 0.1, 3)
	show_hudmessage (g_Editor, info)
}

public client_disconnect(id)
{
	if(id == g_Editor && g_EditMode) {
		remove_task(TASKID_FAKE_THINK)
		g_EditMode = 0
		if(g_Playing) {
			server_cmd("amx_csflags_restart")
			g_Playing = 0
		}
	}
}

public fake_think(){
	
	new started
	new minval
	new pmenu
	new nmenu
	
	if(!g_EditMode) {
		remove_task(TASKID_FAKE_THINK)
		return PLUGIN_CONTINUE
	}
	
	player_menu_info(g_Editor, pmenu, nmenu)	
	get_user_origin(g_Editor, g_EditorOrigin, 1)
	
	for (new i = 0; i < MAX_CSFLAGS; i++) {
		
		if(!g_FlagEnts[i])
			continue
		
		new Iorigin[3]
		new Float:Forigin[3]
		
		pev(g_FlagEnts[i], pev_origin, Forigin)		
		FVec_IVec(Forigin, Iorigin)
		
		if(!started) {				
			minval = get_distance(g_EditorOrigin, Iorigin)
			started = 1
			g_Selected = (minval > 300) ? -1 : i			
		}
		else {
			new dist = get_distance(g_EditorOrigin, Iorigin)
			if(dist < minval) {
				minval = dist
				g_Selected = (minval > 400) ? -1 : i	
			}		
		}			
	}
	
	if (g_Selected > -1) {	
		show_info()
		if(pmenu != g_MenuEdit)
			menu_edit_flag()
		if (g_Selected != g_LastSelected){
			if(g_LastSelected > -1) {
				set_pev(g_FlagEnts[g_LastSelected], pev_body, 0)
				set_pev(g_FlagEnts[g_LastSelected], pev_framerate, 0.0)
			}
			set_pev(g_FlagEnts[g_Selected], pev_framerate, 1.0)
			set_pev(g_FlagEnts[g_Selected], pev_body, 2)
			g_LastSelected = g_Selected			
		}		
	}
	else if(pmenu != g_MenuCreate) {
		menu_create_flag()
		if(g_LastSelected > -1) {
			set_pev(g_FlagEnts[g_LastSelected], pev_body, 0)
			set_pev(g_FlagEnts[g_LastSelected], pev_framerate, 0.0)
			g_LastSelected = -1
		}
	}
	
	return PLUGIN_CONTINUE
	
}

get_configfile(file[], len) {
	new map[36]
	get_mapname(map, 35)
	get_configsdir(file, len)
	format(file[strlen(file)], len - strlen(file), FILE_CSFLAGS_CFG, map)
	return file_exists(file)
}

write_cfg() {
	new cfgfile[96]
	new count
	new flag
	while((flag = engfunc(EngFunc_FindEntityByString, flag, "classname", CLASSNAME_CSFLAG_EDIT)))
		count++
	if(!count) {
		send_msg("MSG_ERROR_WRITE_CFG", 1)
		return PLUGIN_HANDLED
	}
	new Float:origin[3]
	new Float:angles[3]
	new flagname[16]
	new line[128]
	new filepointer
	new hitbox
	
	get_configfile(cfgfile, 95)	
	filepointer = fopen(cfgfile, "w+")
	
	if(!filepointer)
		return 0
	
	while((flag = engfunc(EngFunc_FindEntityByString, flag, "classname", CLASSNAME_CSFLAG_EDIT))) {
		
		pev(flag, pev_origin, origin)
		pev(flag, pev_angles, angles)
		pev(flag, pev_flagname, flagname, 15)
		hitbox = pev(flag, pev_hitbox)
		format(line, 127, 
			"^"%s^" ^"%d %d %d %d %d^"^n",
			flagname,
			floatround(origin[0]),
			floatround(origin[1]),
			floatround(origin[2]),
			floatround(angles[1]),
			hitbox)
		
		fputs(filepointer, line)
		
		
	}
	fclose(filepointer)
	
	return count
	
}

load_config() {
	new file[72]
	if(get_configfile(file, 71)) {
		new numbers[5][6]
		new Float:maxsize[3] = {12.0, 6.0, 36.0}
		new Float:minsize[3] = {-12.0, -6.0, -36.0}
		new Float:origin[3]
		new Float:angle[3]
		new line[96]		
		new arg1[16]
		new arg2[80]
		new hitbox
		new count		
		new ent
		new filepointer		
				
		flags_reset()
		filepointer = fopen(file, "r")
		while(fgets(filepointer, line, 95) && count < MAX_CSFLAGS) {
			
			if(!strlen(line) || line[0] == ';')
				continue
			
			parse(line, arg1, 15, arg2, 79)
			
			if(!strlen(arg2))
				continue
			
			parse(	arg2, 
				numbers[0], 5,
				numbers[1], 5,
				numbers[2], 5,
				numbers[3], 5,
				numbers[4], 5)
			
			origin[0] = str_to_float(numbers[0])
			origin[1] = str_to_float(numbers[1])
			origin[2] = str_to_float(numbers[2])
			angle[1] = str_to_float(numbers[3])
			hitbox = (strlen(numbers[4])) ? str_to_num(numbers[4]) : 0
			
			if(hitbox >= MAX_HITBOXES)
				hitbox = 0
			
			engfunc(EngFunc_MakeVectors, angle)
			ent = engfunc(EngFunc_CreateNamedEntity, engfunc(EngFunc_AllocString, "func_wall"))
			if(pev_valid(ent)) {
				if(strlen(arg1)) 
					set_pev(ent, pev_flagname, arg1)
				else {
					format(arg1, 15, "Flag_%d", count)
					set_pev(ent, pev_flagname, arg1)
				}				
				engfunc(EngFunc_SetOrigin, ent, origin)				
				set_pev(ent, pev_model, MODEL_FLAGS)
				set_pev(ent, pev_framerate, 0)				
				dllfunc(DLLFunc_Spawn, ent)
				set_pev(ent, pev_angles, angle)
				engfunc(EngFunc_SetSize, ent, minsize, maxsize)
				set_pev(ent, pev_classname, CLASSNAME_CSFLAG_EDIT)				
				set_pev(ent, pev_flagid, count)
				set_pev(ent, pev_hitbox, hitbox)
				g_FlagEnts[count] = ent
				if(count < MAX_CSFLAGS)
					count++
			}			
		}
		fclose(filepointer)
		if(count) {
			exec_command(SOUND_CREATE)
			return count
		}
	}
	return 0
}

flags_reset() {
	if(is_plugin_loaded("csflags")) {
		new flag
		while((flag = engfunc(EngFunc_FindEntityByString, flag, "classname", CLASSNAME_CSFLAG)))
			engfunc(EngFunc_RemoveEntity, flag)
	}
	for(new i = 0; i < MAX_CSFLAGS; i++) {
		if(pev_valid(g_FlagEnts[i]))
			engfunc(EngFunc_RemoveEntity, g_FlagEnts[i])
		g_FlagEnts[i] = 0
	}
}

exec_command(const command[]) {
	if(g_Editor)
		client_cmd(g_Editor, command)
}

send_msg(const text[], langKey = 0) {
	
	if(g_Editor) {
		if(langKey) {
			static msg[256]
			format(msg, 255, "%L", g_Editor, text)
			client_print(g_Editor, print_chat, msg)
		}
		else client_print(g_Editor, print_chat, text)
	}
}


FVec_IVec(const Float:FVec[3], IVec[3]) {
	// for older than 1.76; compatibility
	// I'm not including engine_stocks because it doesn't use engine module
	IVec[0] = floatround(FVec[0])
	IVec[1] = floatround(FVec[1])
	IVec[2] = floatround(FVec[2])

	return 1
}


// the following functions
// were taken/adapted from brushedit plugin
paint_hitbox(flag)
{	
	static Float:mmsize[3][2][3] = 
	{
		HITBOX_NORMAL,
		HITBOX_LARGER,
		HITBOX_LARGE
	}
	
	new Float:sw
	new Float:sh
	new Float:sd	
	new Float:origin[3]	
	new Float:point1[3]
	new Float:tempx
	new Float:tempy
	new Float:tempz
	new hitbox
	
	hitbox = pev(flag, pev_hitbox)
	pev(flag, pev_origin, origin)
	origin[2] += 48.0
	
	sw = get_2d_distance(mmsize[hitbox][HITBOX_MIN], mmsize[hitbox][HITBOX_MAX], 0)
	sh = get_2d_distance(mmsize[hitbox][HITBOX_MIN], mmsize[hitbox][HITBOX_MAX], 2)
	sd = get_2d_distance(mmsize[hitbox][HITBOX_MIN], mmsize[hitbox][HITBOX_MAX], 1)
	
	point1[0] = origin[0] - (sw/2)
	point1[1] = origin[1] - (sd/2)
	point1[2] = origin[2] + (sh/2)
	
	copy_vector(point1, tempx, tempy, tempz)
	
	draw_line(point1, tempx + sw, tempy, tempz)
	draw_line(point1, tempx, tempy + sd, tempz)
	draw_line(point1, tempx, tempy, tempz - sh)
	
	point1[1] = origin[1] + (sd/2)
	point1[2] = origin[2] - (sh/2)
	
	copy_vector(point1, tempx, tempy, tempz)
	
	draw_line(point1, tempx + sw, tempy, tempz)
	draw_line(point1, tempx, tempy - sd, tempz)
	draw_line(point1, tempx, tempy, tempz + sh)
	
	point1[0] = origin[0] + (sw/2)
	point1[2] = origin[2] + (sh/2)
	
	copy_vector(point1, tempx, tempy, tempz)
	
	draw_line(point1, tempx - sw, tempy, tempz)
	draw_line(point1, tempx, tempy - sd, tempz)
	draw_line(point1, tempx, tempy, tempz - sh)
	
	point1[1] = origin[1] - (sd/2)
	point1[2] = origin[2] - (sh/2)
	
	copy_vector(point1, tempx, tempy, tempz)
	
	draw_line(point1, tempx - sw, tempy, tempz)
	draw_line(point1, tempx, tempy + sd, tempz)
	draw_line(point1, tempx, tempy, tempz + sh)
	
}

Float:get_2d_distance(Float:vec1[3], Float:vec2[3], id)
{
	return floatabs(vec2[id] - vec1[id])
}

copy_vector(const Float:src[3], &Float:x, &Float:y, &Float:z){	
	x = src[0]
	y = src[1]
	z = src[2]	
}


draw_line(const Float:point1[3], Float:x, Float:y, Float:z)
{			
	message_begin( MSG_BROADCAST,SVC_TEMPENTITY) 
	write_byte ( 0 )     						//TE_BEAMPOINTS 0
	write_coord (floatround(x))
	write_coord (floatround(y))
	write_coord (floatround(z))
	write_coord (floatround(point1[0]))
	write_coord (floatround(point1[1]))
	write_coord (floatround(point1[2]))
	write_short(sprite_line)
	write_byte (0)      						// start frame 
	write_byte (15)     						// frame rate in 0.1's 
	write_byte (6)     						// byte (life in 0.1's 
	write_byte (20)   						// line width in 0.1's
	write_byte (1)      						// noise amplitude in 0.01's 
	write_byte (20) 						// RGB color
	write_byte (20)
	write_byte (255)
	write_byte (255)     						// brightness
	write_byte (1)      						// scroll speed in 0.1's
	message_end()	
}
